/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.jdbc.internal.shaded.jooq.Catalog;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.DDLExportConfiguration;
import org.neo4j.jdbc.internal.shaded.jooq.Queries;
import org.neo4j.jdbc.internal.shaded.jooq.Schema;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.UniqueKey;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataAccessException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractMeta;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DDL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.InformationSchemaExport;
import org.neo4j.jdbc.internal.shaded.jooq.util.xml.jaxb.InformationSchema;

final class TableMetaImpl
extends AbstractMeta {
    private final Table<?>[] tables;

    TableMetaImpl(Configuration configuration, Table<?>[] tables) {
        super(configuration);
        this.tables = tables;
    }

    @Override
    final AbstractMeta filtered0(Predicate<? super Catalog> catalogFilter, Predicate<? super Schema> schemaFilter) {
        return this;
    }

    @Override
    final List<Catalog> getCatalogs0() {
        LinkedHashSet<Catalog> result = new LinkedHashSet<Catalog>();
        for (Table<?> table : this.tables) {
            if (table.getSchema() == null || table.getSchema().getCatalog() == null) continue;
            result.add(table.getSchema().getCatalog());
        }
        return new ArrayList<Catalog>(result);
    }

    @Override
    final List<Schema> getSchemas0() {
        LinkedHashSet<Schema> result = new LinkedHashSet<Schema>();
        for (Table<?> table : this.tables) {
            if (table.getSchema() == null) continue;
            result.add(table.getSchema());
        }
        return new ArrayList<Schema>(result);
    }

    @Override
    final List<Table<?>> getTables0() {
        return Collections.unmodifiableList(Arrays.asList(this.tables));
    }

    @Override
    final List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.tables) {
            if (table.getPrimaryKey() == null) continue;
            result.add(table.getPrimaryKey());
        }
        return result;
    }

    @Override
    public Queries ddl(DDLExportConfiguration exportConfiguration) throws DataAccessException {
        return new DDL(this.dsl(), exportConfiguration).queries(this.tables);
    }

    @Override
    public InformationSchema informationSchema() throws DataAccessException {
        return InformationSchemaExport.exportTables(this.configuration(), this.getTables());
    }
}

