/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.neo4j.jdbc.values.ArrayBasedVectors;
import org.neo4j.jdbc.values.AsValue;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.VectorValue;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Vector
extends AsValue {
    public static final int MAX_VECTOR_SIZE = 4096;
    public static final AtomicBoolean CHECK_UPPER_RANGE = new AtomicBoolean(true);

    public ElementType elementType();

    public int size();

    default public int vectorDimensionCount() {
        return this.size();
    }

    @Override
    default public Value asValue() {
        return new VectorValue(this);
    }

    public Stream<? extends Number> stream();

    private static void assertSize(int size) {
        if (size <= 0 || size > 4096 && CHECK_UPPER_RANGE.get()) {
            throw new IllegalArgumentException("'%d' is not a valid value. Must be a %s in the range %d to %d (GQL 42N31)".formatted(size, "number", 1, 4096));
        }
    }

    public static Vector of(byte[] elements) {
        Vector.assertSize(Objects.requireNonNull(elements, "Vector elements must not be literal null").length);
        return new ArrayBasedVectors.Int8VectorImpl(ElementType.INTEGER8, elements.length, Arrays.copyOf(elements, elements.length));
    }

    public static Vector of(short[] elements) {
        Vector.assertSize(Objects.requireNonNull(elements, "Vector elements must not be literal null").length);
        return new ArrayBasedVectors.Int16VectorImpl(ElementType.INTEGER16, elements.length, Arrays.copyOf(elements, elements.length));
    }

    public static Vector of(int[] elements) {
        Vector.assertSize(Objects.requireNonNull(elements, "Vector elements must not be literal null").length);
        return new ArrayBasedVectors.Int32VectorImpl(ElementType.INTEGER32, elements.length, Arrays.copyOf(elements, elements.length));
    }

    public static Vector of(long[] elements) {
        Vector.assertSize(Objects.requireNonNull(elements, "Vector elements must not be literal null").length);
        return new ArrayBasedVectors.Int64VectorImpl(ElementType.INTEGER, elements.length, Arrays.copyOf(elements, elements.length));
    }

    public static Vector of(float[] elements) {
        Vector.assertSize(Objects.requireNonNull(elements, "Vector elements must not be literal null").length);
        return new ArrayBasedVectors.Float32VectorImpl(ElementType.FLOAT32, elements.length, Arrays.copyOf(elements, elements.length));
    }

    public static Vector of(double[] elements) {
        Vector.assertSize(Objects.requireNonNull(elements, "Vector elements must not be literal null").length);
        return new ArrayBasedVectors.Float64VectorImpl(ElementType.FLOAT, elements.length, Arrays.copyOf(elements, elements.length));
    }

    public static enum ElementType {
        INTEGER8(Byte.TYPE),
        INTEGER16(Short.TYPE),
        INTEGER32(Integer.TYPE),
        INTEGER(Long.TYPE),
        FLOAT32(Float.TYPE),
        FLOAT(Double.TYPE);

        private final Class<?> javaType;

        private ElementType(Class<?> javaType) {
            this.javaType = javaType;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Float64Vector
    extends Vector {
        public double[] toArray();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Float32Vector
    extends Vector {
        public float[] toArray();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Int64Vector
    extends Vector {
        public long[] toArray();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Int32Vector
    extends Vector {
        public int[] toArray();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Int16Vector
    extends Vector {
        public short[] toArray();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Int8Vector
    extends Vector {
        public byte[] toArray();
    }
}

