/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.ProcInstParser;
import net.sf.saxon.trans.XPathException;

public class PIGrabber
extends ProxyReceiver {
    private Configuration config = null;
    private String reqMedia = null;
    private String reqTitle = null;
    private String baseURI = null;
    private URIResolver uriResolver = null;
    private ArrayList stylesheets = new ArrayList();
    private boolean terminated = false;

    public void setFactory(Configuration config) {
        this.config = config;
    }

    public void setCriteria(String media, String title, String charset) {
        this.reqMedia = media;
        this.reqTitle = title;
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public void open() {
        this.nextReceiver = new Sink();
    }

    public void startElement(int namecode, int typecode, int locationId, int properties) throws XPathException {
        this.terminated = true;
        throw new XPathException("#start#");
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (target.equals("xml-stylesheet")) {
            String value = data.toString();
            String piMedia = ProcInstParser.getPseudoAttribute(value, "media");
            String piTitle = ProcInstParser.getPseudoAttribute(value, "title");
            String piType = ProcInstParser.getPseudoAttribute(value, "type");
            String piAlternate = ProcInstParser.getPseudoAttribute(value, "alternate");
            if (piType == null) {
                return;
            }
            if ((piType.equals("text/xml") || piType.equals("application/xml") || piType.equals("text/xsl") || piType.equals("applicaton/xsl") || piType.equals("application/xml+xslt")) && (this.reqMedia == null || piMedia == null || this.reqMedia.equals(piMedia)) && (piTitle == null && (piAlternate == null || piAlternate.equals("no")) || this.reqTitle == null || piTitle != null && piTitle.equals(this.reqTitle))) {
                String href = ProcInstParser.getPseudoAttribute(value, "href");
                if (href == null) {
                    throw new XPathException("xml-stylesheet PI has no href attribute");
                }
                if (piTitle == null && (piAlternate == null || piAlternate.equals("no"))) {
                    this.stylesheets.add(0, href);
                } else {
                    this.stylesheets.add(href);
                }
            }
        }
    }

    public Source[] getAssociatedStylesheets() throws TransformerException {
        if (this.stylesheets.size() == 0) {
            return null;
        }
        if (this.uriResolver == null) {
            this.uriResolver = new StandardURIResolver(this.config);
        }
        Source[] result = new Source[this.stylesheets.size()];
        for (int i = 0; i < this.stylesheets.size(); ++i) {
            String href = (String)this.stylesheets.get(i);
            Source s = this.uriResolver.resolve(href, this.baseURI);
            if (s instanceof SAXSource) {
                ((SAXSource)s).setXMLReader(this.config.getStyleParser());
            }
            if (s == null) {
                s = this.config.getSystemURIResolver().resolve(href, this.baseURI);
            }
            result[i] = s;
        }
        return result;
    }
}

