/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public abstract class SimpleNodeConstructor
extends Instruction {
    protected Expression select = null;

    public void setSelect(Expression select, Configuration config) throws XPathException {
        this.select = select;
        this.adoptChildExpression(select);
    }

    public Expression getSelect() {
        return this.select;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.select != null) {
            this.select = visitor.simplify(this.select);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public abstract void localTypeCheck(ExpressionVisitor var1, ItemType var2) throws XPathException;

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.localTypeCheck(visitor, contextItemType);
        if (this.select != null) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            this.select = visitor.typeCheck(this.select, contextItemType);
            if (!this.select.getItemType(th).isAtomicType()) {
                this.select = new Atomizer(this.select, visitor.getConfiguration()).simplify(visitor);
            }
            if (!th.isSubType(this.select.getItemType(th), BuiltInAtomicType.STRING)) {
                this.select = new AtomicSequenceConverter(this.select, BuiltInAtomicType.STRING);
            }
            this.adoptChildExpression(this.select);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.optimize(this.select, contextItemType);
            this.adoptChildExpression(this.select);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        return found;
    }

    public CharSequence expandChildren(XPathContext context) throws XPathException {
        Item item = this.select.evaluateItem(context);
        if (item == null) {
            return "";
        }
        return item.getStringValueCS();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        String content = this.select == null ? "" : this.select.evaluateAsString(context).toString();
        content = this.checkContent(content, context);
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        Orphan o = new Orphan(context.getConfiguration());
        o.setNodeKind((short)this.getItemType(th).getPrimitiveType());
        o.setStringValue(content);
        o.setNameCode(this.evaluateNameCode(context));
        return o;
    }

    protected String checkContent(String data, XPathContext context) throws XPathException {
        return data;
    }

    public int evaluateNameCode(XPathContext context) throws XPathException {
        return -1;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return SingletonIterator.makeIterator(this.evaluateItem(context));
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.select != null) {
            this.select = this.doPromotion(this.select, offer);
        }
        super.promoteInst(offer);
    }
}

