/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class StaticQueryContext {
    private Configuration config;
    private NamePool namePool;
    private String baseURI;
    private HashMap userDeclaredNamespaces;
    private Executable executable;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private int constructionMode = 3;
    private NamespaceResolver externalNamespaceResolver = null;
    private CollationMap collations;
    private String defaultFunctionNamespace;
    private String defaultElementNamespace;
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private boolean preserveSpace = false;
    private boolean defaultEmptyLeast = true;
    private ModuleURIResolver moduleURIResolver;
    private ErrorListener errorListener;
    private boolean tracing;
    private boolean generateCode = false;

    protected StaticQueryContext() {
    }

    public StaticQueryContext(Configuration config) {
        this.config = config;
        this.namePool = config.getNamePool();
        this.errorListener = config.getErrorListener();
        this.moduleURIResolver = config.getModuleURIResolver();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.collations = new CollationMap(config);
        this.reset();
    }

    public void reset() {
        this.userDeclaredNamespaces = new HashMap(10);
        this.externalNamespaceResolver = null;
        this.collations = new CollationMap(this.config);
        this.errorListener = this.config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.constructionMode = this.getConfiguration().isSchemaAware(51) ? 3 : 4;
        this.preserveSpace = false;
        this.defaultEmptyLeast = true;
        this.requiredContextItemType = AnyItemType.getInstance();
        this.defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
        this.defaultElementNamespace = "";
        this.moduleURIResolver = this.config.getModuleURIResolver();
        this.collations.setDefaultCollationName("http://www.w3.org/2005/xpath-functions/collation/codepoint");
        this.clearNamespaces();
        this.generateCode = false;
    }

    public void setConfiguration(Configuration config) {
        if (this.config != null && this.config != config) {
            throw new IllegalArgumentException("Configuration cannot be changed dynamically");
        }
        this.config = config;
        this.namePool = config.getNamePool();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        return this.config.buildDocument(source);
    }

    public boolean isCompileWithTracing() {
        return this.tracing;
    }

    public void setCompileWithTracing(boolean trace) {
        this.tracing = trace;
    }

    public void setGeneratingJavaCode(boolean generateCode) {
        this.generateCode = generateCode;
    }

    public boolean isGeneratingJavaCode() {
        return this.generateCode;
    }

    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean inherit) {
        this.preserveNamespaces = inherit;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void setConstructionMode(int mode) {
        this.constructionMode = mode;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public XQueryExpression compileQuery(String query) throws XPathException {
        QueryParser qp = new QueryParser();
        qp.setCompileWithTracing(this.isCompileWithTracing() || this.config.isCompileWithTracing());
        QueryModule mainModule = new QueryModule(this);
        mainModule.setExecutable(this.executable);
        return qp.makeXQueryExpression(query, mainModule, this.config);
    }

    public XQueryExpression compileQuery(Reader source) throws XPathException, IOException {
        int n;
        char[] buffer = new char[4096];
        StringBuffer sb = new StringBuffer(4096);
        while ((n = source.read(buffer)) > 0) {
            sb.append(buffer, 0, n);
        }
        return this.compileQuery(sb.toString());
    }

    public XQueryExpression compileQuery(InputStream source, String encoding) throws XPathException, IOException {
        String query = QueryReader.readInputStream(source, encoding, this.config.getNameChecker());
        return this.compileQuery(query);
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new IllegalArgumentException("Misdeclaration of XML namespace");
        }
        if (prefix.length() == 0) {
            String string = this.defaultElementNamespace = uri == null ? "" : uri;
        }
        if (uri.length() == 0 && prefix.length() != 0) {
            this.userDeclaredNamespaces.remove(prefix);
        } else {
            this.userDeclaredNamespaces.put(prefix, uri);
            this.namePool.allocateNamespaceCode(prefix, uri);
        }
    }

    public void declarePassiveNamespace(String prefix, String uri, boolean explicit) throws XPathException {
        if (explicit) {
            throw new IllegalArgumentException("explicit must be false");
        }
        this.declareNamespace(prefix, uri);
    }

    public void clearNamespaces() {
        this.userDeclaredNamespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
        this.declareNamespace("local", "http://www.w3.org/2005/xquery-local-functions");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("", "");
    }

    protected HashMap getUserDeclaredNamespaces() {
        return this.userDeclaredNamespaces;
    }

    public void clearPassiveNamespaces() {
        this.clearNamespaces();
    }

    public Iterator iterateDeclaredPrefixes() {
        return this.userDeclaredNamespaces.keySet().iterator();
    }

    public String getNamespaceForPrefix(String prefix) {
        return (String)this.userDeclaredNamespaces.get(prefix);
    }

    public void setExternalNamespaceResolver(NamespaceResolver resolver) {
        this.externalNamespaceResolver = resolver;
    }

    public NamespaceResolver getExternalNamespaceResolver() {
        return this.externalNamespaceResolver;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String defaultFunctionNamespace) {
        this.defaultFunctionNamespace = defaultFunctionNamespace;
    }

    public void setDefaultElementNamespace(String uri) throws XPathException {
        this.defaultElementNamespace = uri;
        this.declareNamespace("", uri);
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void declareCollation(String name, Comparator comparator) {
        this.declareCollation(name, new NamedCollation(name, comparator));
    }

    public void declareCollation(String name, StringCollator comparator) {
        this.collations.setNamedCollation(name, comparator);
    }

    public void declareDefaultCollation(String name) {
        this.collations.setDefaultCollationName(name);
    }

    public StringCollator getCollation(String name) {
        return this.collations.getNamedCollation(name);
    }

    public CollationMap getCollationMap() {
        return this.collations;
    }

    public String getDefaultCollationName() {
        return this.collations.getDefaultCollationName();
    }

    public CollationMap getAllCollations() {
        return new CollationMap(this.collations);
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setPreserveBoundarySpace(boolean preserve) {
        this.preserveSpace = preserve;
    }

    public boolean isPreserveBoundarySpace() {
        return this.preserveSpace;
    }

    public void setEmptyLeast(boolean least) {
        this.defaultEmptyLeast = least;
    }

    public boolean isEmptyLeast() {
        return this.defaultEmptyLeast;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        if (this.errorListener == null) {
            this.errorListener = this.config.getErrorListener();
        }
        return this.errorListener;
    }
}

