/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLOutput
extends StyleElement {
    private StructuredQName outputFormatName;
    private String method = null;
    private String version = null;
    private String indent = null;
    private String encoding = null;
    private String mediaType = null;
    private String doctypeSystem = null;
    private String doctypePublic = null;
    private String omitDeclaration = null;
    private String standalone = null;
    private String cdataElements = null;
    private String includeContentType = null;
    private String nextInChain = null;
    private String suppressIndentation = null;
    private String representation = null;
    private String indentSpaces = null;
    private String byteOrderMark = null;
    private String escapeURIAttributes = null;
    private String normalizationForm = null;
    private String requireWellFormed = null;
    private String undeclareNamespaces = null;
    private String useCharacterMaps = null;
    private HashMap userAttributes = null;

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("method")) {
                this.method = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("version")) {
                this.version = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("byte-order-mark")) {
                this.byteOrderMark = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("encoding")) {
                this.encoding = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("omit-xml-declaration")) {
                this.omitDeclaration = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("standalone")) {
                this.standalone = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("doctype-public")) {
                this.doctypePublic = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("doctype-system")) {
                this.doctypeSystem = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("cdata-section-elements")) {
                this.cdataElements = atts.getValue(a);
                continue;
            }
            if (f.equals("indent")) {
                this.indent = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("media-type")) {
                this.mediaType = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("include-content-type")) {
                this.includeContentType = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("normalization-form")) {
                this.normalizationForm = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("escape-uri-attributes")) {
                this.escapeURIAttributes = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-character-maps")) {
                this.useCharacterMaps = atts.getValue(a);
                continue;
            }
            if (f.equals("undeclare-prefixes")) {
                this.undeclareNamespaces = atts.getValue(a);
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}character-representation")) {
                this.representation = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}indent-spaces")) {
                this.indentSpaces = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}suppress-indentation")) {
                this.suppressIndentation = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}next-in-chain")) {
                this.nextInChain = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}require-well-formed")) {
                this.requireWellFormed = Whitespace.trim(atts.getValue(a));
                continue;
            }
            String attributeURI = this.getNamePool().getURI(nc);
            if ("".equals(attributeURI) || "http://www.w3.org/1999/XSL/Transform".equals(attributeURI) || "http://saxon.sf.net/".equals(attributeURI)) {
                this.checkUnknownAttribute(nc);
                continue;
            }
            String name = '{' + attributeURI + '}' + atts.getLocalName(a);
            if (this.userAttributes == null) {
                this.userAttributes = new HashMap(5);
            }
            this.userAttributes.put(name, atts.getValue(a));
        }
        if (nameAtt != null) {
            try {
                this.outputFormatName = this.makeQName(nameAtt);
            }
            catch (NamespaceException err) {
                this.compileError(err.getMessage(), "XTSE1570");
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), "XTSE1570");
            }
        }
    }

    public StructuredQName getFormatQName() {
        return this.outputFormatName;
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    public Expression compile(Executable exec) {
        return null;
    }

    protected void gatherOutputProperties(Properties details, HashMap precedences) throws XPathException {
        String uri;
        String[] parts;
        String displayname;
        StringTokenizer st;
        String s;
        String existing;
        if (this.method != null) {
            if (this.method.equals("xml") || this.method.equals("html") || this.method.equals("text") || this.method.equals("xhtml")) {
                this.checkAndPut("method", this.method, details, precedences);
            } else {
                try {
                    String[] parts2 = this.getConfiguration().getNameChecker().getQNameParts(this.method);
                    String prefix = parts2[0];
                    if (prefix.length() == 0) {
                        this.compileError("method must be xml, html, xhtml, or text, or a prefixed name", "XTSE1570");
                    } else {
                        String uri2 = this.getURIForPrefix(prefix, false);
                        if (uri2 == null) {
                            this.undeclaredNamespaceError(prefix, "XTSE0280");
                        }
                        this.checkAndPut("method", '{' + uri2 + '}' + parts2[1], details, precedences);
                    }
                }
                catch (QNameException e) {
                    this.compileError("Invalid method name. " + e.getMessage(), "XTSE1570");
                }
            }
        }
        if (this.byteOrderMark != null) {
            if (this.byteOrderMark.equals("yes") || this.byteOrderMark.equals("no")) {
                this.checkAndPut("byte-order-mark", this.byteOrderMark, details, precedences);
            } else {
                this.compileError("byte-order-mark value must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.version != null) {
            this.checkAndPut("version", this.version, details, precedences);
        }
        if (this.indent != null) {
            if (this.indent.equals("yes") || this.indent.equals("no")) {
                this.checkAndPut("indent", this.indent, details, precedences);
            } else {
                this.compileError("indent value must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.indentSpaces != null) {
            try {
                Integer.parseInt(this.indentSpaces);
                details.setProperty("indent", "yes");
                this.checkAndPut("{http://saxon.sf.net/}indent-spaces", this.indentSpaces, details, precedences);
            }
            catch (NumberFormatException err) {
                this.compileWarning("saxon:indent-spaces must be an integer. Using default value (3).", "SXWN9002");
            }
        }
        if (this.suppressIndentation != null) {
            existing = details.getProperty("{http://saxon.sf.net/}suppress-indentation");
            if (existing == null) {
                existing = "";
            }
            s = "";
            st = new StringTokenizer(this.suppressIndentation, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                displayname = st.nextToken();
                try {
                    parts = this.getConfiguration().getNameChecker().getQNameParts(displayname);
                    uri = this.getURIForPrefix(parts[0], true);
                    if (uri == null) {
                        this.undeclaredNamespaceError(parts[0], "XTSE0280");
                    }
                    s = s + " {" + uri + '}' + parts[1];
                }
                catch (QNameException err) {
                    this.compileError("Invalid element name. " + err.getMessage(), "XTSE0280");
                }
                details.setProperty("{http://saxon.sf.net/}suppress-indentation", existing + s);
            }
        }
        if (this.encoding != null) {
            this.checkAndPut("encoding", this.encoding, details, precedences);
        }
        if (this.mediaType != null) {
            this.checkAndPut("media-type", this.mediaType, details, precedences);
        }
        if (this.doctypeSystem != null) {
            this.checkAndPut("doctype-system", this.doctypeSystem, details, precedences);
        }
        if (this.doctypePublic != null) {
            this.checkAndPut("doctype-public", this.doctypePublic, details, precedences);
        }
        if (this.omitDeclaration != null) {
            if (this.omitDeclaration.equals("yes") || this.omitDeclaration.equals("no")) {
                this.checkAndPut("omit-xml-declaration", this.omitDeclaration, details, precedences);
            } else {
                this.compileError("omit-xml-declaration attribute must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.standalone != null) {
            if (this.standalone.equals("yes") || this.standalone.equals("no") || this.standalone.equals("omit")) {
                this.checkAndPut("standalone", this.standalone, details, precedences);
            } else {
                this.compileError("standalone attribute must be 'yes' or 'no' or 'omit'", "XTSE0020");
            }
        }
        if (this.cdataElements != null) {
            existing = details.getProperty("cdata-section-elements");
            if (existing == null) {
                existing = "";
            }
            s = "";
            st = new StringTokenizer(this.cdataElements, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                displayname = st.nextToken();
                try {
                    parts = this.getConfiguration().getNameChecker().getQNameParts(displayname);
                    uri = this.getURIForPrefix(parts[0], true);
                    if (uri == null) {
                        this.undeclaredNamespaceError(parts[0], "XTSE0280");
                    }
                    s = s + " {" + uri + '}' + parts[1];
                }
                catch (QNameException err) {
                    this.compileError("Invalid CDATA element name. " + err.getMessage(), "XTSE0280");
                }
                details.setProperty("cdata-section-elements", existing + s);
            }
        }
        if (this.normalizationForm != null && !this.normalizationForm.equals("none")) {
            if (Name11Checker.getInstance().isValidNmtoken(this.normalizationForm)) {
                this.checkAndPut("normalization-form", this.normalizationForm, details, precedences);
            } else {
                this.compileError("normalization-form must a valid NMTOKEN", "XTSE0020");
            }
        }
        if (this.undeclareNamespaces != null) {
            if (this.undeclareNamespaces.equals("yes") || this.undeclareNamespaces.equals("no")) {
                this.checkAndPut("undeclare-prefixes", this.undeclareNamespaces, details, precedences);
            } else {
                this.compileError("undeclare-namespaces value must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.useCharacterMaps != null) {
            String s2 = XSLOutput.prepareCharacterMaps(this, this.useCharacterMaps, details);
            details.setProperty("use-character-maps", s2);
        }
        if (this.representation != null) {
            this.checkAndPut("{http://saxon.sf.net/}character-representation", this.representation, details, precedences);
        }
        if (this.includeContentType != null) {
            if (this.includeContentType.equals("yes") || this.includeContentType.equals("no")) {
                this.checkAndPut("include-content-type", this.includeContentType, details, precedences);
            } else {
                this.compileError("include-content-type attribute must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.escapeURIAttributes != null) {
            if (this.escapeURIAttributes.equals("yes") || this.escapeURIAttributes.equals("no")) {
                this.checkAndPut("escape-uri-attributes", this.escapeURIAttributes, details, precedences);
            } else {
                this.compileError("escape-uri-attributes value must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.nextInChain != null) {
            this.checkAndPut("{http://saxon.sf.net/}next-in-chain", this.nextInChain, details, precedences);
            this.checkAndPut("{http://saxon.sf.net/}next-in-chain-base-uri", this.getSystemId(), details, precedences);
        }
        if (this.requireWellFormed != null) {
            if (this.requireWellFormed.equals("yes") || this.requireWellFormed.equals("no")) {
                this.checkAndPut("{http://saxon.sf.net/}require-well-formed", this.requireWellFormed, details, precedences);
            } else {
                this.compileWarning("saxon:require-well-formed value must be 'yes' or 'no' (treated as no)", "SXWN9003");
            }
        }
        if (this.userAttributes != null) {
            for (String attName : this.userAttributes.keySet()) {
                String data = (String)this.userAttributes.get(attName);
                details.setProperty(attName, data);
            }
        }
    }

    public void checkAndPut(String property, String value, Properties props, HashMap precedences) throws XPathException {
        String old = props.getProperty(property);
        if (old == null) {
            props.setProperty(property, value);
            precedences.put(property, new Integer(this.getPrecedence()));
        } else if (!old.equals(value)) {
            Integer oldPrec = (Integer)precedences.get(property);
            if (oldPrec == null) {
                return;
            }
            int op = oldPrec;
            if (op <= this.getPrecedence()) {
                if (op == this.getPrecedence()) {
                    this.compileError("Conflicting values for output property " + property, "XTSE1560");
                } else {
                    throw new IllegalStateException("Output properties must be processed in decreasing precedence order");
                }
            }
        }
    }

    public static String prepareCharacterMaps(StyleElement element, String useCharacterMaps, Properties details) throws XPathException {
        XSLStylesheet principal = element.getPrincipalStylesheet();
        String existing = details.getProperty("use-character-maps");
        if (existing == null) {
            existing = "";
        }
        String s = "";
        StringTokenizer st = new StringTokenizer(useCharacterMaps, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            String displayname = st.nextToken();
            try {
                StructuredQName qName = element.makeQName(displayname);
                XSLCharacterMap ref = principal.getCharacterMap(qName);
                if (ref == null) {
                    element.compileError("No character-map named '" + displayname + "' has been defined", "XTSE1590");
                }
                s = s + " " + qName.getClarkName();
            }
            catch (NamespaceException err) {
                element.undeclaredNamespaceError(err.getPrefix(), "XTSE0280");
            }
        }
        existing = s + existing;
        return existing;
    }
}

