/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.impl.BaseIndexedToByteConverter;
import java.nio.ByteBuffer;

public final class EightBitIndexed {
    private EightBitIndexed() {
    }

    public static Getter createGetter(int[] nArray, AlphaType alphaType) {
        return new Getter(nArray, alphaType);
    }

    public static ByteToBytePixelConverter createToByteRgb(Getter getter, BytePixelSetter bytePixelSetter) {
        return new ToByteRgbConverter(getter, bytePixelSetter);
    }

    public static ByteToBytePixelConverter createToByteBgraAny(Getter getter, BytePixelSetter bytePixelSetter) {
        return new ToByteBgraAnyConverter(getter, bytePixelSetter);
    }

    public static class Getter
    extends BaseIndexedToByteConverter.IndexedGetter {
        Getter(int[] nArray, AlphaType alphaType) {
            super(nArray, alphaType);
        }

        @Override
        public int getNumElements() {
            return 8;
        }

        @Override
        public int getArgb(byte[] byArray, int n) {
            return this.preColors[byArray[n]];
        }

        @Override
        public int getArgbPre(byte[] byArray, int n) {
            return this.nonPreColors[byArray[n]];
        }

        @Override
        public int getArgb(ByteBuffer byteBuffer, int n) {
            return this.preColors[byteBuffer.get(n)];
        }

        @Override
        public int getArgbPre(ByteBuffer byteBuffer, int n) {
            return this.nonPreColors[byteBuffer.get(n)];
        }
    }

    public static class ToByteRgbConverter
    extends BaseIndexedToByteConverter {
        public ToByteRgbConverter(Getter getter, BytePixelSetter bytePixelSetter) {
            super(getter, bytePixelSetter);
        }

        @Override
        void doConvert(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, int n6) {
            int[] nArray = this.getGetter().nonPreColors;
            n4 -= n5 * 3;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = nArray[byArray[n + i]];
                    byArray2[n3++] = (byte)(n7 >> 16);
                    byArray2[n3++] = (byte)(n7 >> 8);
                    byArray2[n3++] = (byte)n7;
                }
                n += n2;
                n3 += n4;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4, int n5, int n6) {
            int[] nArray = this.getGetter().nonPreColors;
            n4 -= n5 * 3;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = nArray[byteBuffer.get(n + i)];
                    byteBuffer2.put(n3, (byte)(n7 >> 16));
                    byteBuffer2.put(n3 + 1, (byte)(n7 >> 8));
                    byteBuffer2.put(n3 + 2, (byte)n7);
                    n3 += 3;
                }
                n += n2;
                n3 += n4;
            }
        }
    }

    public static class ToByteBgraAnyConverter
    extends BaseIndexedToByteConverter {
        public ToByteBgraAnyConverter(Getter getter, BytePixelSetter bytePixelSetter) {
            super(getter, bytePixelSetter);
        }

        @Override
        void doConvert(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, int n6) {
            int[] nArray = switch (this.setter.getAlphaType()) {
                default -> throw new MatchException(null, null);
                case AlphaType.OPAQUE, AlphaType.NONPREMULTIPLIED -> this.getGetter().nonPreColors;
                case AlphaType.PREMULTIPLIED -> this.getGetter().preColors;
            };
            n4 -= n5 * 4;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = nArray[byArray[n + i]];
                    byArray2[n3++] = (byte)n7;
                    byArray2[n3++] = (byte)(n7 >> 8);
                    byArray2[n3++] = (byte)(n7 >> 16);
                    byArray2[n3++] = (byte)(n7 >> 24);
                }
                n += n2;
                n3 += n4;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4, int n5, int n6) {
            int[] nArray = switch (this.setter.getAlphaType()) {
                default -> throw new MatchException(null, null);
                case AlphaType.OPAQUE, AlphaType.NONPREMULTIPLIED -> this.getGetter().nonPreColors;
                case AlphaType.PREMULTIPLIED -> this.getGetter().preColors;
            };
            n4 -= n5 * 4;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = nArray[byteBuffer.get(n + i)];
                    byteBuffer2.put(n3, (byte)n7);
                    byteBuffer2.put(n3 + 1, (byte)(n7 >> 8));
                    byteBuffer2.put(n3 + 2, (byte)(n7 >> 16));
                    byteBuffer2.put(n3 + 3, (byte)(n7 >> 24));
                    n3 += 4;
                }
                n += n2;
                n3 += n4;
            }
        }
    }
}

