/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class GitHubEnvRecipe
extends Recipe {
    private static final Set<String> DANGEROUS_TRIGGERS = new HashSet<String>(Arrays.asList("pull_request_target", "workflow_run"));
    private static final Pattern GITHUB_ENV_WRITE_PATTERN = Pattern.compile("(?i)(>>?\\s*[\"']?\\$\\{?GITHUB_ENV\\}?[\"']?|>>?\\s*[\"']?%GITHUB_ENV%[\"']?|>>?\\s*[\"']?\\$env:GITHUB_ENV[\"']?|Out-File.*\\$env:GITHUB_ENV|Add-Content.*\\$env:GITHUB_ENV|Set-Content.*\\$env:GITHUB_ENV|Tee-Object.*\\$env:GITHUB_ENV|\\|\\s*tee\\s+[\"']?\\$\\{?GITHUB_ENV\\}?[\"']?)|GITHUB_PATH");
    private static final Pattern STATIC_ECHO_PATTERN = Pattern.compile("^\\s*echo\\s+[\"']?[^$`]*[\"']?\\s*>>", 8);

    public String getDisplayName() {
        return "Find dangerous GITHUB_ENV usage";
    }

    public String getDescription() {
        return "Detects dangerous usage of `GITHUB_ENV` and `GITHUB_PATH` environment files in workflows with risky triggers like `pull_request_target` or `workflow_run`. Writing to these files can allow code injection when the content includes user-controlled data. Based on [zizmor's github-env audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/github_env.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GitHubEnvVisitor();
    }

    @Generated
    public GitHubEnvRecipe() {
    }

    @Generated
    public String toString() {
        return "GitHubEnvRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitHubEnvRecipe)) {
            return false;
        }
        GitHubEnvRecipe other = (GitHubEnvRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitHubEnvRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class GitHubEnvVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private boolean hasDangerousTriggers = false;

        private GitHubEnvVisitor() {
        }

        public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
            this.hasDangerousTriggers = false;
            this.analyzeTriggers(document);
            if (this.hasDangerousTriggers) {
                return super.visitDocument(document, (Object)ctx);
            }
            return document;
        }

        private void analyzeTriggers(Yaml.Document document) {
            if (document.getBlock() instanceof Yaml.Mapping) {
                Yaml.Mapping workflowMapping = (Yaml.Mapping)document.getBlock();
                for (Yaml.Mapping.Entry entry : workflowMapping.getEntries()) {
                    if (!(entry.getKey() instanceof Yaml.Scalar) || !"on".equals(((Yaml.Scalar)entry.getKey()).getValue())) continue;
                    this.hasDangerousTriggers = this.checkForDangerousTriggers(entry.getValue());
                    break;
                }
            }
        }

        private boolean checkForDangerousTriggers(Yaml.Block onValue) {
            block4: {
                block3: {
                    if (onValue instanceof Yaml.Scalar) {
                        String trigger = ((Yaml.Scalar)onValue).getValue();
                        return DANGEROUS_TRIGGERS.contains(trigger);
                    }
                    if (!(onValue instanceof Yaml.Sequence)) break block3;
                    Yaml.Sequence sequence = (Yaml.Sequence)onValue;
                    for (Yaml.Sequence.Entry seqEntry : sequence.getEntries()) {
                        if (!(seqEntry.getBlock() instanceof Yaml.Scalar)) continue;
                        String trigger = ((Yaml.Scalar)seqEntry.getBlock()).getValue();
                        if (!DANGEROUS_TRIGGERS.contains(trigger)) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(onValue instanceof Yaml.Mapping)) break block4;
                Yaml.Mapping mapping = (Yaml.Mapping)onValue;
                for (Yaml.Mapping.Entry triggerEntry : mapping.getEntries()) {
                    if (!(triggerEntry.getKey() instanceof Yaml.Scalar)) continue;
                    String trigger = ((Yaml.Scalar)triggerEntry.getKey()).getValue();
                    if (!DANGEROUS_TRIGGERS.contains(trigger)) continue;
                    return true;
                }
            }
            return false;
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            String runContent;
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (!this.hasDangerousTriggers) {
                return mappingEntry;
            }
            if (this.isRunStepEntry(mappingEntry) && (runContent = this.getRunContent(mappingEntry)) != null && this.usesGitHubEnv(runContent)) {
                String envVar = this.getEnvironmentVariable(runContent);
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)String.format("Write to %s may allow code execution in a workflow with dangerous triggers. This can lead to code injection when the written content includes user-controlled data. Ensure any dynamic content is properly sanitized or avoid writing to environment files in workflows triggered by untrusted events.", envVar));
            }
            return mappingEntry;
        }

        private boolean isRunStepEntry(Yaml.Mapping.Entry entry) {
            return entry.getKey() instanceof Yaml.Scalar && "run".equals(((Yaml.Scalar)entry.getKey()).getValue());
        }

        private String getRunContent(Yaml.Mapping.Entry entry) {
            if (entry.getValue() instanceof Yaml.Scalar) {
                return ((Yaml.Scalar)entry.getValue()).getValue();
            }
            return null;
        }

        private boolean usesGitHubEnv(String runContent) {
            if (!GITHUB_ENV_WRITE_PATTERN.matcher(runContent).find()) {
                return false;
            }
            return !this.isStaticEcho(runContent);
        }

        private boolean isStaticEcho(String runContent) {
            return STATIC_ECHO_PATTERN.matcher(runContent).find() && !runContent.contains("$") && !runContent.contains("`") && !runContent.contains("$(");
        }

        private String getEnvironmentVariable(String runContent) {
            if (runContent.toUpperCase().contains("GITHUB_ENV")) {
                return "GITHUB_ENV";
            }
            if (runContent.toUpperCase().contains("GITHUB_PATH")) {
                return "GITHUB_PATH";
            }
            return "environment file";
        }
    }
}

