/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class TemplateInjectionRecipe
extends Recipe {
    private static final Set<String> DANGEROUS_CONTEXTS = new HashSet<String>(Arrays.asList("github.event.pull_request.title", "github.event.pull_request.body", "github.event.pull_request.head.ref", "github.event.pull_request.head.label", "github.event.pull_request.head.repo.default_branch", "github.event.pull_request.base.ref", "github.event.issue.title", "github.event.issue.body", "github.event.comment.body", "github.event.review.body", "github.event.pages[0].page_name", "github.event.commits[0].message", "github.event.head_commit.message", "github.event.commits[0].author.name", "github.event.commits[0].author.email", "github.head_ref"));
    private static final Pattern STEPS_OUTPUT_PATTERN = Pattern.compile("steps\\.[^.]+\\.outputs\\.[^\\s}]+");
    private static final Set<String> CODE_INJECTION_ACTIONS = new HashSet<String>(Arrays.asList("actions/github-script", "amadevus/pwsh-script", "jannekem/run-python-script-action", "cardinalby/js-eval-action"));
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{\\{([^}]+)\\}\\}");

    public String getDisplayName() {
        return "Find template injection vulnerabilities";
    }

    public String getDescription() {
        return "Find GitHub Actions workflows vulnerable to template injection attacks. These occur when user-controllable input (like pull request titles, issue bodies, or commit messages) is used directly in `run` commands or `script` inputs without proper escaping. Attackers can exploit this to execute arbitrary code. Based on [zizmor's `template-injection` audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/template_injection.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new TemplateInjectionVisitor());
    }

    @Generated
    public TemplateInjectionRecipe() {
    }

    @Generated
    public String toString() {
        return "TemplateInjectionRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateInjectionRecipe)) {
            return false;
        }
        TemplateInjectionRecipe other = (TemplateInjectionRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TemplateInjectionRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class TemplateInjectionVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private TemplateInjectionVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isRunEntry(mappingEntry)) {
                return this.checkRunEntry(mappingEntry);
            }
            if (this.isUsesEntry(mappingEntry)) {
                return this.checkUsesEntry(mappingEntry);
            }
            if (this.isScriptEntry(mappingEntry)) {
                return this.checkScriptEntry(mappingEntry);
            }
            return mappingEntry;
        }

        private boolean isRunEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "run".equals(key.getValue());
        }

        private boolean isUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "uses".equals(key.getValue());
        }

        private boolean isScriptEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "script".equals(key.getValue());
        }

        private Yaml.Mapping.Entry checkRunEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String runCommand = ((Yaml.Scalar)entry.getValue()).getValue();
            String vulnerableContext = this.findVulnerableContext(runCommand);
            if (vulnerableContext != null) {
                String message = vulnerableContext.startsWith("User-controlled input") ? "Potential template injection vulnerability. " + vulnerableContext + " used in run command without proper escaping." : "Potential template injection vulnerability. User-controlled input '" + vulnerableContext + "' used in run command without proper escaping.";
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)message);
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String usesValue = ((Yaml.Scalar)entry.getValue()).getValue();
            for (String dangerousAction : CODE_INJECTION_ACTIONS) {
                if (!usesValue.startsWith(dangerousAction) || !this.hasVulnerableScriptInput()) continue;
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Potential code injection in script input. User-controlled content in script execution context.");
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkScriptEntry(Yaml.Mapping.Entry entry) {
            String vulnerableContext;
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String scriptContent = ((Yaml.Scalar)entry.getValue()).getValue();
            if (this.isInsideCodeInjectionAction() && (vulnerableContext = this.findVulnerableContext(scriptContent)) != null) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)("Potential code injection in script. User-controlled input '" + vulnerableContext + "' used in script without proper escaping."));
            }
            return entry;
        }

        private String findVulnerableContext(String content) {
            Matcher matcher = EXPRESSION_PATTERN.matcher(content);
            while (matcher.find()) {
                String expression = matcher.group(1).trim();
                if (this.isComplexExpression(expression) && this.containsDangerousContextInExpression(expression)) {
                    return "User-controlled input in complex expression";
                }
                for (String dangerousContext : DANGEROUS_CONTEXTS) {
                    if (!expression.contains(dangerousContext)) continue;
                    return dangerousContext;
                }
                Matcher stepsMatcher = STEPS_OUTPUT_PATTERN.matcher(expression);
                if (!stepsMatcher.find()) continue;
                return stepsMatcher.group();
            }
            return null;
        }

        private boolean isComplexExpression(String expression) {
            return expression.contains("(") && expression.contains(")");
        }

        private boolean containsDangerousContextInExpression(String expression) {
            for (String dangerousContext : DANGEROUS_CONTEXTS) {
                if (!expression.contains(dangerousContext)) continue;
                return true;
            }
            return false;
        }

        private boolean hasVulnerableScriptInput() {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return false;
            }
            Yaml.Mapping withMapping = this.findWithMapping(stepMapping);
            if (withMapping == null) {
                return false;
            }
            for (Yaml.Mapping.Entry withEntry : withMapping.getEntries()) {
                Yaml.Scalar key;
                if (!(withEntry.getKey() instanceof Yaml.Scalar) || !"script".equals((key = (Yaml.Scalar)withEntry.getKey()).getValue()) || !(withEntry.getValue() instanceof Yaml.Scalar)) continue;
                String scriptValue = ((Yaml.Scalar)withEntry.getValue()).getValue();
                return this.findVulnerableContext(scriptValue) != null;
            }
            return false;
        }

        private boolean isInsideCodeInjectionAction() {
            Yaml.Mapping stepMapping = this.findParentStepMapping();
            if (stepMapping == null) {
                return false;
            }
            for (Yaml.Mapping.Entry stepEntry : stepMapping.getEntries()) {
                Yaml.Scalar key;
                if (!(stepEntry.getKey() instanceof Yaml.Scalar) || !"uses".equals((key = (Yaml.Scalar)stepEntry.getKey()).getValue()) || !(stepEntry.getValue() instanceof Yaml.Scalar)) continue;
                String usesValue = ((Yaml.Scalar)stepEntry.getValue()).getValue();
                for (String dangerousAction : CODE_INJECTION_ACTIONS) {
                    if (!usesValue.startsWith(dangerousAction)) continue;
                    return true;
                }
            }
            return false;
        }

        private Yaml.Mapping findParentStepMapping() {
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Yaml.Mapping mapping;
                boolean isStep;
                Object value = current.getValue();
                if (!(value instanceof Yaml.Mapping) || !(isStep = (mapping = (Yaml.Mapping)value).getEntries().stream().anyMatch(mapEntry -> {
                    if (mapEntry.getKey() instanceof Yaml.Scalar) {
                        Yaml.Scalar key = (Yaml.Scalar)mapEntry.getKey();
                        return "uses".equals(key.getValue()) || "run".equals(key.getValue());
                    }
                    return false;
                }))) continue;
                return mapping;
            }
            return null;
        }

        private Yaml.Mapping findWithMapping(Yaml.Mapping stepMapping) {
            for (Yaml.Mapping.Entry stepEntry : stepMapping.getEntries()) {
                Yaml.Scalar key;
                if (!(stepEntry.getKey() instanceof Yaml.Scalar) || !"with".equals((key = (Yaml.Scalar)stepEntry.getKey()).getValue()) || !(stepEntry.getValue() instanceof Yaml.Mapping)) continue;
                return (Yaml.Mapping)stepEntry.getValue();
            }
            return null;
        }
    }
}

