/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public final class DeimplementInterface<P>
extends JavaIsoVisitor<P> {
    private final String fullyQualifiedInterfaceName;

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        this.maybeRemoveImport(this.fullyQualifiedInterfaceName);
        return ((J.ClassDeclaration)super.visitClassDeclaration(classDecl, (Object)p)).withImplements(ListUtils.map(classDecl.getImplements(), impl -> TypeUtils.isOfClassType(impl.getType(), this.fullyQualifiedInterfaceName) ? null : impl));
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        if (method.getMethodType() != null && method.getMethodType().isInheritedFrom(this.fullyQualifiedInterfaceName)) {
            return null;
        }
        return super.visitMethodDeclaration(method, (Object)p);
    }

    public DeimplementInterface(String fullyQualifiedInterfaceName) {
        this.fullyQualifiedInterfaceName = fullyQualifiedInterfaceName;
    }

    public String getFullyQualifiedInterfaceName() {
        return this.fullyQualifiedInterfaceName;
    }

    @NonNull
    public String toString() {
        return "DeimplementInterface(fullyQualifiedInterfaceName=" + this.getFullyQualifiedInterfaceName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeimplementInterface)) {
            return false;
        }
        DeimplementInterface other = (DeimplementInterface)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
        String other$fullyQualifiedInterfaceName = other.getFullyQualifiedInterfaceName();
        return !(this$fullyQualifiedInterfaceName == null ? other$fullyQualifiedInterfaceName != null : !this$fullyQualifiedInterfaceName.equals(other$fullyQualifiedInterfaceName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeimplementInterface;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
        result = result * 59 + ($fullyQualifiedInterfaceName == null ? 43 : $fullyQualifiedInterfaceName.hashCode());
        return result;
    }
}

