/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindDeprecatedFields
extends Recipe {
    @Option(displayName="Type pattern", description="A type pattern that is used to find matching field uses.", example="org.springframework..*", required=false)
    @Nullable
    private final String typePattern;
    @Option(displayName="Match inherited", description="When enabled, find types that inherit from a deprecated type.", required=false)
    @Nullable
    private final Boolean matchInherited;
    @Option(displayName="Ignore deprecated scopes", description="When a deprecated method is used in a deprecated method or class, ignore it.", required=false)
    @Nullable
    private final Boolean ignoreDeprecatedScopes;

    public String getDisplayName() {
        return "Find uses of deprecated fields";
    }

    public String getDescription() {
        return "Find uses of deprecated fields in any API.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TypeMatcher typeMatcher = this.typePattern == null ? null : new TypeMatcher(this.typePattern, Boolean.TRUE.equals(this.matchInherited));
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    for (JavaType.Variable variable : cu.getTypesInUse().getVariables()) {
                        if (typeMatcher != null && !typeMatcher.matches(variable.getOwner())) continue;
                        for (JavaType.FullyQualified annotation : variable.getAnnotations()) {
                            if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                            return (J)SearchResult.found((Tree)cu);
                        }
                    }
                }
                return (J)tree;
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                J i = super.visitIdentifier(identifier, ctx);
                JavaType.Variable varType = identifier.getFieldType();
                if (varType != null && (typeMatcher == null || typeMatcher.matches(varType.getOwner()))) {
                    for (JavaType.FullyQualified annotation : varType.getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        if (Boolean.TRUE.equals(FindDeprecatedFields.this.ignoreDeprecatedScopes)) {
                            Iterator cursorPath = this.getCursor().getPath();
                            while (cursorPath.hasNext()) {
                                Object ancestor = cursorPath.next();
                                if (ancestor instanceof J.MethodDeclaration && this.isDeprecated(((J.MethodDeclaration)ancestor).getAllAnnotations())) {
                                    return i;
                                }
                                if (!(ancestor instanceof J.ClassDeclaration) || !this.isDeprecated(((J.ClassDeclaration)ancestor).getAllAnnotations())) continue;
                                return i;
                            }
                        }
                        i = (J.Identifier)SearchResult.found((Tree)i);
                    }
                }
                return i;
            }

            private boolean isDeprecated(List<J.Annotation> annotations) {
                for (J.Annotation annotation : annotations) {
                    if (!TypeUtils.isOfClassType(annotation.getType(), "java.lang.Deprecated")) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public FindDeprecatedFields(@Nullable String typePattern, @Nullable Boolean matchInherited, @Nullable Boolean ignoreDeprecatedScopes) {
        this.typePattern = typePattern;
        this.matchInherited = matchInherited;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
    }

    @Nullable
    public String getTypePattern() {
        return this.typePattern;
    }

    @Nullable
    public Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @Nullable
    public Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }

    @NonNull
    public String toString() {
        return "FindDeprecatedFields(typePattern=" + this.getTypePattern() + ", matchInherited=" + this.getMatchInherited() + ", ignoreDeprecatedScopes=" + this.getIgnoreDeprecatedScopes() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedFields)) {
            return false;
        }
        FindDeprecatedFields other = (FindDeprecatedFields)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$matchInherited = this.getMatchInherited();
        Boolean other$matchInherited = other.getMatchInherited();
        if (this$matchInherited == null ? other$matchInherited != null : !((Object)this$matchInherited).equals(other$matchInherited)) {
            return false;
        }
        Boolean this$ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        Boolean other$ignoreDeprecatedScopes = other.getIgnoreDeprecatedScopes();
        if (this$ignoreDeprecatedScopes == null ? other$ignoreDeprecatedScopes != null : !((Object)this$ignoreDeprecatedScopes).equals(other$ignoreDeprecatedScopes)) {
            return false;
        }
        String this$typePattern = this.getTypePattern();
        String other$typePattern = other.getTypePattern();
        return !(this$typePattern == null ? other$typePattern != null : !this$typePattern.equals(other$typePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDeprecatedFields;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $matchInherited = this.getMatchInherited();
        result = result * 59 + ($matchInherited == null ? 43 : ((Object)$matchInherited).hashCode());
        Boolean $ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        result = result * 59 + ($ignoreDeprecatedScopes == null ? 43 : ((Object)$ignoreDeprecatedScopes).hashCode());
        String $typePattern = this.getTypePattern();
        result = result * 59 + ($typePattern == null ? 43 : $typePattern.hashCode());
        return result;
    }
}

