/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.NotNullList;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValueBase<T> {
    private final boolean myTrackValue;
    private volatile java.lang.ref.SoftReference<Data<T>> myData;
    private static final Object[] PSI_MODIFICATION_DEPENDENCIES = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};

    protected CachedValueBase(boolean trackValue) {
        this.myTrackValue = trackValue;
    }

    @NotNull
    private Data<T> computeData(@NotNull Computable<CachedValueProvider.Result<T>> doCompute) {
        CachedValueProfiler.ValueTracker tracker;
        CachedValueProvider.Result<T> result2;
        if (doCompute == null) {
            CachedValueBase.$$$reportNull$$$0(0);
        }
        if (CachedValueProfiler.isProfiling()) {
            try (CachedValueProfiler.Frame frame = CachedValueProfiler.newFrame();){
                result2 = doCompute.compute();
                tracker = result2 == null ? null : frame.newValueTracker(result2);
            }
        } else {
            result2 = doCompute.compute();
            tracker = null;
        }
        if (result2 == null) {
            return new Data<Object>(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY, ArrayUtil.EMPTY_LONG_ARRAY, null);
        }
        T value = result2.getValue();
        Object[] inferredDependencies = this.normalizeDependencies(value, result2.getDependencyItems());
        long[] inferredTimeStamps = new long[inferredDependencies.length];
        for (int i = 0; i < inferredDependencies.length; ++i) {
            inferredTimeStamps[i] = this.getTimeStamp(inferredDependencies[i]);
        }
        return new Data<T>(value, inferredDependencies, inferredTimeStamps, tracker);
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.setData(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data) {
        this.myData = data == null ? null : new java.lang.ref.SoftReference<Data<Data<Data<Data<T>>>>>(data);
    }

    protected Object @NotNull [] normalizeDependencies(@Nullable T value, Object @NotNull [] dependencyItems) {
        if (dependencyItems == null) {
            CachedValueBase.$$$reportNull$$$0(1);
        }
        NotNullList<T> flattened = new NotNullList<T>(dependencyItems.length + 1);
        CachedValueBase.collectDependencies(dependencyItems, flattened);
        if (this.myTrackValue && value != null) {
            if (value instanceof Object[]) {
                CachedValueBase.collectDependencies((Object[])value, flattened);
            } else {
                flattened.add(value);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(flattened);
        if (objectArray == null) {
            CachedValueBase.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull() != null;
    }

    @Nullable
    public final Data<T> getUpToDateOrNull() {
        Data<T> data = this.getRawData();
        return data != null && this.checkUpToDate(data) ? data : null;
    }

    private boolean checkUpToDate(@NotNull Data<T> data) {
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(3);
        }
        if (this.isUpToDate(data)) {
            return true;
        }
        if (data.trackingInfo != null) {
            data.trackingInfo.onValueInvalidated();
        }
        return false;
    }

    @Nullable
    private Data<T> getRawData() {
        return SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data<T> data) {
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(4);
        }
        for (int i = 0; i < ((Data)data).myDependencies.length; ++i) {
            Object dependency = ((Data)data).myDependencies[i];
            if (!this.isDependencyOutOfDate(dependency, ((Data)data).myTimeStamps[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(5);
        }
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private static void collectDependencies(Object @NotNull [] dependencies, @NotNull List<? super Object> resultingDeps) {
        if (resultingDeps == null) {
            CachedValueBase.$$$reportNull$$$0(6);
        }
        if (dependencies == null) {
            CachedValueBase.$$$reportNull$$$0(7);
        }
        for (Object dependency : dependencies) {
            if (dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                CachedValueBase.collectDependencies((Object[])dependency, resultingDeps);
                continue;
            }
            resultingDeps.add(dependency);
        }
    }

    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(8);
        }
        if (dependency instanceof VirtualFile) {
            return ((VirtualFile)dependency).getModificationStamp();
        }
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        Logger.getInstance(CachedValueBase.class).error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(@NotNull CachedValueProvider.Result<T> result2) {
        if (result2 == null) {
            CachedValueBase.$$$reportNull$$$0(9);
        }
        Data<T> data = this.computeData(() -> result2);
        this.setData(data);
        return data.getValue();
    }

    public abstract boolean isFromMyProject(@NotNull Project var1);

    @NotNull
    public abstract Object getValueProvider();

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data data = this.getUpToDateOrNull();
        if (data != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(data, (Object)this.getValueProvider(), () -> this.computeData(() -> this.doCompute(param)));
            }
            return data.getValue();
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable<Data> calcData = () -> this.computeData(() -> this.doCompute(param));
        data = RecursionManager.doPreventingRecursion(this, true, calcData);
        if (data == null) {
            data = calcData.compute();
        } else if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            do {
                boolean bl = reuse = (alreadyComputed = this.getRawData()) != null && this.checkUpToDate(alreadyComputed);
                if (!reuse) continue;
                IdempotenceChecker.checkEquivalence(alreadyComputed, (Object)data, this.getValueProvider().getClass(), calcData);
            } while ((toReturn = this.cacheOrGetData(alreadyComputed, reuse ? null : data)) == null);
            if (data != toReturn && data.trackingInfo != null) {
                data.trackingInfo.onValueRejected();
            }
            return toReturn.getValue();
        }
        return data.getValue();
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getValueProvider() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doCompute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyItems";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CachedValueBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultingDeps";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CachedValueBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDependencies";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkUpToDate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOutOfDate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class Data<T>
    implements Getter<T> {
        private final T myValue;
        private final Object @NotNull [] myDependencies;
        private final long @NotNull [] myTimeStamps;
        @Nullable
        final CachedValueProfiler.ValueTracker trackingInfo;

        Data(T value, Object @NotNull [] dependencies, long @NotNull [] timeStamps, @Nullable CachedValueProfiler.ValueTracker trackingInfo) {
            if (dependencies == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (timeStamps == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.myValue = value;
            this.myDependencies = dependencies.length == 1 && dependencies[0] == PsiModificationTracker.MODIFICATION_COUNT ? PSI_MODIFICATION_DEPENDENCIES : dependencies;
            this.myTimeStamps = timeStamps;
            this.trackingInfo = trackingInfo;
        }

        public Object @NotNull [] getDependencies() {
            if (this.myDependencies == null) {
                Data.$$$reportNull$$$0(2);
            }
            return this.myDependencies;
        }

        public long @NotNull [] getTimeStamps() {
            if (this.myTimeStamps == null) {
                Data.$$$reportNull$$$0(3);
            }
            return this.myTimeStamps;
        }

        @Override
        public T get() {
            return this.getValue();
        }

        public T getValue() {
            if (this.trackingInfo != null) {
                this.trackingInfo.onValueUsed();
            }
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeStamps";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/CachedValueBase$Data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/CachedValueBase$Data";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeStamps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

