/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SimpleStringPersistentEnumerator
implements ScannableDataEnumeratorEx<String>,
CleanableStorage {
    private static final Logger LOG = Logger.getInstance(SimpleStringPersistentEnumerator.class);
    @NotNull
    private final Path file;
    private final Charset charset;
    @NotNull
    private volatile Object2IntMap<String> valueToId;
    private volatile String @NotNull [] idToValue;

    public SimpleStringPersistentEnumerator(@NotNull Path file) {
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(0);
        }
        this(file, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleStringPersistentEnumerator(@NotNull Path file, @NotNull Charset charset) {
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(2);
        }
        this.file = file;
        this.charset = charset;
        Pair<Object2IntMap<String>, String[]> pair = SimpleStringPersistentEnumerator.readStorageFromDisk(file, charset, Charset.defaultCharset());
        SimpleStringPersistentEnumerator simpleStringPersistentEnumerator = this;
        synchronized (simpleStringPersistentEnumerator) {
            this.valueToId = pair.getFirst();
            this.idToValue = pair.getSecond();
        }
    }

    @NotNull
    public Path getFile() {
        Path path = this.file;
        if (path == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(3);
        }
        return path;
    }

    @Override
    public int tryEnumerate(@Nullable String value) throws IOException {
        return this.valueToId.getInt((Object)value);
    }

    @Override
    public int enumerate(@Nullable String value) {
        Object2IntMap<String> valueToIdLocal = this.valueToId;
        int id = valueToIdLocal.getInt((Object)value);
        if (id != valueToIdLocal.defaultReturnValue()) {
            return id;
        }
        return this.insertNewValue(value);
    }

    private synchronized int insertNewValue(@Nullable String value) {
        if (value != null && StringUtil.containsLineBreak(value)) {
            throw new IllegalArgumentException("SimpleStringPersistentEnumerator doesn't support multi-line strings: [" + value + "]");
        }
        int id = this.valueToId.getInt((Object)value);
        if (id != this.valueToId.defaultReturnValue()) {
            return id;
        }
        int newId = this.idToValue.length + 1;
        String[] newIdToName = Arrays.copyOf(this.idToValue, this.idToValue.length + 1);
        newIdToName[newId - 1] = value;
        this.idToValue = newIdToName;
        Object2IntOpenHashMap newValueToId = new Object2IntOpenHashMap(this.valueToId);
        newValueToId.put((Object)value, newId);
        this.valueToId = newValueToId;
        this.forceDiskSync();
        return newId;
    }

    @NotNull
    public Collection<String> entries() {
        return new ArrayList<String>((Collection<String>)this.valueToId.keySet());
    }

    @NotNull
    public Map<String, Integer> getInvertedState() {
        return new HashMap<String, Integer>((Map<String, Integer>)this.valueToId);
    }

    @Override
    @Nullable
    public String valueOf(int id) {
        String[] idToNameLocal = this.idToValue;
        if (id <= 0 || id > idToNameLocal.length) {
            return null;
        }
        return idToNameLocal[id - 1];
    }

    @Override
    public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super String> reader) throws IOException {
        if (reader == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(4);
        }
        String[] idToNameLocal = this.idToValue;
        for (int i = 0; i < idToNameLocal.length; ++i) {
            int id = i + 1;
            String value = idToNameLocal[i];
            boolean continueProcessing = reader.read(id, value);
            if (continueProcessing) continue;
            return false;
        }
        return true;
    }

    @Override
    public int recordsCount() throws IOException {
        return this.getSize();
    }

    public synchronized void forceDiskSync() {
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.idToValue, this.file, this.charset);
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSize() {
        return this.valueToId.size();
    }

    @NotNull
    public String dumpToString() {
        String[] idToValueLocal = this.idToValue;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < idToValueLocal.length; ++i) {
            String value = idToValueLocal[i];
            sb.append(value).append(" -> ").append(i + 1).append('\n');
        }
        String string = sb.toString();
        if (string == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public synchronized void closeAndClean() throws IOException {
        this.valueToId = new Object2IntOpenHashMap();
        this.idToValue = ArrayUtil.EMPTY_STRING_ARRAY;
        FileUtil.delete((Path)this.file);
    }

    @NotNull
    private static Pair<Object2IntMap<String>, String[]> readStorageFromDisk(@NotNull Path file, @NotNull Charset charset, @NotNull Charset charsetToFallback) {
        Pair<Object2IntOpenHashMap, String[]> pair;
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(6);
        }
        if (charset == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(7);
        }
        if (charsetToFallback == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(8);
        }
        if (Files.notExists(file, new LinkOption[0])) {
            SimpleStringPersistentEnumerator.writeStorageToDisk(ArrayUtil.EMPTY_STRING_ARRAY, file, charset);
            Pair<Object2IntOpenHashMap, String[]> pair2 = Pair.create(new Object2IntOpenHashMap(), ArrayUtil.EMPTY_STRING_ARRAY);
            if (pair2 == null) {
                SimpleStringPersistentEnumerator.$$$reportNull$$$0(9);
            }
            return pair2;
        }
        try {
            List<String> lines;
            try {
                lines = Files.readAllLines(file, charset);
            }
            catch (IOException exMainCharset) {
                try {
                    lines = Files.readAllLines(file, charsetToFallback);
                }
                catch (IOException exFallbackCharset) {
                    exFallbackCharset.addSuppressed(exMainCharset);
                    throw exFallbackCharset;
                }
            }
            Object2IntOpenHashMap nameToIdRegistry = new Object2IntOpenHashMap(lines.size());
            String[] idToNameRegistry = lines.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : new String[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                String name = lines.get(i);
                int id = i + 1;
                nameToIdRegistry.put((Object)name, id);
                idToNameRegistry[i] = name;
            }
            pair = Pair.create(nameToIdRegistry, idToNameRegistry);
        }
        catch (IOException e) {
            LOG.warnWithDebug("Can't read [" + file.toAbsolutePath() + "] content", e);
            SimpleStringPersistentEnumerator.writeStorageToDisk(ArrayUtil.EMPTY_STRING_ARRAY, file, charset);
            Pair<Object2IntOpenHashMap, String[]> pair3 = Pair.create(new Object2IntOpenHashMap(), ArrayUtil.EMPTY_STRING_ARRAY);
            if (pair3 == null) {
                SimpleStringPersistentEnumerator.$$$reportNull$$$0(11);
            }
            return pair3;
        }
        if (pair == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(10);
        }
        return pair;
    }

    private static void writeStorageToDisk(String[] idToName, @NotNull Path file, @NotNull Charset charset) {
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(12);
        }
        if (charset == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(13);
        }
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, Arrays.asList(idToName), charset, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't store enumerator to " + file, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsetToFallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpToString";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readStorageFromDisk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readStorageFromDisk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeStorageToDisk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

