/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.CompositeMessageBusKt;
import com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import com.intellij.util.messages.impl.MessageBusEx;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.ToDirectChildrenMessagePublisher;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001J\b\u0010\u0014\u001a\u00020\u0012H\u0017J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u001d\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0010\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0010\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0000\u0010#2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H#0\u001e2\u0006\u0010$\u001a\u00020%H\u0010\u00a2\u0006\u0002\b&J\u001a\u0010'\u001a\u00020\u00122\u0010\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0)H\u0016J\r\u0010+\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b,J1\u0010-\u001a\u00020\u00122\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u000e\u0010.\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\t2\u0006\u0010/\u001a\u000200H\u0010\u00a2\u0006\u0002\b1J\r\u00102\u001a\u000200H\u0010\u00a2\u0006\u0002\b3J\u001d\u00104\u001a\u0002002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0010\u00a2\u0006\u0004\b5\u00106J\u0019\u00107\u001a\u00020\u00122\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0010\u00a2\u0006\u0002\b8J\u000e\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0001J\b\u0010;\u001a\u00020\u0012H\u0016J\"\u0010<\u001a\u00020\u00122\u0018\u0010=\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0>H\u0016J\u001c\u0010/\u001a\u00020\u0012\"\u0004\b\u0000\u0010#2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H#0\u001eH\u0002J\u001e\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016R:\u0010\b\u001a.\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00010\u0001 \n*\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00010\u00010\f\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/util/messages/impl/CompositeMessageBus;", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/impl/MessageBusEx;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "childBuses", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "topicClassToListenerDescriptor", "", "", "Lcom/intellij/util/messages/ListenerDescriptor;", "addChild", "", "bus", "clearAllSubscriberCache", "clearPublisherCache", "clearSubscriberCache", "topicAndHandlerPairs", "", "", "clearSubscriberCache$intellij_platform_core", "([Ljava/lang/Object;)V", "computeSubscribers", "topic", "Lcom/intellij/util/messages/Topic;", "computeSubscribers$intellij_platform_core", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "L", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "disposeChildren", "disposeChildren$intellij_platform_core", "doComputeSubscribers", "result", "subscribeLazyListeners", "", "doComputeSubscribers$intellij_platform_core", "hasChildren", "hasChildren$intellij_platform_core", "notifyConnectionTerminated", "notifyConnectionTerminated$intellij_platform_core", "([Ljava/lang/Object;)Z", "notifyOnSubscriptionToTopicToChildren", "notifyOnSubscriptionToTopicToChildren$intellij_platform_core", "onChildBusDisposed", "childBus", "removeEmptyConnectionsRecursively", "setLazyListeners", "map", "Ljava/util/concurrent/ConcurrentMap;", "unsubscribeLazyListeners", "module", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "listenerDescriptors", "intellij.platform.core"})
@VisibleForTesting
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCompositeMessageBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeMessageBus.kt\ncom/intellij/util/messages/impl/CompositeMessageBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,365:1\n1855#2,2:366\n1855#2,2:368\n*S KotlinDebug\n*F\n+ 1 CompositeMessageBus.kt\ncom/intellij/util/messages/impl/CompositeMessageBus\n*L\n186#1:366,2\n268#1:368,2\n*E\n"})
public class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    @NotNull
    private final List<MessageBusImpl> childBuses;
    @NotNull
    private volatile Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor;

    public CompositeMessageBus(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)parentBus, (String)"parentBus");
        super(owner, parentBus);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"createLockFreeCopyOnWriteList(...)");
        this.childBuses = list;
        this.topicClassToListenerDescriptor = CompositeMessageBusKt.access$getEMPTY_MAP$p();
    }

    public CompositeMessageBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"createLockFreeCopyOnWriteList(...)");
        this.childBuses = list;
        this.topicClassToListenerDescriptor = CompositeMessageBusKt.access$getEMPTY_MAP$p();
    }

    @Override
    public void setLazyListeners(@NotNull ConcurrentMap<String, List<ListenerDescriptor>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            this.topicClassToListenerDescriptor = map;
        } else {
            topicClassToListenerDescriptor.putAll((Map<String, List<ListenerDescriptor>>)map);
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public boolean hasChildren$intellij_platform_core() {
        return !((Collection)this.childBuses).isEmpty();
    }

    public final void addChild(@NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        CompositeMessageBusKt.access$childrenListChanged(this);
        this.childBuses.add(bus);
    }

    public final void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        Intrinsics.checkNotNullParameter((Object)childBus, (String)"childBus");
        boolean removed = this.childBuses.remove(childBus);
        CompositeMessageBusKt.access$childrenListChanged(this);
        MessageBusImpl.LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                if (!(this.parentBus == null)) {
                    boolean bl = false;
                    String string = "Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic " + topic.getListenerClass() + " broadcast direction to NONE or TO_PARENT";
                    throw new IllegalArgumentException(string.toString());
                }
                messagePublisher = (MessagePublisher)new ToDirectChildrenMessagePublisher(topic, this, this.childBuses);
                break;
            }
            default: {
                messagePublisher = new MessagePublisher(topic, this);
            }
        }
        return messagePublisher;
    }

    @Override
    @NotNull
    public Object[] computeSubscribers$intellij_platform_core(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        if (this.owner.isDisposed()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        } else {
            objectArray = super.computeSubscribers$intellij_platform_core(topic);
        }
        return objectArray;
    }

    @Override
    public void doComputeSubscribers$intellij_platform_core(@NotNull Topic<?> topic, @NotNull List<? super Object> result2, boolean subscribeLazyListeners2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (subscribeLazyListeners2) {
            this.subscribeLazyListeners(topic);
        }
        super.doComputeSubscribers$intellij_platform_core(topic, result2, subscribeLazyListeners2);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.childBuses) {
                if (childBus.isDisposed()) continue;
                childBus.doComputeSubscribers$intellij_platform_core(topic, result2, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    private final <L> void subscribeLazyListeners(Topic<L> topic) {
        if (topic.getListenerClass() == Runnable.class) {
            return;
        }
        Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            return;
        }
        Cancellation.computeInNonCancelableSection(() -> CompositeMessageBus.subscribeLazyListeners$lambda$3(topicClassToListenerDescriptor, topic, this));
    }

    @Override
    public void notifyOnSubscriptionToTopicToChildren$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren$intellij_platform_core(topic);
        }
    }

    @Override
    public boolean notifyConnectionTerminated$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        boolean isChildClearingNeeded = super.notifyConnectionTerminated$intellij_platform_core(topicAndHandlerPairs);
        if (!isChildClearingNeeded) {
            return false;
        }
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
        this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> CompositeMessageBus.notifyConnectionTerminated$lambda$4((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        return false;
    }

    @Override
    public void clearSubscriberCache$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        super.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
    }

    @Override
    public void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        for (MessageBusImpl bus : this.childBuses) {
            bus.removeEmptyConnectionsRecursively();
        }
    }

    @Override
    public void clearPublisherCache() {
        this.publisherCache.clear();
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageBusImpl childBus = (MessageBusImpl)element$iv;
            boolean bl = false;
            if (childBus instanceof CompositeMessageBus) {
                ((CompositeMessageBus)childBus).clearPublisherCache();
                continue;
            }
            childBus.publisherCache.clear();
        }
    }

    @Override
    public void unsubscribeLazyListeners(@NotNull IdeaPluginDescriptor module, @NotNull List<ListenerDescriptor> listenerDescriptors) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(listenerDescriptors, (String)"listenerDescriptors");
        this.topicClassToListenerDescriptor.values().removeIf(arg_0 -> CompositeMessageBus.unsubscribeLazyListeners$lambda$7(module, arg_0));
        if (listenerDescriptors.isEmpty() || this.subscribers.isEmpty()) {
            return;
        }
        HashMap<Object, Set> topicToDescriptors = new HashMap<Object, Set>();
        for (ListenerDescriptor descriptor : listenerDescriptors) {
            String string = descriptor.listenerClassName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"listenerClassName");
            topicToDescriptors.computeIfAbsent(descriptor.topicClassName, arg_0 -> CompositeMessageBus.unsubscribeLazyListeners$lambda$8((Function1)unsubscribeLazyListeners.2.INSTANCE, arg_0)).add(string);
        }
        boolean isChanged = false;
        List newSubscribers = null;
        Iterator iterator2 = this.subscribers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator connectionIterator = iterator2;
        while (connectionIterator.hasNext()) {
            List newHandlers;
            Set listenerClassNames;
            DescriptorBasedMessageBusConnection connection;
            Object e = connectionIterator.next();
            if ((e instanceof DescriptorBasedMessageBusConnection ? (DescriptorBasedMessageBusConnection)e : null) == null) continue;
            connection = connection;
            if (module != connection.module || (Set)topicToDescriptors.get(connection.topic.getListenerClass().getName()) == null || CompositeMessageBusKt.access$computeNewHandlers(connection.handlers, listenerClassNames) == null) continue;
            isChanged = true;
            connectionIterator.remove();
            if (!(!((Collection)newHandlers).isEmpty())) continue;
            if (newSubscribers == null) {
                newSubscribers = new ArrayList();
            }
            newSubscribers.add(new DescriptorBasedMessageBusConnection((PluginDescriptor)module, connection.topic, newHandlers));
        }
        if (newSubscribers != null) {
            this.subscribers.addAll(newSubscribers);
        }
        if (isChanged) {
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        super.disconnectPluginConnections(predicate);
        for (MessageBusImpl bus : this.childBuses) {
            bus.disconnectPluginConnections(predicate);
        }
    }

    @Override
    @TestOnly
    public void clearAllSubscriberCache() {
        MessageBusImpl.LOG.assertTrue(this.rootBus != this);
        this.rootBus.subscriberCache.clear();
        this.subscriberCache.clear();
        for (MessageBusImpl bus : this.childBuses) {
            bus.subscriberCache.clear();
        }
    }

    @Override
    public void disposeChildren$intellij_platform_core() {
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose(p0);
        }
    }

    private static final List subscribeLazyListeners$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void subscribeLazyListeners$lambda$3$lambda$2(CompositeMessageBus this$0, Topic $topic, PluginDescriptor key, List listeners) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
        this$0.subscribers.add(new DescriptorBasedMessageBusConnection(key, $topic, listeners));
    }

    private static final Unit subscribeLazyListeners$lambda$3(Map $topicClassToListenerDescriptor, Topic $topic, CompositeMessageBus this$0) {
        Intrinsics.checkNotNullParameter((Object)$topicClassToListenerDescriptor, (String)"$topicClassToListenerDescriptor");
        Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List list = (List)$topicClassToListenerDescriptor.remove($topic.getListenerClass().getName());
        if (list == null) {
            return Unit.INSTANCE;
        }
        List listenerDescriptors = list;
        LinkedHashMap<Object, List> listenerMap = new LinkedHashMap<Object, List>();
        for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
            try {
                Object object = this$0.owner.createListener(listenerDescriptor);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createListener(...)");
                listenerMap.computeIfAbsent(listenerDescriptor.pluginDescriptor, arg_0 -> CompositeMessageBus.subscribeLazyListeners$lambda$3$lambda$1((Function1)subscribeLazyListeners.1.1.INSTANCE, arg_0)).add(object);
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                MessageBusImpl.LOG.error("Cannot create listener", e);
            }
        }
        listenerMap.forEach((arg_0, arg_1) -> CompositeMessageBus.subscribeLazyListeners$lambda$3$lambda$2(this$0, $topic, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final boolean notifyConnectionTerminated$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean unsubscribeLazyListeners$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean unsubscribeLazyListeners$lambda$7(IdeaPluginDescriptor $module, List descriptors) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        if (descriptors.removeIf(arg_0 -> CompositeMessageBus.unsubscribeLazyListeners$lambda$7$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0))) {
            return descriptors.isEmpty();
        }
        return false;
    }

    private static final Set unsubscribeLazyListeners$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Topic.BroadcastDirection.values().length];
            try {
                nArray[Topic.BroadcastDirection.TO_PARENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Topic.BroadcastDirection.TO_DIRECT_CHILDREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

