/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotation;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotationFile;
import com.jetbrains.python.codeInsight.typing.PyTypeProviderWithCustomContext;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterListOwner;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithAncestors;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyClassElementType;
import com.jetbrains.python.psi.impl.stubs.PyTypingAliasStubType;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParameterMapping;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyTypeVarTupleTypeImpl;
import com.jetbrains.python.psi.types.PyTypeVarTypeImpl;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyVariadicType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypingTypeProvider
extends PyTypeProviderWithCustomContext<Context> {
    public static final String TYPING = "typing";
    public static final String GENERATOR = "typing.Generator";
    public static final String ASYNC_GENERATOR = "typing.AsyncGenerator";
    public static final String COROUTINE = "typing.Coroutine";
    public static final String NAMEDTUPLE = "typing.NamedTuple";
    public static final String TYPED_DICT = "typing.TypedDict";
    public static final String TYPED_DICT_EXT = "typing_extensions.TypedDict";
    public static final String TYPE_GUARD = "typing.TypeGuard";
    public static final String TYPE_GUARD_EXT = "typing_extensions.TypeGuard";
    public static final String GENERIC = "typing.Generic";
    public static final String PROTOCOL = "typing.Protocol";
    public static final String PROTOCOL_EXT = "typing_extensions.Protocol";
    public static final String TYPE = "typing.Type";
    public static final String ANY = "typing.Any";
    public static final String NEW_TYPE = "typing.NewType";
    public static final String CALLABLE = "typing.Callable";
    public static final String MAPPING = "typing.Mapping";
    public static final String MAPPING_GET = "typing.Mapping.get";
    private static final String LIST = "typing.List";
    private static final String DICT = "typing.Dict";
    private static final String DEFAULT_DICT = "typing.DefaultDict";
    private static final String ORDERED_DICT = "typing.OrderedDict";
    private static final String SET = "typing.Set";
    private static final String FROZEN_SET = "typing.FrozenSet";
    private static final String COUNTER = "typing.Counter";
    private static final String DEQUE = "typing.Deque";
    private static final String TUPLE = "typing.Tuple";
    public static final String CLASS_VAR = "typing.ClassVar";
    public static final String TYPE_VAR = "typing.TypeVar";
    public static final String TYPE_VAR_TUPLE = "typing.TypeVarTuple";
    public static final String TYPING_PARAM_SPEC = "typing.ParamSpec";
    public static final String TYPING_EXTENSIONS_PARAM_SPEC = "typing_extensions.ParamSpec";
    private static final String CHAIN_MAP = "typing.ChainMap";
    public static final String UNION = "typing.Union";
    public static final String TYPING_CONCATENATE = "typing.Concatenate";
    public static final String TYPING_EXTENSIONS_CONCATENATE = "typing_extensions.Concatenate";
    public static final String OPTIONAL = "typing.Optional";
    public static final String NO_RETURN = "typing.NoReturn";
    public static final String NEVER = "typing.Never";
    public static final String NO_RETURN_EXT = "typing_extensions.NoReturn";
    public static final String NEVER_EXT = "typing_extensions.Never";
    public static final String FINAL = "typing.Final";
    public static final String FINAL_EXT = "typing_extensions.Final";
    public static final String LITERAL = "typing.Literal";
    public static final String LITERAL_EXT = "typing_extensions.Literal";
    public static final String LITERALSTRING = "typing.LiteralString";
    public static final String LITERALSTRING_EXT = "typing_extensions.LiteralString";
    public static final String ANNOTATED = "typing.Annotated";
    public static final String ANNOTATED_EXT = "typing_extensions.Annotated";
    public static final String TYPE_ALIAS = "typing.TypeAlias";
    public static final String TYPE_ALIAS_EXT = "typing_extensions.TypeAlias";
    public static final String TYPE_ALIAS_TYPE = "typing.TypeAliasType";
    private static final String SPECIAL_FORM = "typing._SpecialForm";
    private static final String SPECIAL_FORM_EXT = "typing_extensions._SpecialForm";
    public static final String REQUIRED = "typing.Required";
    public static final String REQUIRED_EXT = "typing_extensions.Required";
    public static final String NOT_REQUIRED = "typing.NotRequired";
    public static final String NOT_REQUIRED_EXT = "typing_extensions.NotRequired";
    public static final String SELF = "typing.Self";
    public static final String SELF_EXT = "typing_extensions.Self";
    private static final String PY2_FILE_TYPE = "typing.BinaryIO";
    private static final String PY3_BINARY_FILE_TYPE = "typing.BinaryIO";
    private static final String PY3_TEXT_FILE_TYPE = "typing.TextIO";
    private static final Pattern TYPE_COMMENT_PATTERN = Pattern.compile("# *type: *([^#]+) *(#.*)?");
    public static final Pattern TYPE_IGNORE_PATTERN = Pattern.compile("# *type: *ignore(\\[ *[^ ,\\]]+ *(, *[^ ,\\]]+ *)*\\])? *($|(#.*))", 2);
    public static final ImmutableMap<String, String> BUILTIN_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"typing.List", (Object)"list").put((Object)"typing.Dict", (Object)"dict").put((Object)"typing.Set", (Object)"set").put((Object)"typing.FrozenSet", (Object)"frozenset").put((Object)"typing.Tuple", (Object)"tuple").build();
    private static final ImmutableMap<String, String> COLLECTIONS_CLASSES = ImmutableMap.builder().put((Object)"typing.DefaultDict", (Object)"collections.defaultdict").put((Object)"typing.OrderedDict", (Object)"collections.OrderedDict").put((Object)"typing.Counter", (Object)"collections.Counter").put((Object)"typing.Deque", (Object)"collections.deque").put((Object)"typing.ChainMap", (Object)"collections.ChainMap").build();
    public static final ImmutableMap<String, String> TYPING_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"list", (Object)"List").put((Object)"dict", (Object)"Dict").put((Object)"set", (Object)"Set").put((Object)"frozenset", (Object)"FrozenSet").build();
    public static final ImmutableMap<String, String> TYPING_BUILTINS_GENERIC_ALIASES = ImmutableMap.builder().putAll((Iterable)TYPING_COLLECTION_CLASSES.entrySet()).put((Object)"type", (Object)"Type").put((Object)"tuple", (Object)"Tuple").build();
    public static final ImmutableSet<String> GENERIC_CLASSES = ImmutableSet.builder().add((Object[])new String[]{"typing.Tuple", "typing.Generic", "typing.Protocol", "typing.Callable", "typing.Type", "typing.ClassVar", "typing.Final", "typing.Literal", "typing.Annotated", "typing.Required", "typing.NotRequired"}).add((Object[])new String[]{"typing.Union", "typing.Optional", "typing.List", "typing.Dict", "typing.DefaultDict", "typing.OrderedDict", "typing.Set", "typing.FrozenSet", "typing.Counter", "typing.Deque", "typing.ChainMap"}).add((Object[])new String[]{"typing_extensions.Protocol", "typing_extensions.Final", "typing_extensions.Literal", "typing_extensions.Annotated", "typing_extensions.Required", "typing_extensions.NotRequired"}).build();
    public static final ImmutableSet<String> OPAQUE_NAMES = ImmutableSet.builder().add((Object)PyKnownDecoratorUtil.KnownDecorator.TYPING_OVERLOAD.name()).add((Object)"typing.Any").add((Object)"typing.TypeVar").add((Object)"typing.TypeVarTuple").add((Object)"typing.Generic").add((Object)"typing.ParamSpec").add((Object)"typing_extensions.ParamSpec").add((Object)"typing.Concatenate").add((Object)"typing_extensions.Concatenate").add((Object)"typing.Tuple").add((Object)"typing.Callable").add((Object)"typing.Type").add((Object)"typing.no_type_check").add((Object)"typing.Union").add((Object)"typing.Optional").add((Object)"typing.List").add((Object)"typing.Dict").add((Object)"typing.DefaultDict").add((Object)"typing.OrderedDict").add((Object)"typing.Set").add((Object)"typing.FrozenSet").add((Object[])new String[]{"typing.Protocol", "typing_extensions.Protocol"}).add((Object)"typing.ClassVar").add((Object)"typing.Counter").add((Object)"typing.Deque").add((Object)"typing.ChainMap").add((Object)"typing.NoReturn").add((Object[])new String[]{"typing.Final", "typing_extensions.Final"}).add((Object[])new String[]{"typing.Literal", "typing_extensions.Literal"}).add((Object[])new String[]{"typing.TypedDict", "typing_extensions.TypedDict"}).add((Object[])new String[]{"typing.Annotated", "typing_extensions.Annotated"}).add((Object[])new String[]{"typing.TypeAlias", "typing_extensions.TypeAlias"}).add((Object[])new String[]{"typing.Required", "typing_extensions.Required"}).add((Object[])new String[]{"typing.NotRequired", "typing_extensions.NotRequired"}).add((Object[])new String[]{"typing.Self", "typing_extensions.Self"}).build();
    private static final Key<PsiElement> FRAGMENT_OWNER = Key.create("PY_FRAGMENT_OWNER");
    private static final Key<Context> TYPE_HINT_EVAL_CONTEXT = Key.create("TYPE_HINT_EVAL_CONTEXT");

    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull Context context) {
        if (referenceExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(1);
        }
        if ("Generic".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context.myContext).contains(GENERIC)) {
            return PyTypingTypeProvider.createTypingGenericType(referenceExpression);
        }
        if ("Protocol".equals(referenceExpression.getName()) && ContainerUtil.exists(PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context.myContext), n -> PROTOCOL.equals(n) || PROTOCOL_EXT.equals(n))) {
            return PyTypingTypeProvider.createTypingProtocolType(referenceExpression);
        }
        if ("Callable".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context.myContext).contains(CALLABLE)) {
            return PyTypingTypeProvider.createTypingCallableType(referenceExpression);
        }
        return null;
    }

    @Nullable
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull Context context) {
        PyReferenceExpression ref;
        PyFunctionTypeAnnotation annotation;
        String paramTypeCommentHint;
        PyExpression typeHint;
        if (param == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(2);
        }
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(4);
        }
        if ((typeHint = PyTypingTypeProvider.getAnnotationValue(param, context.myContext)) == null && (paramTypeCommentHint = param.getTypeCommentAnnotation()) != null) {
            typeHint = PyTypingTypeProvider.toExpression(paramTypeCommentHint, param);
        }
        if (typeHint == null && (annotation = PyTypingTypeProvider.getFunctionTypeAnnotation(func)) != null) {
            PyExpression funcTypeCommentParamHint = PyTypingTypeProvider.findParamTypeHintInFunctionTypeComment(annotation, param, func);
            if (funcTypeCommentParamHint == null) {
                return Ref.create();
            }
            typeHint = funcTypeCommentParamHint;
        }
        if (typeHint == null) {
            return null;
        }
        if (typeHint instanceof PyReferenceExpression && (ref = (PyReferenceExpression)typeHint).isQualified() && (param.isPositionalContainer() && "args".equals(ref.getReferencedName()) || param.isKeywordContainer() && "kwargs".equals(ref.getReferencedName()))) {
            typeHint = Objects.requireNonNull(ref.getQualifier());
        }
        PyType type = Ref.deref(PyTypingTypeProvider.getType(typeHint, context));
        if (param.isPositionalContainer() && !(type instanceof PyParamSpecType)) {
            return Ref.create(PyTypeUtil.toPositionalContainerType(param, type));
        }
        if (param.isKeywordContainer() && !(type instanceof PyParamSpecType)) {
            return Ref.create(PyTypeUtil.toKeywordContainerType(param, type));
        }
        if ("None".equals(param.getDefaultValueText())) {
            return Ref.create(PyUnionType.union(type, PyNoneType.INSTANCE));
        }
        return Ref.create(type);
    }

    @Nullable
    private static PyExpression findParamTypeHintInFunctionTypeComment(@NotNull PyFunctionTypeAnnotation annotation, @NotNull PyNamedParameter param, @NotNull PyFunction func) {
        PyNoneLiteralExpression noneExpr;
        Object e;
        List paramTypes;
        if (annotation == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(5);
        }
        if (param == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(6);
        }
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(7);
        }
        if ((paramTypes = annotation.getParameterTypeList().getParameterTypes()).size() == 1 && (e = paramTypes.get(0)) instanceof PyNoneLiteralExpression && (noneExpr = (PyNoneLiteralExpression)e).isEllipsis()) {
            return null;
        }
        int startOffset = PyTypingTypeProvider.omitFirstParamInTypeComment(func, annotation) ? 1 : 0;
        List<PyParameter> funcParams = Arrays.asList(func.getParameterList().getParameters());
        int i = funcParams.indexOf(param) - startOffset;
        if (i >= 0 && i < paramTypes.size()) {
            PyExpression paramTypeHint = (PyExpression)paramTypes.get(i);
            if (paramTypeHint instanceof PyStarExpression) {
                PyStarExpression starExpression = (PyStarExpression)paramTypeHint;
                return starExpression.getExpression();
            }
            if (paramTypeHint instanceof PyDoubleStarExpression) {
                PyDoubleStarExpression doubleStarExpression = (PyDoubleStarExpression)paramTypeHint;
                return doubleStarExpression.getExpression();
            }
            return paramTypeHint;
        }
        return null;
    }

    public static boolean isGenerator(@NotNull PyType type) {
        if (type == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(8);
        }
        return type instanceof PyCollectionType && GENERATOR.equals(((PyClassLikeType)type).getClassQName());
    }

    @NotNull
    private static PyType createTypingGenericType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(9);
        }
        return new PyCustomType(GENERIC, null, false, true, new PyClassLikeType[]{PyBuiltinCache.getInstance(anchor).getObjectType()});
    }

    @NotNull
    private static PyType createTypingProtocolType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(10);
        }
        return new PyCustomType(PROTOCOL, null, false, true, new PyClassLikeType[]{PyBuiltinCache.getInstance(anchor).getObjectType()});
    }

    @NotNull
    public static PyType createTypingCallableType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(11);
        }
        return new PyCustomType(CALLABLE, null, false, true, new PyClassLikeType[]{PyBuiltinCache.getInstance(anchor).getObjectType()});
    }

    private static boolean omitFirstParamInTypeComment(@NotNull PyFunction func, @NotNull PyFunctionTypeAnnotation annotation) {
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(12);
        }
        if (annotation == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(13);
        }
        return func.getContainingClass() != null && func.getModifier() != PyFunction.Modifier.STATICMETHOD && annotation.getParameterTypeList().getParameterTypes().size() < func.getParameterList().getParameters().length;
    }

    @Nullable
    public Ref<PyType> getReturnType(@NotNull PyCallable callable, @NotNull Context context) {
        if (callable == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(15);
        }
        if (callable instanceof PyFunction) {
            PyFunction function = (PyFunction)callable;
            if (PyTypingTypeProvider.isTypeGuard(function, context.myContext)) {
                return Ref.create(PyBuiltinCache.getInstance(callable).getBoolType());
            }
            PyExpression returnTypeAnnotation = PyTypingTypeProvider.getReturnTypeAnnotation(function, context.myContext);
            if (returnTypeAnnotation != null) {
                Ref<PyType> typeRef = PyTypingTypeProvider.getType(returnTypeAnnotation, context);
                if (typeRef != null) {
                    return Ref.create(PyTypingTypeProvider.toAsyncIfNeeded(function, typeRef.get()));
                }
                return Ref.create();
            }
        }
        return null;
    }

    @Nullable
    public static PyExpression getReturnTypeAnnotation(@NotNull PyFunction function, TypeEvalContext context) {
        PyExpression returnAnnotation;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(16);
        }
        if ((returnAnnotation = PyTypingTypeProvider.getAnnotationValue(function, context)) != null) {
            return returnAnnotation;
        }
        PyFunctionTypeAnnotation functionAnnotation = PyTypingTypeProvider.getFunctionTypeAnnotation(function);
        if (functionAnnotation != null) {
            return functionAnnotation.getReturnType();
        }
        return null;
    }

    @Nullable
    public static PyFunctionTypeAnnotation getFunctionTypeAnnotation(@NotNull PyFunction function) {
        String comment;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(17);
        }
        if ((comment = function.getTypeCommentAnnotation()) == null) {
            return null;
        }
        PyFunctionTypeAnnotationFile file = (PyFunctionTypeAnnotationFile)CachedValuesManager.getCachedValue(function, () -> CachedValueProvider.Result.create(new PyFunctionTypeAnnotationFile(function.getTypeCommentAnnotation(), (PsiElement)function), function));
        return file.getAnnotation();
    }

    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull Context context) {
        PyTypedDictType inferredTypedDict;
        PyClass initializedClass;
        String functionQName;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(18);
        }
        if (callSite == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(20);
        }
        if ("typing.cast".equals(functionQName = function.getQualifiedName())) {
            return Optional.ofNullable(PyUtil.as(callSite, PyCallExpression.class)).map(PyCallExpression::getArguments).filter(args -> ((PyExpression[])args).length > 0).map(args -> PyTypingTypeProvider.getType(args[0], context)).orElse(null);
        }
        if (callSite instanceof PyCallExpression) {
            LanguageLevel level;
            LanguageLevel languageLevel = "open".equals(functionQName) ? LanguageLevel.forElement(callSite) : (level = "pathlib.Path.open".equals(functionQName) || "_io.open".equals(functionQName) ? LanguageLevel.PYTHON34 : null);
            if (level != null) {
                return PyTypingTypeProvider.getOpenFunctionCallType(function, (PyCallExpression)callSite, level, context.myContext);
            }
        }
        if ((initializedClass = PyUtil.turnConstructorIntoClass(function)) != null && (TYPE_VAR.equals(initializedClass.getQualifiedName()) || TYPE_VAR_TUPLE.equals(initializedClass.getQualifiedName()))) {
            return Ref.create(PyTypingTypeProvider.getTypeParameterTypeFromDeclaration(callSite, context));
        }
        if (initializedClass != null && callSite instanceof PyCallExpression && "dict".equals(initializedClass.getQualifiedName()) && (inferredTypedDict = PyTypedDictTypeProvider.Companion.inferTypedDictFromCallExpression((PyCallExpression)callSite, context.myContext)) != null) {
            return Ref.create(inferredTypedDict);
        }
        if (PyTypingTypeProvider.functionReturningCallSiteAsAType(function)) {
            return PyTypingTypeProvider.getAsClassObjectType(callSite, context);
        }
        return null;
    }

    private static boolean functionReturningCallSiteAsAType(@NotNull PyFunction function) {
        PyClass cls;
        String name;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(21);
        }
        if ("__class_getitem__".equals(name = function.getName())) {
            return true;
        }
        if ("__getitem__".equals(name) && (cls = function.getContainingClass()) != null) {
            String qualifiedName = cls.getQualifiedName();
            return SPECIAL_FORM.equals(qualifiedName) || SPECIAL_FORM_EXT.equals(qualifiedName);
        }
        return false;
    }

    @Nullable
    private static PyType getTypedDictTypeForTarget(@NotNull PyTargetExpression referenceTarget, @NotNull TypeEvalContext context) {
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(23);
        }
        if (PyTypedDictTypeProvider.Companion.isTypedDict((PyExpression)referenceTarget, context)) {
            return new PyCustomType(TYPED_DICT, null, false, true, new PyClassLikeType[]{PyBuiltinCache.getInstance(referenceTarget).getDictType()});
        }
        return null;
    }

    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull Context context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(25);
        }
        if (referenceTarget instanceof PyTargetExpression) {
            PyTypeParameterType type;
            PyTargetExpression target = (PyTargetExpression)referenceTarget;
            String targetQName = target.getQualifiedName();
            if (GENERIC.equals(targetQName)) {
                return Ref.create(PyTypingTypeProvider.createTypingGenericType(target));
            }
            if (PROTOCOL.equals(targetQName) || PROTOCOL_EXT.equals(targetQName)) {
                return Ref.create(PyTypingTypeProvider.createTypingProtocolType(target));
            }
            if (CALLABLE.equals(targetQName)) {
                return Ref.create(PyTypingTypeProvider.createTypingCallableType(referenceTarget));
            }
            PyType collection = PyTypingTypeProvider.getCollection(target, context.myContext);
            if (collection instanceof PyInstantiableType) {
                return Ref.create(((PyInstantiableType)collection).toClass());
            }
            PyType typedDictType = PyTypingTypeProvider.getTypedDictTypeForTarget(target, context.myContext);
            if (typedDictType != null) {
                return Ref.create(typedDictType);
            }
            Ref<PyType> annotatedType = PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(target, context);
            if (annotatedType != null) {
                return annotatedType;
            }
            PyExpression assignedValue = PyTypingAliasStubType.getAssignedValueStubLike(target);
            if (assignedValue != null && (type = PyTypingTypeProvider.getTypeParameterTypeFromDeclaration(assignedValue, context)) != null) {
                return Ref.create(type);
            }
            String name = target.getReferencedName();
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(target);
            if (name == null || scopeOwner == null) {
                return null;
            }
            PyClass pyClass = target.getContainingClass();
            if (target.isQualified()) {
                if (pyClass != null && scopeOwner instanceof PyFunction) {
                    PyResolveContext resolveContext = PyResolveContext.defaultContext(context.myContext);
                    boolean isInstanceAttribute = context.myContext.maySwitchToAST(target) ? ((StreamEx)StreamEx.of(PyUtil.multiResolveTopPriority(target.getQualifier(), resolveContext)).select(PyParameter.class).filter(PyParameter::isSelf)).anyMatch(p -> PsiTreeUtil.getParentOfType((PsiElement)p, PyFunction.class) == scopeOwner) : PyUtil.isInstanceAttribute(target);
                    if (!isInstanceAttribute) {
                        return null;
                    }
                    PyClassTypeImpl classType = new PyClassTypeImpl(pyClass, true);
                    List<? extends RatedResolveResult> classAttrs = classType.resolveMember(name, target, AccessDirection.READ, resolveContext, true);
                    if (classAttrs == null) {
                        return null;
                    }
                    return (Ref)((StreamEx)StreamEx.of(classAttrs).map(RatedResolveResult::getElement).select(PyTargetExpression.class).filter(x -> ScopeUtil.getScopeOwner(x) instanceof PyClass)).map(x -> PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context)).collect(PyTypeUtil.toUnionFromRef());
                }
            } else {
                StreamEx candidates = null;
                if (context.myContext.maySwitchToAST(target)) {
                    Scope scope = ControlFlowCache.getScope(scopeOwner);
                    candidates = StreamEx.of(scope.getNamedElements(name, false)).select(PyTargetExpression.class);
                } else if (scopeOwner instanceof PyFile) {
                    candidates = (StreamEx)StreamEx.of(((PyFile)scopeOwner).getTopLevelAttributes()).filter(t -> name.equals(t.getName()));
                } else if (scopeOwner instanceof PyClass) {
                    candidates = (StreamEx)StreamEx.of(((PyClass)scopeOwner).getClassAttributes()).filter(t -> name.equals(t.getName()));
                }
                if (candidates != null) {
                    return candidates.map(x -> PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context)).nonNull().findFirst().orElse(null);
                }
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromTargetExpressionAnnotation(@NotNull PyTargetExpression target, @NotNull Context context) {
        PyExpression annotation;
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(27);
        }
        if ((annotation = PyTypingTypeProvider.getAnnotationValue(target, context.myContext)) != null) {
            return PyTypingTypeProvider.getType(annotation, context);
        }
        String comment = target.getTypeCommentAnnotation();
        if (comment != null) {
            return PyTypingTypeProvider.getVariableTypeCommentType(comment, target, context);
        }
        return null;
    }

    @Nullable
    public static String getTypeCommentValue(@NotNull String text) {
        Matcher m;
        if (text == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(28);
        }
        if ((m = TYPE_COMMENT_PATTERN.matcher(text)).matches()) {
            return StringUtil.nullize(m.group(1).trim());
        }
        return null;
    }

    @Nullable
    public static TextRange getTypeCommentValueRange(@NotNull String text) {
        String hint;
        Matcher m;
        if (text == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(29);
        }
        if ((m = TYPE_COMMENT_PATTERN.matcher(text)).matches() && (hint = PyTypingTypeProvider.getTypeCommentValue(text)) != null) {
            return TextRange.from(m.start(1), hint.length());
        }
        return null;
    }

    @Nullable
    public PyType getGenericType(@NotNull PyClass cls, @NotNull Context context) {
        List<PyTypeParameterType> typeParameters;
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(30);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(31);
        }
        return (typeParameters = PyTypingTypeProvider.collectTypeParameters(cls, context)).isEmpty() ? null : new PyCollectionTypeImpl(cls, false, typeParameters);
    }

    @NotNull
    public Map<PyType, PyType> getGenericSubstitutions(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(32);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(33);
        }
        Map map = PyUtil.getParameterizedCachedValue(cls, context, c -> this.calculateGenericSubstitutions(cls, (Context)c));
        if (map == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(34);
        }
        return map;
    }

    @NotNull
    private Map<PyType, PyType> calculateGenericSubstitutions(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(35);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(36);
        }
        if (!PyTypingTypeProvider.isGeneric(cls, context.myContext)) {
            Map<PyType, PyType> map = Collections.emptyMap();
            if (map == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(37);
            }
            return map;
        }
        HashMap<PyType, PyType> results = new HashMap<PyType, PyType>();
        for (PyClassType superClassType : PyTypingTypeProvider.evaluateSuperClassesAsTypeHints(cls, context.myContext)) {
            PyTypeParameterMapping mapping;
            List superTypeArguments;
            Map superSubstitutions = RecursionManager.doPreventingRecursion(superClassType.getPyClass(), false, () -> this.getGenericSubstitutions(superClassType.getPyClass(), context));
            if (superSubstitutions != null) {
                results.putAll(superSubstitutions);
            }
            List<PyTypeParameterType> superTypeParameters = PyTypingTypeProvider.collectTypeParameters(superClassType.getPyClass(), context);
            if (superClassType instanceof PyCollectionType) {
                PyCollectionType parameterized = (PyCollectionType)superClassType;
                v1 = parameterized.getElementTypes();
            } else {
                v1 = superTypeArguments = Collections.emptyList();
            }
            if ((mapping = PyTypeParameterMapping.mapByShape(superTypeParameters, superTypeArguments, (PyTypeParameterMapping.Option[])new PyTypeParameterMapping.Option[]{PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY})) == null) continue;
            for (Couple pair : mapping.getMappedTypes()) {
                PyType actualType;
                PyType expectedType = (PyType)pair.getFirst();
                if (expectedType.equals(actualType = (PyType)pair.getSecond())) continue;
                results.put(expectedType, actualType);
            }
        }
        HashMap<PyType, PyType> hashMap = results;
        if (hashMap == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(38);
        }
        return hashMap;
    }

    @NotNull
    private static List<PyClassType> evaluateSuperClassesAsTypeHints(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(39);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(40);
        }
        ArrayList<PyClassType> results = new ArrayList<PyClassType>();
        for (PyExpression superClassExpression : PyClassElementType.getSuperClassExpressions(pyClass)) {
            PyType type;
            PsiFile containingFile = superClassExpression.getContainingFile();
            if (containingFile instanceof PyExpressionCodeFragment) {
                containingFile.putUserData(FRAGMENT_OWNER, pyClass);
            }
            if (!((type = Ref.deref(PyTypingTypeProvider.getType(superClassExpression, context))) instanceof PyClassType)) continue;
            PyClassType classType = (PyClassType)type;
            results.add(classType);
        }
        ArrayList<PyClassType> arrayList = results;
        if (arrayList == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyTypeParameterType> collectTypeParameters(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(42);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(43);
        }
        if (!PyTypingTypeProvider.isGeneric(cls, context.getTypeContext())) {
            List<PyTypeParameterType> list = Collections.emptyList();
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(44);
            }
            return list;
        }
        if (cls.getTypeParameterList() != null) {
            List<PyTypeParameter> typeParameters = cls.getTypeParameterList().getTypeParameters();
            List list = StreamEx.of(typeParameters).map(typeParameter -> PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter(typeParameter, context)).nonNull().toList();
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(45);
            }
            return list;
        }
        List<PySubscriptionExpression> parameterizedSuperClassExpressions = ContainerUtil.filterIsInstance(PyClassElementType.getSuperClassExpressions(cls), PySubscriptionExpression.class);
        PySubscriptionExpression genericAsSuperClass = (PySubscriptionExpression)((Object)ContainerUtil.find(parameterizedSuperClassExpressions, s -> PyTypingTypeProvider.resolveToQualifiedNames(s.getOperand(), context.myContext).contains(GENERIC)));
        List list = ((StreamEx)((StreamEx)StreamEx.of(genericAsSuperClass != null ? Collections.singletonList(genericAsSuperClass) : parameterizedSuperClassExpressions).peek(expr -> {
            PsiFile containingFile = expr.getContainingFile();
            if (containingFile instanceof PyExpressionCodeFragment) {
                containingFile.putUserData(FRAGMENT_OWNER, cls);
            }
        })).map(PySubscriptionExpression::getIndexExpression).flatMap(e -> {
            PyTupleExpression tupleExpr = PyUtil.as(e, PyTupleExpression.class);
            return tupleExpr != null ? StreamEx.of((Object[])tupleExpr.getElements()) : StreamEx.of((Object)e);
        }).nonNull().map(e -> PyTypingTypeProvider.getType(e, context)).map(Ref::deref).flatMap(type -> {
            PyTypeChecker.Generics typeParams = PyTypeChecker.collectGenerics(type, context.myContext);
            return StreamEx.of(typeParams.getTypeVars()).append(typeParams.getTypeVarTuples()).append((Stream)StreamEx.of(typeParams.getParamSpecs()));
        }).select(PyTypeParameterType.class).distinct()).toList();
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(46);
        }
        return list;
    }

    public static boolean isGeneric(@NotNull PyWithAncestors descendant, @NotNull TypeEvalContext context) {
        PyClassType pyClassType;
        PyClass pyClass;
        if (descendant == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(47);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(48);
        }
        if (descendant instanceof PyClass && (pyClass = (PyClass)descendant).getTypeParameterList() != null || descendant instanceof PyClassType && (pyClassType = (PyClassType)descendant).getPyClass().getTypeParameterList() != null) {
            return true;
        }
        for (PyClassLikeType ancestor : descendant.getAncestorTypes(context)) {
            PyClassType classType;
            if (ancestor == null) continue;
            if (GENERIC_CLASSES.contains((Object)ancestor.getClassQName())) {
                return true;
            }
            if (!(ancestor instanceof PyClassType) || (classType = (PyClassType)ancestor).getPyClass().getTypeParameterList() == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(49);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(50);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, customContext -> PyTypingTypeProvider.getType(expression, customContext));
    }

    @Nullable
    private static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(51);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(52);
        }
        ArrayList<PyType> members = new ArrayList<PyType>();
        boolean foundAny = false;
        for (Pair<PyQualifiedNameOwner, PsiElement> pair : PyTypingTypeProvider.tryResolvingWithAliases(expression, context.getTypeContext())) {
            Ref<PyType> typeRef = PyTypingTypeProvider.getTypeForResolvedElement(expression, pair.getFirst(), pair.getSecond(), context);
            if (typeRef == null) continue;
            PyType type = typeRef.get();
            if (type == null) {
                foundAny = true;
            }
            members.add(type);
        }
        PyType union = PyUnionType.union(members);
        return union != null || foundAny ? Ref.create(union) : null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromBitwiseOrOperator(@NotNull PyBinaryExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(53);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(54);
        }
        if (expression.getOperator() != PyTokenTypes.OR) {
            return null;
        }
        PyExpression left = expression.getLeftExpression();
        PyExpression right = expression.getRightExpression();
        if (left == null || right == null) {
            return null;
        }
        Ref<PyType> leftTypeRef = PyTypingTypeProvider.getType(left, context);
        Ref<PyType> rightTypeRef = PyTypingTypeProvider.getType(right, context);
        if (leftTypeRef == null || rightTypeRef == null) {
            return null;
        }
        PyType leftType = leftTypeRef.get();
        if (leftType != null && PyTypingTypeProvider.typeHasOverloadedBitwiseOr(leftType, left, context)) {
            return null;
        }
        PyType union = PyUnionType.union(leftType, rightTypeRef.get());
        return union != null ? Ref.create(union) : null;
    }

    private static boolean typeHasOverloadedBitwiseOr(@NotNull PyType type, @NotNull PyExpression expression, @NotNull Context context) {
        if (type == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(55);
        }
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(56);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(57);
        }
        if (type instanceof PyUnionType) {
            return false;
        }
        PyType typeToClass = type instanceof PyClassLikeType ? ((PyClassLikeType)type).toClass() : type;
        List<? extends RatedResolveResult> resolved = typeToClass.resolveMember("__or__", expression, AccessDirection.READ, PyResolveContext.defaultContext(context.getTypeContext()));
        if (resolved == null || resolved.isEmpty()) {
            return false;
        }
        return StreamEx.of(resolved).map(it -> it.getElement()).nonNull().noneMatch(it -> PyBuiltinCache.getInstance(it).isBuiltin((PsiElement)it));
    }

    public static boolean isBitwiseOrUnionAvailable(@NotNull TypeEvalContext context) {
        PsiFile originFile;
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(58);
        }
        return (originFile = context.getOrigin()) == null || PyTypingTypeProvider.isBitwiseOrUnionAvailable(originFile);
    }

    public static boolean isBitwiseOrUnionAvailable(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(59);
        }
        if (LanguageLevel.forElement(element).isAtLeast(LanguageLevel.PYTHON310)) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyFile && ((PyFile)file).hasImportFromFuture(FutureFeature.ANNOTATIONS)) {
            return file == element || PsiTreeUtil.getParentOfType(element, PyAnnotation.class, false, PyStatement.class) != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Ref<PyType> getTypeForResolvedElement(@NotNull PyExpression typeHint, @Nullable PyQualifiedNameOwner alias, @NotNull PsiElement resolved, @NotNull Context context) {
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(60);
        }
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(61);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(62);
        }
        if (alias != null) {
            if (context.getTypeAliasStack().contains(alias)) {
                return null;
            }
            context.getTypeAliasStack().add(alias);
        }
        try {
            Ref<PyType> aliasedType;
            Ref<PyType> typeFromParenthesizedExpression = PyTypingTypeProvider.getTypeFromParenthesizedExpression(resolved, context);
            if (typeFromParenthesizedExpression != null) {
                Ref<PyType> ref = typeFromParenthesizedExpression;
                return ref;
            }
            PyType unionType = PyTypingTypeProvider.getUnionType(resolved, context);
            if (unionType != null) {
                Ref<PyType> ref = Ref.create(unionType);
                return ref;
            }
            PyType concatenateType = PyTypingTypeProvider.getConcatenateType(resolved, context);
            if (concatenateType != null) {
                Ref<PyType> ref = Ref.create(concatenateType);
                return ref;
            }
            Ref<PyType> optionalType = PyTypingTypeProvider.getOptionalType(resolved, context);
            if (optionalType != null) {
                Ref<PyType> ref = optionalType;
                return ref;
            }
            PyType callableType = PyTypingTypeProvider.getCallableType(resolved, context);
            if (callableType != null) {
                Ref<PyType> ref = Ref.create(callableType);
                return ref;
            }
            Ref<PyType> classVarType = PyTypingTypeProvider.unwrapTypeModifier(resolved, context, CLASS_VAR);
            if (classVarType != null) {
                Ref<PyType> ref = classVarType;
                return ref;
            }
            Ref<PyType> classObjType = PyTypingTypeProvider.getClassObjectType(resolved, context);
            if (classObjType != null) {
                Ref<PyType> ref = classObjType;
                return ref;
            }
            Ref<PyType> finalType = PyTypingTypeProvider.unwrapTypeModifier(resolved, context, FINAL, FINAL_EXT);
            if (finalType != null) {
                Ref<PyType> ref = finalType;
                return ref;
            }
            Ref<PyType> annotatedType = PyTypingTypeProvider.getAnnotatedType(resolved, context);
            if (annotatedType != null) {
                Ref<PyType> ref = annotatedType;
                return ref;
            }
            Ref<PyType> requiredOrNotRequiredType = PyTypingTypeProvider.getRequiredOrNotRequiredType(resolved, context);
            if (requiredOrNotRequiredType != null) {
                Ref<PyType> ref = requiredOrNotRequiredType;
                return ref;
            }
            Ref<PyType> literalStringType = PyTypingTypeProvider.getLiteralStringType(resolved, context);
            if (literalStringType != null) {
                Ref<PyType> ref = literalStringType;
                return ref;
            }
            Ref<PyType> literalType = PyTypingTypeProvider.getLiteralType(resolved, context);
            if (literalType != null) {
                Ref<PyType> ref = literalType;
                return ref;
            }
            Ref<PyType> typeAliasType = PyTypingTypeProvider.getExplicitTypeAliasType(resolved);
            if (typeAliasType != null) {
                Ref<PyType> ref = typeAliasType;
                return ref;
            }
            PyType parameterizedType = PyTypingTypeProvider.getParameterizedType(resolved, context);
            if (parameterizedType != null) {
                Ref<PyType> ref = Ref.create(parameterizedType);
                return ref;
            }
            PyType collection = PyTypingTypeProvider.getCollection(resolved, context.getTypeContext());
            if (collection != null) {
                Ref<PyType> ref = Ref.create(collection);
                return ref;
            }
            PyTypeParameterType typeParameter = PyTypingTypeProvider.getTypeParameterTypeFromDeclaration(resolved, context);
            if (typeParameter != null) {
                Ref<PyType> ref = Ref.create(PyTypingTypeProvider.anchorTypeParameter(typeHint, (PyType)typeParameter, context));
                return ref;
            }
            PyVariadicType unpackedType = PyTypingTypeProvider.getUnpackedType(resolved, context.getTypeContext());
            if (unpackedType != null) {
                Ref<PyVariadicType> ref = Ref.create(unpackedType);
                return ref;
            }
            PyTypeParameterType typeParameterType = PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter(resolved, context);
            if (typeParameterType != null) {
                Ref<PyTypeParameterType> ref = Ref.create(typeParameterType);
                return ref;
            }
            PyParamSpecType paramSpecType = PyTypingTypeProvider.getParamSpecType(resolved, context);
            if (paramSpecType != null) {
                Ref<PyType> ref = Ref.create(PyTypingTypeProvider.anchorTypeParameter(typeHint, (PyType)((Object)paramSpecType), context));
                return ref;
            }
            PyType stringBasedType = PyTypingTypeProvider.getStringLiteralType(resolved, context);
            if (stringBasedType != null) {
                Ref<PyType> ref = Ref.create(stringBasedType);
                return ref;
            }
            Ref<PyType> anyType = PyTypingTypeProvider.getAnyType(resolved);
            if (anyType != null) {
                Ref<PyType> ref = anyType;
                return ref;
            }
            if (alias != null && (aliasedType = PyTypingTypeProvider.getAliasedType(resolved, context)) != null) {
                Ref<PyType> ref = aliasedType;
                return ref;
            }
            PyTypedDictType typedDictType = PyTypedDictTypeProvider.Companion.getTypedDictTypeForResolvedElement(resolved, context.getTypeContext());
            if (typedDictType != null) {
                Ref<PyType> ref = Ref.create(typedDictType);
                return ref;
            }
            Ref<PyType> classType = PyTypingTypeProvider.getClassType(resolved, context.getTypeContext());
            if (classType != null) {
                Ref<PyType> ref = classType;
                return ref;
            }
            Ref<PyType> unionTypeFromBinaryOr = PyTypingTypeProvider.getTypeFromBinaryExpression(resolved, context);
            if (unionTypeFromBinaryOr != null) {
                Ref<PyType> ref = unionTypeFromBinaryOr;
                return ref;
            }
            Ref<PyType> selfType = PyTypingTypeProvider.getSelfType(resolved, typeHint, context);
            if (selfType != null) {
                Ref<PyType> ref = selfType;
                return ref;
            }
            Ref<PyType> ref = null;
            return ref;
        }
        finally {
            if (alias != null) {
                context.getTypeAliasStack().remove(alias);
            }
        }
    }

    private static Ref<PyType> getSelfType(@NotNull PsiElement resolved, @NotNull PyExpression typeHint, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(63);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(64);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(65);
        }
        if (resolved instanceof PyQualifiedNameOwner && (SELF.equals(((PyQualifiedNameOwner)resolved).getQualifiedName()) || SELF_EXT.equals(((PyQualifiedNameOwner)resolved).getQualifiedName()))) {
            PyClass containingClass;
            PsiElement typeHintContext = PyTypingTypeProvider.getStubRetainedTypeHintContext(typeHint);
            PyClass pyClass = containingClass = typeHintContext instanceof PyClass ? (PyClass)typeHintContext : PsiTreeUtil.getStubOrPsiParentOfType(typeHintContext, PyClass.class);
            if (containingClass == null) {
                return null;
            }
            PyClassType scopeClassType = PyUtil.as(containingClass.getType(context.getTypeContext()), PyClassType.class);
            if (scopeClassType == null) {
                return null;
            }
            return Ref.create(new PySelfType(scopeClassType));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromBinaryExpression(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(66);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(67);
        }
        if (resolved instanceof PyBinaryExpression) {
            return PyTypingTypeProvider.getTypeFromBitwiseOrOperator((PyBinaryExpression)resolved, context);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromParenthesizedExpression(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(68);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(69);
        }
        if (resolved instanceof PyParenthesizedExpression) {
            PyExpression containedExpression = PyPsiUtils.flattenParens((PyExpression)resolved);
            return containedExpression != null ? PyTypingTypeProvider.getType(containedExpression, context) : null;
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getExplicitTypeAliasType(@NotNull PsiElement resolved) {
        String qualifiedName;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(70);
        }
        if (resolved instanceof PyQualifiedNameOwner && (TYPE_ALIAS.equals(qualifiedName = ((PyQualifiedNameOwner)resolved).getQualifiedName()) || TYPE_ALIAS_EXT.equals(qualifiedName))) {
            return Ref.create();
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getAliasedType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(71);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(72);
        }
        if (resolved instanceof PyReferenceExpression && ((PyReferenceExpression)resolved).asQualifiedName() != null) {
            return PyTypingTypeProvider.getType((PyExpression)resolved, context);
        }
        return null;
    }

    @Nullable
    private static PyType anchorTypeParameter(@NotNull PyExpression typeHint, @Nullable PyType type, @NotNull Context context) {
        PyQualifiedNameOwner typeParamDefinitionFromStack;
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(73);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(74);
        }
        PyQualifiedNameOwner pyQualifiedNameOwner = typeParamDefinitionFromStack = context.getTypeAliasStack().isEmpty() ? null : (PyQualifiedNameOwner)context.getTypeAliasStack().peek();
        assert (typeParamDefinitionFromStack == null || typeParamDefinitionFromStack instanceof PyTargetExpression);
        PyTargetExpression targetExpr = (PyTargetExpression)typeParamDefinitionFromStack;
        if (type instanceof PyTypeVarTypeImpl) {
            PyTypeVarTypeImpl typeVar = (PyTypeVarTypeImpl)type;
            return typeVar.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(typeVar.getName(), typeHint, context)).withTargetExpression(targetExpr);
        }
        if (type instanceof PyParamSpecType) {
            PyParamSpecType paramSpec = (PyParamSpecType)((Object)type);
            return paramSpec.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(paramSpec.getName(), typeHint, context)).withTargetExpression(targetExpr);
        }
        if (type instanceof PyTypeVarTupleTypeImpl) {
            PyTypeVarTupleTypeImpl typeVarTuple = (PyTypeVarTupleTypeImpl)type;
            return typeVarTuple.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(typeVarTuple.getName(), typeHint, context)).withTargetExpression(targetExpr);
        }
        return type;
    }

    @Nullable
    private static Ref<PyType> getClassObjectType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(75);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(76);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PySubscriptionExpression subsExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subsExpr.getOperand();
            Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.getTypeContext());
            if (operandNames.contains(TYPE) || operandNames.contains("type")) {
                PyExpression indexExpr = subsExpr.getIndexExpression();
                if (indexExpr != null) {
                    if (PyTypingTypeProvider.resolveToQualifiedNames(indexExpr, context.getTypeContext()).contains(ANY)) {
                        return Ref.create(PyBuiltinCache.getInstance(resolved).getTypeType());
                    }
                    return PyTypingTypeProvider.getAsClassObjectType(indexExpr, context);
                }
                return Ref.create();
            }
        } else if (TYPE.equals(PyTypingTypeProvider.getQualifiedName(resolved))) {
            return Ref.create(PyBuiltinCache.getInstance(resolved).getTypeType());
        }
        return null;
    }

    @NotNull
    private static Ref<PyType> getAsClassObjectType(@NotNull PyExpression expression, @NotNull Context context) {
        PyType type;
        PyClassType classType;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(77);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(78);
        }
        if ((classType = PyUtil.as(type = Ref.deref(PyTypingTypeProvider.getType(expression, context)), PyClassType.class)) != null && !classType.isDefinition()) {
            Ref<PyType> ref = Ref.create(classType.toClass());
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(79);
            }
            return ref;
        }
        PyGenericType typeVar = PyUtil.as(type, PyGenericType.class);
        if (typeVar != null && !typeVar.isDefinition()) {
            Ref<PyGenericType> ref = Ref.create(typeVar.toClass());
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(80);
            }
            return ref;
        }
        PyUnionType unionType = PyUtil.as(type, PyUnionType.class);
        if (unionType != null && unionType.getMembers().stream().allMatch(t -> t instanceof PyClassType && !((PyClassType)t).isDefinition())) {
            Ref<PyType> ref = Ref.create(PyUnionType.union(ContainerUtil.map(unionType.getMembers(), t -> ((PyClassType)t).toClass())));
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(81);
            }
            return ref;
        }
        Ref<PyType> ref = Ref.create();
        if (ref == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(82);
        }
        return ref;
    }

    @Nullable
    private static Ref<PyType> getAnyType(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(83);
        }
        return ANY.equals(PyTypingTypeProvider.getQualifiedName(element)) ? Ref.create() : null;
    }

    @Nullable
    private static Ref<PyType> getClassType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(84);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(85);
        }
        if (element instanceof PyTypedElement) {
            PyType type = context.getType((PyTypedElement)element);
            if (type instanceof PyClassLikeType) {
                PyClassLikeType classType = (PyClassLikeType)type;
                if (classType.isDefinition()) {
                    Object instanceType = classType.toInstance();
                    return Ref.create(instanceType);
                }
            } else if (type instanceof PyNoneType) {
                return Ref.create(type);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getOptionalType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> operandNames;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(86);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(87);
        }
        if (element instanceof PySubscriptionExpression && (operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext())).contains(OPTIONAL)) {
            Ref<PyType> typeRef;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            if (indexExpr != null && (typeRef = PyTypingTypeProvider.getType(indexExpr, context)) != null) {
                return Ref.create(PyUnionType.union(typeRef.get(), PyNoneType.INSTANCE));
            }
            return Ref.create();
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getLiteralStringType(@NotNull PsiElement resolved, @NotNull Context context) {
        PyTargetExpression referenceExpression;
        Collection<String> operandNames;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(88);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(89);
        }
        if (resolved instanceof PyTargetExpression && ContainerUtil.exists(operandNames = PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression = (PyTargetExpression)resolved, context.getTypeContext()), name -> name.equals(LITERALSTRING) || name.equals(LITERALSTRING_EXT))) {
            PyType strType = PyBuiltinCache.getInstance(resolved).getStringType(LanguageLevel.forElement(resolved));
            return Ref.create(PyLiteralStringType.Companion.create(resolved, false));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getLiteralType(@NotNull PsiElement resolved, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        Collection<String> operandNames;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(90);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(91);
        }
        if (resolved instanceof PySubscriptionExpression && ContainerUtil.exists(operandNames = PyTypingTypeProvider.resolveToQualifiedNames((subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext()), name -> name.equals(LITERAL) || name.equals(LITERAL_EXT))) {
            return Optional.ofNullable(subscriptionExpr.getIndexExpression()).map(index -> PyLiteralType.Companion.fromLiteralParameter((PyExpression)index, context.getTypeContext())).map(Ref::create).orElse(null);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getAnnotatedType(@NotNull PsiElement resolved, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> resolvedNames;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(92);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(93);
        }
        if (resolved instanceof PySubscriptionExpression && (resolvedNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext())).stream().anyMatch(name -> ANNOTATED.equals(name) || ANNOTATED_EXT.equals(name))) {
            PyExpression type;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyExpression pyExpression = type = indexExpr instanceof PyTupleExpression ? ((PyTupleExpression)indexExpr).getElements()[0] : indexExpr;
            if (type != null) {
                return PyTypingTypeProvider.getType(type, context);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getRequiredOrNotRequiredType(@NotNull PsiElement resolved, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> resolvedNames;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(94);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(95);
        }
        if (resolved instanceof PySubscriptionExpression && (resolvedNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext())).stream().anyMatch(name -> REQUIRED.equals(name) || REQUIRED_EXT.equals(name) || NOT_REQUIRED.equals(name) || NOT_REQUIRED_EXT.equals(name))) {
            PyExpression type;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyExpression pyExpression = type = indexExpr instanceof PyTupleExpression ? ((PyTupleExpression)indexExpr).getElements()[0] : indexExpr;
            if (type != null) {
                return PyTypingTypeProvider.getType(type, context);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> unwrapTypeModifier(@NotNull PsiElement resolved, @NotNull Context context, String ... type) {
        PyExpression indexExpr;
        PySubscriptionExpression subscriptionExpr;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(96);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(97);
        }
        if (resolved instanceof PySubscriptionExpression && PyTypingTypeProvider.resolvesToQualifiedNames((subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext(), type) && (indexExpr = subscriptionExpr.getIndexExpression()) != null) {
            return PyTypingTypeProvider.getType(indexExpr, context);
        }
        return null;
    }

    private static <T extends PyTypeCommentOwner & PyAnnotationOwner> boolean typeHintedWithName(@NotNull T owner, @NotNull TypeEvalContext context, String ... names) {
        PyExpression typeComment;
        PyStringLiteralExpression stringLiteralExpression;
        String annotationText;
        PyExpression annotation;
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(98);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(99);
        }
        if ((annotation = PyTypingTypeProvider.getAnnotationValue(owner, context)) instanceof PyStringLiteralExpression && (annotation = PyTypingTypeProvider.toExpression(annotationText = (stringLiteralExpression = (PyStringLiteralExpression)annotation).getStringValue(), owner)) == null) {
            return false;
        }
        if (annotation instanceof PySubscriptionExpression) {
            return PyTypingTypeProvider.resolvesToQualifiedNames(((PySubscriptionExpression)annotation).getOperand(), context, names);
        }
        if (annotation instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolvesToQualifiedNames(annotation, context, names);
        }
        String typeCommentValue = owner.getTypeCommentAnnotation();
        PyExpression pyExpression = typeComment = typeCommentValue == null ? null : PyTypingTypeProvider.toExpression(typeCommentValue, owner);
        if (typeComment instanceof PySubscriptionExpression) {
            return PyTypingTypeProvider.resolvesToQualifiedNames(((PySubscriptionExpression)typeComment).getOperand(), context, names);
        }
        if (typeComment instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolvesToQualifiedNames(typeComment, context, names);
        }
        return false;
    }

    public static boolean isFinal(@NotNull PyDecoratable decoratable, @NotNull TypeEvalContext context) {
        if (decoratable == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(100);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(101);
        }
        return ContainerUtil.exists(PyKnownDecoratorUtil.getKnownDecorators((PyDecoratable)decoratable, (TypeEvalContext)context), d -> d == PyKnownDecoratorUtil.KnownDecorator.TYPING_FINAL || d == PyKnownDecoratorUtil.KnownDecorator.TYPING_FINAL_EXT);
    }

    public static <T extends PyTypeCommentOwner & PyAnnotationOwner> boolean isFinal(@NotNull T owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(102);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(103);
        }
        return PyUtil.getParameterizedCachedValue(owner, context, p -> PyTypingTypeProvider.typeHintedWithName(owner, context, FINAL, FINAL_EXT));
    }

    public static <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isClassVar(@NotNull T owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(104);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(105);
        }
        return PyUtil.getParameterizedCachedValue(owner, context, p -> PyTypingTypeProvider.typeHintedWithName(owner, context, CLASS_VAR));
    }

    public static boolean isNoReturn(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(106);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(107);
        }
        return PyUtil.getParameterizedCachedValue(function, context, p -> PyTypingTypeProvider.typeHintedWithName(function, context, NO_RETURN, NO_RETURN_EXT, NEVER, NEVER_EXT));
    }

    public static boolean isTypeGuard(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(108);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(109);
        }
        return PyUtil.getParameterizedCachedValue(function, context, p -> PyTypingTypeProvider.typeHintedWithName(function, context, TYPE_GUARD, TYPE_GUARD_EXT));
    }

    private static boolean resolvesToQualifiedNames(@NotNull PyExpression expression, @NotNull TypeEvalContext context, String ... names) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(110);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(111);
        }
        Collection<String> qualifiedNames = PyTypingTypeProvider.resolveToQualifiedNames(expression, context);
        return ContainerUtil.exists(names, qualifiedNames::contains);
    }

    @Nullable
    private static PyExpression getAnnotationValue(@NotNull PyAnnotationOwner owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(112);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(113);
        }
        if (context.maySwitchToAST(owner)) {
            PyAnnotation annotation = owner.getAnnotation();
            if (annotation != null) {
                return annotation.getValue();
            }
        } else {
            String annotationText = owner.getAnnotationValue();
            if (annotationText != null) {
                return PyTypingTypeProvider.toExpression(annotationText, owner);
            }
        }
        return null;
    }

    @Nullable
    private static PyExpression toExpression(@NotNull String contents, @NotNull PsiElement anchor) {
        PsiFile file;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(114);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(115);
        }
        if ((file = FileContextUtil.getContextFile(anchor)) == null) {
            return null;
        }
        PyExpression fragment = PyUtil.createExpressionFromFragment(contents, file);
        if (fragment != null) {
            fragment.getContainingFile().putUserData(FRAGMENT_OWNER, anchor);
        }
        return fragment;
    }

    @Nullable
    public static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(116);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(117);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(118);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, c -> PyTypingTypeProvider.getStringBasedType(contents, anchor, c));
    }

    @Nullable
    private static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull Context context) {
        PyExpression expr;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(119);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(120);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(121);
        }
        return (expr = PyTypingTypeProvider.toExpression(contents, anchor)) != null ? PyTypingTypeProvider.getType(expr, context) : null;
    }

    @Nullable
    private static PyType getStringLiteralType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(122);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(123);
        }
        if (element instanceof PyStringLiteralExpression) {
            String contents = ((PyStringLiteralExpression)element).getStringValue();
            return Ref.deref(PyTypingTypeProvider.getStringBasedType(contents, element, context));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getVariableTypeCommentType(@NotNull String contents, @NotNull PyTargetExpression target, @NotNull Context context) {
        PyExpression expr;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(124);
        }
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(125);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(126);
        }
        if ((expr = PyPsiUtils.flattenParens(PyTypingTypeProvider.toExpression(contents, target))) != null) {
            if (expr instanceof PyTupleExpression) {
                Map<PyTargetExpression, PyExpression> targetToExpr;
                PyExpression typeExpr;
                PyExpression topmostTarget = PyTypingTypeProvider.findTopmostTarget(target);
                if (topmostTarget != null && (typeExpr = (targetToExpr = PyTypingTypeProvider.mapTargetsToAnnotations(topmostTarget, expr)).get(target)) != null) {
                    return PyTypingTypeProvider.getType(typeExpr, context);
                }
            } else {
                return PyTypingTypeProvider.getType(expr, context);
            }
        }
        return null;
    }

    @Nullable
    private static PyExpression findTopmostTarget(@NotNull PyTargetExpression target) {
        PyElement validTargetParent;
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(127);
        }
        if ((validTargetParent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)target, PyForPart.class, PyWithItem.class, PyAssignmentStatement.class)) == null) {
            return null;
        }
        PyExpression topmostTarget = PyUtil.as(PsiTreeUtil.findPrevParent(validTargetParent, target), PyExpression.class);
        if (validTargetParent instanceof PyForPart && topmostTarget != ((PyForPart)validTargetParent).getTarget()) {
            return null;
        }
        if (validTargetParent instanceof PyWithItem && topmostTarget != ((PyWithItem)validTargetParent).getTarget()) {
            return null;
        }
        if (validTargetParent instanceof PyAssignmentStatement && ArrayUtil.indexOf(((PyAssignmentStatement)validTargetParent).getRawTargets(), topmostTarget) < 0) {
            return null;
        }
        return topmostTarget;
    }

    @NotNull
    public static Map<PyTargetExpression, PyExpression> mapTargetsToAnnotations(@NotNull PyExpression targetExpr, @NotNull PyExpression typeExpr) {
        if (targetExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(128);
        }
        if (typeExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(129);
        }
        PyExpression targetsNoParen = PyPsiUtils.flattenParens(targetExpr);
        PyExpression typesNoParen = PyPsiUtils.flattenParens(typeExpr);
        if (targetsNoParen == null || typesNoParen == null) {
            Map<PyTargetExpression, PyExpression> map = Collections.emptyMap();
            if (map == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(130);
            }
            return map;
        }
        if (targetsNoParen instanceof PySequenceExpression && typesNoParen instanceof PySequenceExpression) {
            Ref<Map<PyTargetExpression, PyExpression>> result2 = new Ref<Map<PyTargetExpression, PyExpression>>(new LinkedHashMap());
            PyTypingTypeProvider.mapTargetsToExpressions((PySequenceExpression)targetsNoParen, (PySequenceExpression)typesNoParen, result2);
            Map<PyTargetExpression, PyExpression> map = result2.isNull() ? Collections.emptyMap() : Collections.unmodifiableMap(result2.get());
            if (map == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(131);
            }
            return map;
        }
        if (targetsNoParen instanceof PyTargetExpression && !(typesNoParen instanceof PySequenceExpression)) {
            ImmutableMap immutableMap = ImmutableMap.of((Object)((PyTargetExpression)targetsNoParen), (Object)typesNoParen);
            if (immutableMap == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(132);
            }
            return immutableMap;
        }
        Map<PyTargetExpression, PyExpression> map = Collections.emptyMap();
        if (map == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(133);
        }
        return map;
    }

    private static void mapTargetsToExpressions(@NotNull PySequenceExpression targetSequence, @NotNull PySequenceExpression valueSequence, @NotNull Ref<Map<PyTargetExpression, PyExpression>> result2) {
        PyExpression[] values;
        PyExpression[] targets;
        if (targetSequence == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(134);
        }
        if (valueSequence == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(135);
        }
        if (result2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(136);
        }
        if ((targets = targetSequence.getElements()).length != (values = valueSequence.getElements()).length) {
            result2.set(null);
            return;
        }
        for (int i = 0; i < targets.length; ++i) {
            PyExpression target = PyPsiUtils.flattenParens(targets[i]);
            PyExpression value = PyPsiUtils.flattenParens(values[i]);
            if (target == null || value == null) {
                result2.set(null);
                return;
            }
            if (target instanceof PySequenceExpression && value instanceof PySequenceExpression) {
                PyTypingTypeProvider.mapTargetsToExpressions((PySequenceExpression)target, (PySequenceExpression)value, result2);
                if (!result2.isNull()) continue;
                return;
            }
            if (target instanceof PyTargetExpression && !(value instanceof PySequenceExpression)) {
                Map<PyTargetExpression, PyExpression> map = result2.get();
                assert (map != null);
                map.put((PyTargetExpression)target, value);
                continue;
            }
            result2.set(null);
            return;
        }
    }

    @Nullable
    private static PyType getCallableType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(137);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(138);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PyTupleExpression tupleExpr;
            PyExpression[] elements;
            PyExpression indexExpr;
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subscriptionExpr.getOperand();
            Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.getTypeContext());
            if (operandNames.contains(CALLABLE) && (indexExpr = subscriptionExpr.getIndexExpression()) instanceof PyTupleExpression && (elements = (tupleExpr = (PyTupleExpression)indexExpr).getElements()).length == 2) {
                Pair<List<PyType>, PyParamSpecType> concatenateParameters;
                PyType parameters2;
                PyExpression parametersExpr = elements[0];
                PyExpression returnTypeExpr = elements[1];
                if (parametersExpr instanceof PyListLiteralExpression) {
                    PyListLiteralExpression listExpr = (PyListLiteralExpression)parametersExpr;
                    ArrayList<PyCallableParameter> parameters2 = new ArrayList<PyCallableParameter>();
                    for (PyExpression argExpr : listExpr.getElements()) {
                        parameters2.add(PyCallableParameterImpl.nonPsi(Ref.deref(PyTypingTypeProvider.getType(argExpr, context))));
                    }
                    PyType returnType = Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context));
                    return new PyCallableTypeImpl(parameters2, returnType);
                }
                if (PyTypingTypeProvider.isEllipsis(parametersExpr)) {
                    return new PyCallableTypeImpl(null, Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context)));
                }
                if (parametersExpr instanceof PyReferenceExpression && (parameters2 = Ref.deref(PyTypingTypeProvider.getType(parametersExpr, context.myContext))) instanceof PyParamSpecType) {
                    PyParamSpecType paramSpec = (PyParamSpecType)((Object)parameters2);
                    PyCallableParameter parameter = PyCallableParameterImpl.nonPsi(parametersExpr.getName(), (PyType)((Object)paramSpec));
                    return new PyCallableTypeImpl(Collections.singletonList(parameter), Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context)));
                }
                if (parametersExpr instanceof PySubscriptionExpression && PyTypingTypeProvider.isConcatenate(parametersExpr, context.myContext) && (concatenateParameters = PyTypingTypeProvider.getConcatenateParametersTypes((PySubscriptionExpression)parametersExpr, context.myContext)) != null) {
                    PyConcatenateType concatenate = new PyConcatenateType((List)concatenateParameters.first, (PyParamSpecType)concatenateParameters.second);
                    PyCallableParameter parameter = PyCallableParameterImpl.nonPsi(parametersExpr.getName(), concatenate);
                    return new PyCallableTypeImpl(Collections.singletonList(parameter), Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context)));
                }
            }
        } else if (resolved instanceof PyTargetExpression && PyTypingTypeProvider.resolveToQualifiedNames((PyTargetExpression)resolved, context.getTypeContext()).contains(CALLABLE)) {
            return new PyCallableTypeImpl(null, null);
        }
        return null;
    }

    private static boolean isEllipsis(@NotNull PyExpression parametersExpr) {
        if (parametersExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(139);
        }
        return parametersExpr instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)parametersExpr).isEllipsis();
    }

    public static boolean isParamSpec(@NotNull PyExpression parametersExpr, @NotNull TypeEvalContext context) {
        if (parametersExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(140);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(141);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return PyUtil.multiResolveTopPriority(parametersExpr, resolveContext).stream().anyMatch(it -> {
            if (!(it instanceof PyTypedElement)) {
                return false;
            }
            PyType type = context.getType((PyTypedElement)it);
            return PyTypingTypeProvider.isParamSpec(type);
        });
    }

    private static boolean isParamSpec(@Nullable PyType type) {
        if (type instanceof PyClassLikeType) {
            String classQName = ((PyClassLikeType)type).getClassQName();
            return TYPING_PARAM_SPEC.equals(classQName) || TYPING_EXTENSIONS_PARAM_SPEC.equals(classQName);
        }
        if (type instanceof PyUnionType) {
            return ((PyUnionType)type).getMembers().stream().anyMatch(it -> PyTypingTypeProvider.isParamSpec(it));
        }
        return false;
    }

    public static boolean isConcatenate(@NotNull PyExpression parametersExpr, @NotNull TypeEvalContext context) {
        if (parametersExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(142);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(143);
        }
        if (!(parametersExpr instanceof PySubscriptionExpression)) {
            return false;
        }
        PyType type = Ref.deref(PyTypingTypeProvider.getType(parametersExpr, context));
        return type instanceof PyConcatenateType;
    }

    @Nullable
    private static PyType getUnionType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> operandNames;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(144);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(145);
        }
        if (element instanceof PySubscriptionExpression && (operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext())).contains(UNION)) {
            return PyUnionType.union(PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context));
        }
        return null;
    }

    @Nullable
    private static PyType getConcatenateType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(146);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(147);
        }
        if (!(element instanceof PySubscriptionExpression)) {
            return null;
        }
        PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
        PyExpression operand = subscriptionExpr.getOperand();
        Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.myContext);
        if (!operandNames.contains(TYPING_CONCATENATE) && !operandNames.contains(TYPING_EXTENSIONS_CONCATENATE)) {
            return null;
        }
        Pair<List<PyType>, PyParamSpecType> parameters = PyTypingTypeProvider.getConcatenateParametersTypes(subscriptionExpr, context.myContext);
        if (parameters == null) {
            return null;
        }
        return new PyConcatenateType((List)parameters.first, (PyParamSpecType)parameters.second);
    }

    @Nullable
    private static Pair<List<PyType>, PyParamSpecType> getConcatenateParametersTypes(@NotNull PySubscriptionExpression subscriptionExpression, @NotNull TypeEvalContext context) {
        PyExpression tuple;
        if (subscriptionExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(148);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(149);
        }
        if (!((tuple = subscriptionExpression.getIndexExpression()) instanceof PyTupleExpression)) {
            return null;
        }
        List<PyType> result2 = ContainerUtil.mapNotNull(((PyTupleExpression)tuple).getElements(), it -> Ref.deref(PyTypingTypeProvider.getType(it, context)));
        if (result2.size() < 2) {
            return null;
        }
        PyType lastParameter = result2.get(result2.size() - 1);
        if (!(lastParameter instanceof PyParamSpecType)) {
            return null;
        }
        return new Pair<List<PyType>, PyParamSpecType>(result2.subList(0, result2.size() - 1), (PyParamSpecType)((Object)lastParameter));
    }

    @Nullable
    private static PyTypeParameterType getTypeParameterTypeFromDeclaration(@NotNull PsiElement element, @NotNull Context context) {
        PyExpression firstArgument;
        PyExpression[] arguments;
        Collection<String> calleeQNames;
        PyCallExpression assignedCall;
        PyExpression callee;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(150);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(151);
        }
        if (element instanceof PyCallExpression && (callee = (assignedCall = (PyCallExpression)element).getCallee()) != null && ((calleeQNames = PyTypingTypeProvider.resolveToQualifiedNames(callee, context.getTypeContext())).contains(TYPE_VAR) || calleeQNames.contains(TYPE_VAR_TUPLE)) && (arguments = assignedCall.getArguments()).length > 0 && (firstArgument = arguments[0]) instanceof PyStringLiteralExpression) {
            String name = ((PyStringLiteralExpression)firstArgument).getStringValue();
            if (calleeQNames.contains(TYPE_VAR_TUPLE)) {
                return new PyTypeVarTupleTypeImpl(name);
            }
            return new PyTypeVarTypeImpl(name, PyTypingTypeProvider.getGenericTypeBound(arguments, context));
        }
        return null;
    }

    @Nullable
    private static PyTypeParameterType getTypeParameterTypeFromTypeParameter(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(152);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(153);
        }
        if (element instanceof PyTypeParameter) {
            PyExpression boundExpression;
            PyQualifiedNameOwner qualifiedNameOwner;
            PyTypeParameter typeParameter = (PyTypeParameter)element;
            PyTypeParameterListOwner typeParameterOwner = PsiTreeUtil.getStubOrPsiParentOfType(element, PyTypeParameterListOwner.class);
            PyQualifiedNameOwner scopeOwner = typeParameterOwner instanceof PyQualifiedNameOwner ? (qualifiedNameOwner = (PyQualifiedNameOwner)((Object)typeParameterOwner)) : null;
            String boundExpressionText = typeParameter.getBoundExpressionText();
            String name = typeParameter.getName();
            PyTypeParameter.Kind kind = typeParameter.getKind();
            PyExpression pyExpression = boundExpression = boundExpressionText != null ? PyUtil.createExpressionFromFragment(boundExpressionText, typeParameter.getContainingFile()) : null;
            if (name != null) {
                return switch (1.$SwitchMap$com$jetbrains$python$psi$PyTypeParameter$Kind[kind.ordinal()]) {
                    default -> throw new IncompatibleClassChangeError();
                    case 1 -> {
                        PyType boundType = boundExpression != null ? PyTypingTypeProvider.getTypeParameterBoundType(boundExpression, context) : null;
                        yield new PyTypeVarTypeImpl(name, boundType).withScopeOwner(scopeOwner);
                    }
                    case 2 -> new PyParamSpecType(name).withScopeOwner(scopeOwner);
                    case 3 -> new PyTypeVarTupleTypeImpl(name).withScopeOwner(scopeOwner);
                };
            }
        }
        return null;
    }

    @Nullable
    private static PyQualifiedNameOwner getTypeParameterScope(@NotNull String name, @NotNull PyExpression typeHint, @NotNull Context context) {
        PsiElement typeHintContext;
        List typeParamOwnerCandidates;
        PyQualifiedNameOwner closestOwner;
        if (name == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(154);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(155);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(156);
        }
        if ((closestOwner = (PyQualifiedNameOwner)ContainerUtil.getFirstItem(typeParamOwnerCandidates = ((StreamEx)StreamEx.iterate((Object)(typeHintContext = PyTypingTypeProvider.getStubRetainedTypeHintContext(typeHint)), Objects::nonNull, owner -> PsiTreeUtil.getStubOrPsiParentOfType(owner, ScopeOwner.class)).filter(owner -> owner instanceof PyFunction || owner instanceof PyClass)).select(PyQualifiedNameOwner.class).toList())) instanceof PyClass) {
            return closestOwner;
        }
        return ((StreamEx)StreamEx.of((Collection)typeParamOwnerCandidates).skip(1L)).map(owner -> PyTypingTypeProvider.findSameTypeParameterInDefinition(owner, name, context)).nonNull().findFirst().map(PyTypeParameterType::getScopeOwner).orElse(closestOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PyTypeParameterType findSameTypeParameterInDefinition(@NotNull PyQualifiedNameOwner owner, @NotNull String name, @NotNull Context context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(157);
        }
        if (name == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(158);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(159);
        }
        PyQualifiedNameOwner typeVarDeclaration = (PyQualifiedNameOwner)context.getTypeAliasStack().pop();
        assert (typeVarDeclaration instanceof PyTargetExpression);
        try {
            if (owner instanceof PyClass) {
                PyTypeParameterType pyTypeParameterType = StreamEx.of(PyTypingTypeProvider.collectTypeParameters((PyClass)owner, context)).findFirst(type -> name.equals(type.getName())).orElse(null);
                return pyTypeParameterType;
            }
            if (owner instanceof PyFunction) {
                PyTypeParameterType pyTypeParameterType = StreamEx.of((Object[])((PyFunction)owner).getParameterList().getParameters()).select(PyNamedParameter.class).map(parameter -> new PyTypingTypeProvider().getParameterType((PyNamedParameter)parameter, (PyFunction)owner, context)).map(Ref::deref).map(paramType -> PyTypeChecker.collectGenerics(paramType, context.getTypeContext())).flatMap(generics -> StreamEx.of(generics.getTypeVars()).append(generics.getParamSpecs()).append(generics.getTypeVarTuples())).findFirst(type -> name.equals(type.getName())).orElse(null);
                return pyTypeParameterType;
            }
        }
        finally {
            context.getTypeAliasStack().push(typeVarDeclaration);
        }
        return null;
    }

    @NotNull
    private static PsiElement getStubRetainedTypeHintContext(@NotNull PsiElement typeHintExpression) {
        PsiElement fragmentOwner;
        if (typeHintExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(160);
        }
        if ((fragmentOwner = typeHintExpression.getContainingFile().getUserData(FRAGMENT_OWNER)) != null) {
            PsiElement psiElement = fragmentOwner;
            if (psiElement == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(161);
            }
            return psiElement;
        }
        if (typeHintExpression.getContainingFile() instanceof PyFunctionTypeAnnotationFile) {
            PsiElement psiElement = PyPsiUtils.getRealContext(typeHintExpression);
            if (psiElement == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(162);
            }
            return psiElement;
        }
        PsiElement psiElement = typeHintExpression;
        if (psiElement == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(163);
        }
        return psiElement;
    }

    @Nullable
    public static PyVariadicType getUnpackedType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(164);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(165);
        }
        if (!(element instanceof PyStarExpression)) {
            return null;
        }
        PyStarExpression starExpression = (PyStarExpression)element;
        PyExpression typeHint = starExpression.getExpression();
        if (!(typeHint instanceof PyReferenceExpression) && !(typeHint instanceof PySubscriptionExpression)) {
            return null;
        }
        Ref<PyType> typeRef = PyTypingTypeProvider.getType(typeHint, context);
        if (typeRef == null) {
            return null;
        }
        PyType expressionType = typeRef.get();
        if (expressionType instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)expressionType;
            return new PyUnpackedTupleTypeImpl(tupleType.getElementTypes(), tupleType.isHomogeneous());
        }
        if (expressionType instanceof PyTypeVarTupleType) {
            PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)expressionType;
            return typeVarTupleType;
        }
        return null;
    }

    @Nullable
    private static PyParamSpecType getParamSpecType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(166);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(167);
        }
        if (!(element instanceof PyCallExpression)) {
            return null;
        }
        PyCallExpression assignedCall = (PyCallExpression)element;
        PyExpression callee = assignedCall.getCallee();
        if (callee == null) {
            return null;
        }
        Collection<String> calleeQNames = PyTypingTypeProvider.resolveToQualifiedNames(callee, context.getTypeContext());
        if (!calleeQNames.contains(TYPING_PARAM_SPEC) && !calleeQNames.contains(TYPING_EXTENSIONS_PARAM_SPEC)) {
            return null;
        }
        PyExpression[] arguments = assignedCall.getArguments();
        if (arguments.length == 0) {
            return null;
        }
        PyExpression firstArgument = arguments[0];
        if (!(firstArgument instanceof PyStringLiteralExpression)) {
            return null;
        }
        String name = ((PyStringLiteralExpression)firstArgument).getStringValue();
        return new PyParamSpecType(name);
    }

    @Nullable
    private static PyType getGenericTypeBound(PyExpression @NotNull [] typeVarArguments, @NotNull Context context) {
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(168);
        }
        if (typeVarArguments == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(169);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        for (int i = 1; i < typeVarArguments.length; ++i) {
            PyExpression argument = typeVarArguments[i];
            if (argument instanceof PyKeywordArgument) {
                if (!"bound".equals(((PyKeywordArgument)argument).getKeyword())) break;
                PyExpression value = ((PyKeywordArgument)argument).getValueExpression();
                return value == null ? null : Ref.deref(PyTypingTypeProvider.getType(value, context));
            }
            types.add(Ref.deref(PyTypingTypeProvider.getType(argument, context)));
        }
        return PyUnionType.union(types);
    }

    @Nullable
    private static PyType getTypeParameterBoundType(@NotNull PyExpression boundExpression, @NotNull Context context) {
        PyExpression bound;
        if (boundExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(170);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(171);
        }
        if ((bound = PyPsiUtils.flattenParens(boundExpression)) != null) {
            if (bound instanceof PyTupleExpression) {
                PyTupleExpression tupleExpression = (PyTupleExpression)bound;
                return (PyType)StreamEx.of((Object[])tupleExpression.getElements()).map(expr -> Ref.deref(PyTypingTypeProvider.getType(expr, context))).collect(PyTypeUtil.toUnion());
            }
            return Ref.deref(PyTypingTypeProvider.getType(bound, context));
        }
        return null;
    }

    @NotNull
    private static List<PyType> getIndexTypes(@NotNull PySubscriptionExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(172);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(173);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        PyExpression indexExpr = expression.getIndexExpression();
        if (indexExpr instanceof PyTupleExpression) {
            PyTupleExpression tupleExpr = (PyTupleExpression)indexExpr;
            for (PyExpression expr : tupleExpr.getElements()) {
                types.add(Ref.deref(PyTypingTypeProvider.getType(expr, context)));
            }
        } else if (indexExpr != null) {
            types.add(Ref.deref(PyTypingTypeProvider.getType(indexExpr, context)));
        }
        ArrayList<PyType> arrayList = types;
        if (arrayList == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(174);
        }
        return arrayList;
    }

    @Nullable
    private static PyType getParameterizedType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(175);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(176);
        }
        if (element instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
            PyExpression operand = subscriptionExpr.getOperand();
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            if (indexExpr != null) {
                PyType operandType = Ref.deref(PyTypingTypeProvider.getType(operand, context));
                List<PyType> indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
                if (operandType instanceof PyClassType && !(operandType instanceof PyTupleType) && "tuple".equals(((PyClassType)operandType).getPyClass().getQualifiedName())) {
                    PyExpression[] elements;
                    if (indexExpr instanceof PyTupleExpression && (elements = ((PyTupleExpression)indexExpr).getElements()).length == 2 && PyTypingTypeProvider.isEllipsis(elements[1])) {
                        return PyTupleType.createHomogeneous(element, indexTypes.get(0));
                    }
                    return PyTupleType.create(element, indexTypes);
                }
                if (operandType != null) {
                    return PyTypeChecker.parameterizeType(operandType, indexTypes, context.getTypeContext());
                }
            }
        }
        return null;
    }

    @Nullable
    private static PyType getCollection(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        String typingName;
        String builtinName;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(177);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(178);
        }
        if ((builtinName = (String)BUILTIN_COLLECTION_CLASSES.get((Object)(typingName = PyTypingTypeProvider.getQualifiedName(element)))) != null) {
            return PyTypeParser.getTypeByName(element, builtinName, context);
        }
        String collectionName = (String)COLLECTIONS_CLASSES.get((Object)typingName);
        if (collectionName != null) {
            return PyTypeParser.getTypeByName(element, collectionName, context);
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> tryResolving(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(179);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(180);
        }
        List<PsiElement> list = ContainerUtil.map(PyTypingTypeProvider.tryResolvingWithAliases(expression, context), x -> (PsiElement)x.getSecond());
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(181);
        }
        return list;
    }

    @NotNull
    private static List<Pair<PyQualifiedNameOwner, PsiElement>> tryResolvingWithAliases(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(182);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(183);
        }
        ArrayList<Pair<PyQualifiedNameOwner, PsiElement>> elements = new ArrayList<Pair<PyQualifiedNameOwner, PsiElement>>();
        if (expression instanceof PyReferenceExpression) {
            List<PsiElement> results;
            if (context.maySwitchToAST(expression)) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
                results = PyUtil.multiResolveTopPriority(expression, resolveContext);
            } else {
                results = PyTypingTypeProvider.tryResolvingOnStubs((PyReferenceExpression)expression, context);
            }
            for (PsiElement element : results) {
                PyTargetExpression targetExpr;
                PyExpression assignedValue;
                String name;
                PyClass cls = PyUtil.turnConstructorIntoClass(PyUtil.as(element, PyFunction.class));
                if (cls != null) {
                    elements.add(Pair.create(null, cls));
                    continue;
                }
                String string = name = element != null ? PyTypingTypeProvider.getQualifiedName(element) : null;
                if (name != null && OPAQUE_NAMES.contains((Object)name)) {
                    elements.add(Pair.create(null, element));
                    continue;
                }
                if (element instanceof PyTargetExpression && (assignedValue = context.maySwitchToAST(targetExpr = (PyTargetExpression)element) ? targetExpr.findAssignedValue() : PyTypingAliasStubType.getAssignedValueStubLike(targetExpr)) != null) {
                    elements.add(Pair.create(targetExpr, assignedValue));
                    continue;
                }
                if (element instanceof PyTypeAliasStatement) {
                    PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)element;
                    if (context.maySwitchToAST(typeAliasStatement)) {
                        assignedValue = typeAliasStatement.getTypeExpression();
                    } else {
                        String assignedTypeText = typeAliasStatement.getTypeExpressionText();
                        PyExpression pyExpression = assignedValue = assignedTypeText != null ? PyTypingTypeProvider.toExpression(assignedTypeText, typeAliasStatement) : null;
                    }
                    if (assignedValue != null) {
                        elements.add(Pair.create(typeAliasStatement, assignedValue));
                        continue;
                    }
                }
                if (element == null) continue;
                elements.add(Pair.create(null, element));
            }
        }
        List<Pair<PyQualifiedNameOwner, PsiElement>> list = !elements.isEmpty() ? elements : Collections.singletonList(Pair.create(null, expression));
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(184);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> tryResolvingOnStubs(@NotNull PyReferenceExpression expression, @NotNull TypeEvalContext context) {
        ScopeOwner scopeOwner;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(185);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(186);
        }
        QualifiedName qualifiedName = expression.asQualifiedName();
        PyFile pyFile = PyUtil.as(FileContextUtil.getContextFile(expression), PyFile.class);
        PsiElement anchor = expression.getContainingFile().getUserData(FRAGMENT_OWNER);
        if (anchor == null) {
            scopeOwner = pyFile;
        } else if (anchor instanceof ScopeOwner) {
            ScopeOwner anchorAsScope = (ScopeOwner)anchor;
            scopeOwner = anchorAsScope;
        } else {
            scopeOwner = ScopeUtil.getScopeOwner(anchor);
        }
        if (scopeOwner != null && qualifiedName != null) {
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            while (scopeOwner != null) {
                results.addAll(PyResolveUtil.resolveQualifiedNameInScope(qualifiedName, scopeOwner, context));
                scopeOwner = ScopeUtil.getScopeOwner(scopeOwner);
            }
            ArrayList<PsiElement> arrayList = results;
            if (arrayList == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(187);
            }
            return arrayList;
        }
        List<PsiElement> list = Collections.singletonList(expression);
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(188);
        }
        return list;
    }

    @NotNull
    public static Collection<String> resolveToQualifiedNames(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(189);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(190);
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PsiElement resolved : PyTypingTypeProvider.tryResolving(expression, context)) {
            String name = PyTypingTypeProvider.getQualifiedName(resolved);
            if (name == null) continue;
            names.add(name);
        }
        LinkedHashSet<String> linkedHashSet = names;
        if (linkedHashSet == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(191);
        }
        return linkedHashSet;
    }

    @Nullable
    private static String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(192);
        }
        if (element instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)element;
            return qualifiedNameOwner.getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static PyType toAsyncIfNeeded(@NotNull PyFunction function, @Nullable PyType returnType) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(193);
        }
        if (function.isAsync() && function.isAsyncAllowed()) {
            if (!function.isGenerator()) {
                return PyTypingTypeProvider.wrapInCoroutineType(returnType, function);
            }
            if (returnType instanceof PyCollectionType && PyTypingTypeProvider.isGenerator(returnType)) {
                return PyTypingTypeProvider.wrapInAsyncGeneratorType(((PyCollectionType)returnType).getIteratedItemType(), function);
            }
        }
        return returnType;
    }

    @Nullable
    private static PyType wrapInCoroutineType(@Nullable PyType returnType, @NotNull PsiElement resolveAnchor) {
        PyClass coroutine;
        if (resolveAnchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(194);
        }
        return (coroutine = PyPsiFacade.getInstance(resolveAnchor.getProject()).createClassByQName(COROUTINE, resolveAnchor)) != null ? new PyCollectionTypeImpl(coroutine, false, Arrays.asList(null, null, returnType)) : null;
    }

    @Nullable
    public static PyType wrapInGeneratorType(@Nullable PyType elementType, @Nullable PyType returnType, @NotNull PsiElement anchor) {
        PyClass generator;
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(195);
        }
        return (generator = PyPsiFacade.getInstance(anchor.getProject()).createClassByQName(GENERATOR, anchor)) != null ? new PyCollectionTypeImpl(generator, false, Arrays.asList(elementType, null, returnType)) : null;
    }

    @Nullable
    private static PyType wrapInAsyncGeneratorType(@Nullable PyType elementType, @NotNull PsiElement anchor) {
        PyClass asyncGenerator;
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(196);
        }
        return (asyncGenerator = PyPsiFacade.getInstance(anchor.getProject()).createClassByQName(ASYNC_GENERATOR, anchor)) != null ? new PyCollectionTypeImpl(asyncGenerator, false, Arrays.asList(elementType, null)) : null;
    }

    @Nullable
    public static Ref<PyType> coroutineOrGeneratorElementType(@Nullable PyType coroutineOrGeneratorType) {
        PyCollectionType genericType = PyUtil.as(coroutineOrGeneratorType, PyCollectionType.class);
        PyClassType classType = PyUtil.as(coroutineOrGeneratorType, PyClassType.class);
        if (genericType != null && classType != null) {
            String qName = classType.getClassQName();
            if ("typing.Awaitable".equals(qName)) {
                return Ref.create(ContainerUtil.getOrElse(genericType.getElementTypes(), 0, null));
            }
            if (ArrayUtil.contains(qName, COROUTINE, GENERATOR)) {
                return Ref.create(ContainerUtil.getOrElse(genericType.getElementTypes(), 2, null));
            }
        }
        return null;
    }

    @NotNull
    public static Ref<PyType> getOpenFunctionCallType(@NotNull PyFunction function, @NotNull PyCallExpression call, @NotNull LanguageLevel typeLevel, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(197);
        }
        if (call == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(198);
        }
        if (typeLevel == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(199);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(200);
        }
        String type = typeLevel.isPython2() ? "typing.BinaryIO" : (PyTypingTypeProvider.getOpenMode(function, call, context).contains("b") ? "typing.BinaryIO" : PY3_TEXT_FILE_TYPE);
        Ref<PyType> ref = Ref.create(PyTypeParser.getTypeByName(call, type, context));
        if (ref == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(201);
        }
        return ref;
    }

    public static boolean isExplicitTypeAlias(@NotNull PyAssignmentStatement assignment, @NotNull TypeEvalContext context) {
        PyExpression commentValue;
        String typeCommentAnnotation;
        PyExpression annotationValue;
        if (assignment == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(202);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(203);
        }
        if ((annotationValue = PyTypingTypeProvider.getAnnotationValue(assignment, context)) instanceof PyReferenceExpression) {
            Collection<String> qualifiedNames = PyTypingTypeProvider.resolveToQualifiedNames(annotationValue, context);
            return qualifiedNames.contains(TYPE_ALIAS) || qualifiedNames.contains(TYPE_ALIAS_EXT);
        }
        PyTargetExpression target = PyUtil.as(ArrayUtil.getFirstElement(assignment.getTargets()), PyTargetExpression.class);
        if (target != null && (typeCommentAnnotation = target.getTypeCommentAnnotation()) != null && (commentValue = PyTypingTypeProvider.toExpression(typeCommentAnnotation, assignment)) instanceof PyReferenceExpression) {
            Collection<String> qualifiedNames = PyTypingTypeProvider.resolveToQualifiedNames(commentValue, context);
            return qualifiedNames.contains(TYPE_ALIAS) || qualifiedNames.contains(TYPE_ALIAS_EXT);
        }
        return false;
    }

    @NotNull
    private static String getOpenMode(@NotNull PyFunction function, @NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(204);
        }
        if (call == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(205);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(206);
        }
        Map<PyExpression, PyCallableParameter> arguments = PyCallExpressionHelper.mapArguments((PyCallSiteExpression)call, function, context).getMappedParameters();
        for (Map.Entry<PyExpression, PyCallableParameter> entry : arguments.entrySet()) {
            if (!"mode".equals(entry.getValue().getName())) continue;
            PyExpression argument = entry.getKey();
            if (argument instanceof PyKeywordArgument) {
                argument = ((PyKeywordArgument)argument).getValueExpression();
            }
            if (!(argument instanceof PyStringLiteralExpression)) break;
            String string = ((PyStringLiteralExpression)argument).getStringValue();
            if (string == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(207);
            }
            return string;
        }
        return "r";
    }

    public static boolean isInsideTypeHint(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PsiElement realContext;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(208);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(209);
        }
        if (PsiTreeUtil.getParentOfType(realContext = PyPsiUtils.getRealContext(element), PyAnnotation.class, false, PyStatement.class) != null) {
            return true;
        }
        PsiComment comment = PsiTreeUtil.getParentOfType(realContext, PsiComment.class, false, PyStatement.class);
        if (comment != null && PyTypingTypeProvider.getTypeCommentValue(comment.getText()) != null) {
            return true;
        }
        PyAssignmentStatement assignment = PsiTreeUtil.getParentOfType(realContext, PyAssignmentStatement.class, false, PyStatement.class);
        return assignment != null && PsiTreeUtil.isAncestor(assignment.getAssignedValue(), realContext, false) && PyTypingTypeProvider.isExplicitTypeAlias(assignment, context);
    }

    protected <T> T withCustomContext(@NotNull TypeEvalContext context, @NotNull @NotNull Function<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PyTypingTypeProvider.Context, T> delegate) {
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(210);
        }
        if (delegate == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(211);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T staticWithCustomContext(@NotNull TypeEvalContext context, @NotNull @NotNull Function<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PyTypingTypeProvider.Context, T> delegate) {
        Context customContext;
        boolean firstEntrance;
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(212);
        }
        if (delegate == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(213);
        }
        boolean bl = firstEntrance = (customContext = context.getProcessingContext().get(TYPE_HINT_EVAL_CONTEXT)) == null;
        if (firstEntrance) {
            customContext = new Context(context);
            context.getProcessingContext().put(TYPE_HINT_EVAL_CONTEXT, customContext);
        }
        try {
            T t = delegate.apply(customContext);
            return t;
        }
        finally {
            if (firstEntrance) {
                context.getProcessingContext().put(TYPE_HINT_EVAL_CONTEXT, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 34, 37, 38, 41, 44, 45, 46, 79, 80, 81, 82, 130, 131, 132, 133, 161, 162, 163, 174, 181, 184, 187, 188, 191, 201, 207 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 43: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 62: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 138: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 153: 
            case 156: 
            case 159: 
            case 165: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 176: 
            case 178: 
            case 180: 
            case 183: 
            case 186: 
            case 190: 
            case 200: 
            case 203: 
            case 206: 
            case 209: 
            case 210: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 8: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 115: 
            case 117: 
            case 120: 
            case 195: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 106: 
            case 108: 
            case 193: 
            case 197: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 26: 
            case 125: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: 
            case 32: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 161: 
            case 162: 
            case 163: 
            case 174: 
            case 181: 
            case 184: 
            case 187: 
            case 188: 
            case 191: 
            case 201: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 77: 
            case 110: 
            case 172: 
            case 179: 
            case 182: 
            case 185: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 59: 
            case 83: 
            case 84: 
            case 86: 
            case 122: 
            case 144: 
            case 146: 
            case 150: 
            case 152: 
            case 164: 
            case 166: 
            case 175: 
            case 177: 
            case 192: 
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 60: 
            case 64: 
            case 73: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHint";
                break;
            }
            case 61: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 75: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 98: 
            case 102: 
            case 104: 
            case 112: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 114: 
            case 116: 
            case 119: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpr";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpr";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSequence";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSequence";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 139: 
            case 140: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersExpr";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subscriptionExpression";
                break;
            }
            case 154: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHintExpression";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVarArguments";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundExpression";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveAnchor";
                break;
            }
            case 198: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeLevel";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 211: 
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericSubstitutions";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateGenericSubstitutions";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSuperClassesAsTypeHints";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeParameters";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsClassObjectType";
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "mapTargetsToAnnotations";
                break;
            }
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubRetainedTypeHintContext";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexTypes";
                break;
            }
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolving";
                break;
            }
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingWithAliases";
                break;
            }
            case 187: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingOnStubs";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToQualifiedNames";
                break;
            }
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFunctionCallType";
                break;
            }
            case 207: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findParamTypeHintInFunctionTypeComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGenerator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTypingGenericType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTypingProtocolType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTypingCallableType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "omitFirstParamInTypeComment";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypeAnnotation";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "functionReturningCallSiteAsAType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypedDictTypeForTarget";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTargetExpressionAnnotation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValueRange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getGenericType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSubstitutions";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 161: 
            case 162: 
            case 163: 
            case 174: 
            case 181: 
            case 184: 
            case 187: 
            case 188: 
            case 191: 
            case 201: 
            case 207: {
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "calculateGenericSubstitutions";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSuperClassesAsTypeHints";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeParameters";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isGeneric";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromBitwiseOrOperator";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "typeHasOverloadedBitwiseOr";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isBitwiseOrUnionAvailable";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForResolvedElement";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getSelfType";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromBinaryExpression";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromParenthesizedExpression";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeAliasType";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getAliasedType";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "anchorTypeParameter";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getClassObjectType";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getAsClassObjectType";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getAnyType";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalType";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralStringType";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralType";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedType";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredOrNotRequiredType";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "unwrapTypeModifier";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "typeHintedWithName";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isClassVar";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isNoReturn";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isTypeGuard";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToQualifiedNames";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "toExpression";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getStringBasedType";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralType";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeCommentType";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostTarget";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToAnnotations";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToExpressions";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getCallableType";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "isEllipsis";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isParamSpec";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isConcatenate";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenateType";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenateParametersTypes";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterTypeFromDeclaration";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterTypeFromTypeParameter";
                break;
            }
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterScope";
                break;
            }
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "findSameTypeParameterInDefinition";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getStubRetainedTypeHintContext";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getUnpackedType";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getParamSpecType";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "getGenericTypeBound";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterBoundType";
                break;
            }
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "getIndexTypes";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedType";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getCollection";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "tryResolving";
                break;
            }
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingWithAliases";
                break;
            }
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingOnStubs";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "resolveToQualifiedNames";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "toAsyncIfNeeded";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCoroutineType";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "wrapInGeneratorType";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "wrapInAsyncGeneratorType";
                break;
            }
            case 197: 
            case 198: 
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "getOpenFunctionCallType";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitTypeAlias";
                break;
            }
            case 204: 
            case 205: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "getOpenMode";
                break;
            }
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "isInsideTypeHint";
                break;
            }
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "withCustomContext";
                break;
            }
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "staticWithCustomContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 34, 37, 38, 41, 44, 45, 46, 79, 80, 81, 82, 130, 131, 132, 133, 161, 162, 163, 174, 181, 184, 187, 188, 191, 201, 207 -> new IllegalStateException(string);
        };
    }
}

