/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalConstraints;
import com.jetbrains.python.psi.types.TypeEvalContextCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeEvalContext {
    @NotNull
    private final TypeEvalConstraints myConstraints;
    private List<String> myTrace;
    private String myTraceIndent = "";
    private final ThreadLocal<ProcessingContext> myProcessingContext = ThreadLocal.withInitial(ProcessingContext::new);
    private final Map<PyTypedElement, PyType> myEvaluated = new HashMap<PyTypedElement, PyType>();
    private final Map<PyCallable, PyType> myEvaluatedReturn = new HashMap<PyCallable, PyType>();

    private TypeEvalContext(boolean allowDataFlow, boolean allowStubToAST, boolean allowCallContext, @Nullable PsiFile origin) {
        this.myConstraints = new TypeEvalConstraints(allowDataFlow, allowStubToAST, allowCallContext, origin);
    }

    public String toString() {
        return String.format("TypeEvalContext(%b, %b, %s)", this.myConstraints.myAllowDataFlow, this.myConstraints.myAllowStubToAST, this.myConstraints.myOrigin);
    }

    public boolean allowDataFlow(PsiElement element) {
        return this.myConstraints.myAllowDataFlow || this.inOrigin(element);
    }

    public boolean allowReturnTypes(PsiElement element) {
        return this.myConstraints.myAllowDataFlow || this.inOrigin(element);
    }

    public boolean allowCallContext(@NotNull PsiElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(0);
        }
        return this.myConstraints.myAllowCallContext && this.inOrigin(element);
    }

    @NotNull
    public static TypeEvalContext codeCompletion(@NotNull Project project, @Nullable PsiFile origin) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(1);
        }
        return TypeEvalContext.getContextFromCache(project, new TypeEvalContext(true, true, true, origin));
    }

    public static TypeEvalContext userInitiated(@NotNull Project project, @Nullable PsiFile origin) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(2);
        }
        return TypeEvalContext.getContextFromCache(project, new TypeEvalContext(true, true, false, origin));
    }

    public static TypeEvalContext codeAnalysis(@NotNull Project project, @Nullable PsiFile origin) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(3);
        }
        return TypeEvalContext.getContextFromCache(project, new TypeEvalContext(false, false, false, origin));
    }

    public static TypeEvalContext codeInsightFallback(@Nullable Project project) {
        TypeEvalContext anchor = new TypeEvalContext(false, false, false, null);
        if (project != null) {
            return TypeEvalContext.getContextFromCache(project, anchor);
        }
        return anchor;
    }

    public static TypeEvalContext deepCodeInsight(@NotNull Project project) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(4);
        }
        return TypeEvalContext.getContextFromCache(project, new TypeEvalContext(false, true, false, null));
    }

    @NotNull
    private static TypeEvalContext getContextFromCache(@NotNull Project project, @NotNull TypeEvalContext context) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(5);
        }
        if (context == null) {
            TypeEvalContext.$$$reportNull$$$0(6);
        }
        TypeEvalContext typeEvalContext = project.getService(TypeEvalContextCache.class).getContext(context);
        if (typeEvalContext == null) {
            TypeEvalContext.$$$reportNull$$$0(7);
        }
        return typeEvalContext;
    }

    public TypeEvalContext withTracing() {
        if (this.myTrace == null) {
            this.myTrace = new ArrayList<String>();
        }
        return this;
    }

    public void trace(String message, Object ... args) {
        if (this.myTrace != null) {
            this.myTrace.add(this.myTraceIndent + String.format(message, args));
        }
    }

    public void traceIndent() {
        if (this.myTrace != null) {
            this.myTraceIndent = this.myTraceIndent + "  ";
        }
    }

    public void traceUnindent() {
        if (this.myTrace != null && this.myTraceIndent.length() >= 2) {
            this.myTraceIndent = this.myTraceIndent.substring(0, this.myTraceIndent.length() - 2);
        }
    }

    public String printTrace() {
        return StringUtil.join(this.myTrace, "\n");
    }

    public boolean tracing() {
        return this.myTrace != null;
    }

    @Nullable
    public PyType getType(@NotNull PyTypedElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(8);
        }
        return RecursionManager.doPreventingRecursion(Pair.create(element, this), false, () -> {
            Map<PyTypedElement, PyType> map = this.myEvaluated;
            synchronized (map) {
                if (this.myEvaluated.containsKey(element)) {
                    PyType type = this.myEvaluated.get(element);
                    TypeEvalContext.assertValid(type, element);
                    return type;
                }
            }
            PyType type = element.getType(this, Key.INSTANCE);
            TypeEvalContext.assertValid(type, element);
            Map<PyTypedElement, PyType> map2 = this.myEvaluated;
            synchronized (map2) {
                this.myEvaluated.put(element, type);
            }
            return type;
        });
    }

    @Nullable
    public PyType getReturnType(@NotNull PyCallable callable) {
        if (callable == null) {
            TypeEvalContext.$$$reportNull$$$0(9);
        }
        return RecursionManager.doPreventingRecursion(Pair.create(callable, this), false, () -> {
            Map<PyCallable, PyType> map = this.myEvaluatedReturn;
            synchronized (map) {
                if (this.myEvaluatedReturn.containsKey(callable)) {
                    PyType type = this.myEvaluatedReturn.get(callable);
                    TypeEvalContext.assertValid(type, callable);
                    return type;
                }
            }
            PyType type = callable.getReturnType(this, Key.INSTANCE);
            TypeEvalContext.assertValid(type, callable);
            Map<PyCallable, PyType> map2 = this.myEvaluatedReturn;
            synchronized (map2) {
                this.myEvaluatedReturn.put(callable, type);
            }
            return type;
        });
    }

    @ApiStatus.Experimental
    @NotNull
    public ProcessingContext getProcessingContext() {
        ProcessingContext processingContext = this.myProcessingContext.get();
        if (processingContext == null) {
            TypeEvalContext.$$$reportNull$$$0(10);
        }
        return processingContext;
    }

    private static void assertValid(@Nullable PyType result2, @NotNull PyTypedElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(11);
        }
        if (result2 != null) {
            result2.assertValid(element.toString());
        }
    }

    public boolean maySwitchToAST(@NotNull PsiElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(12);
        }
        return this.myConstraints.myAllowStubToAST || this.inOrigin(element);
    }

    @Nullable
    public PsiFile getOrigin() {
        return this.myConstraints.myOrigin;
    }

    @NotNull
    TypeEvalConstraints getConstraints() {
        TypeEvalConstraints typeEvalConstraints = this.myConstraints;
        if (typeEvalConstraints == null) {
            TypeEvalContext.$$$reportNull$$$0(13);
        }
        return typeEvalConstraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeEvalContext context = (TypeEvalContext)o;
        return this.myConstraints.equals(context.myConstraints);
    }

    public int hashCode() {
        return this.myConstraints.hashCode();
    }

    private boolean inOrigin(@NotNull PsiElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(14);
        }
        return this.myConstraints.myOrigin == element.getContainingFile() || this.myConstraints.myOrigin == TypeEvalContext.getContextFile(element);
    }

    private static PsiFile getContextFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(15);
        }
        if ((file = element.getContainingFile()) == null) {
            return null;
        }
        PsiElement context = file.getContext();
        if (context == null) {
            return file;
        }
        return TypeEvalContext.getContextFile(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/TypeEvalContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/TypeEvalContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFromCache";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingContext";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "allowCallContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "codeCompletion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "userInitiated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "codeAnalysis";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deepCodeInsight";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContextFromCache";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assertValid";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "maySwitchToAST";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inOrigin";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContextFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 13 -> new IllegalStateException(string);
        };
    }

    public static final class Key {
        private static final Key INSTANCE = new Key();

        private Key() {
        }
    }
}

