/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.Parent;
import org.jdom.Verifier;

public final class Comment
extends Content {
    private static final long serialVersionUID = 200L;
    private String text;

    public Comment(String text) {
        super(Content.CType.Comment);
        this.setText(text);
    }

    @Override
    public String getValue() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public Comment setText(String text) {
        String reason = Verifier.checkCommentData((String)text);
        if (reason != null) {
            throw new IllegalDataException(text, "comment", reason);
        }
        this.text = text;
        return this;
    }

    @Override
    public Comment clone() {
        return (Comment)super.clone();
    }

    @Override
    public Comment detach() {
        return (Comment)super.detach();
    }

    @Override
    protected Comment setParent(Parent parent) {
        return (Comment)super.setParent(parent);
    }

    public String toString() {
        return "[Comment: " + this.text + "]";
    }
}

