/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.AbstractOutputProcessor;
import org.jdom.output.Format;
import org.jdom.output.FormatStack;
import org.jdom.output.Walker;
import org.jdom.output.XMLOutputProcessor;
import org.jdom.output.XmlOutputProcessorImpl;
import org.jdom.util.NamespaceStack;

final class XmlOutputProcessorImpl
extends AbstractOutputProcessor
implements XMLOutputProcessor {
    private static final String CDATAPRE = "<![CDATA[";
    private static final String CDATAPOST = "]]>";

    XmlOutputProcessorImpl() {
    }

    @Override
    public void process(Writer out, Format format, Document doc) throws IOException {
        this.printDocument(out, new FormatStack(format), new NamespaceStack(), doc);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, DocType doctype) throws IOException {
        XmlOutputProcessorImpl.printDocType(out, new FormatStack(format), doctype);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, Element element) throws IOException {
        this.printElement(out, new FormatStack(format), new NamespaceStack(), element);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, List<? extends Content> list) throws IOException {
        FormatStack fstack = new FormatStack(format);
        Walker walker = this.buildWalker(fstack, list, true);
        this.printContent(out, fstack, new NamespaceStack(), walker);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, CDATA cdata) throws IOException {
        FormatStack fstack = new FormatStack(format);
        List<CDATA> list = Collections.singletonList(cdata);
        Walker walker = this.buildWalker(fstack, list, true);
        if (walker.hasNext()) {
            this.printContent(out, fstack, new NamespaceStack(), walker);
        }
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, Text text) throws IOException {
        FormatStack fstack = new FormatStack(format);
        List<Text> list = Collections.singletonList(text);
        Walker walker = this.buildWalker(fstack, list, true);
        if (walker.hasNext()) {
            this.printContent(out, fstack, new NamespaceStack(), walker);
        }
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, Comment comment) throws IOException {
        XmlOutputProcessorImpl.printComment(out, comment);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, EntityRef entity) throws IOException {
        XmlOutputProcessorImpl.printEntityRef(out, entity);
        out.flush();
    }

    private static void write(Writer out, String str) throws IOException {
        if (str == null) {
            return;
        }
        out.write(str);
    }

    private static void write(Writer out, char c) throws IOException {
        out.write(c);
    }

    private static void attributeEscapedEntitiesFilter(Writer out, FormatStack fstack, String value) throws IOException {
        if (!fstack.getEscapeOutput()) {
            XmlOutputProcessorImpl.write(out, value);
            return;
        }
        XmlOutputProcessorImpl.write(out, Format.escapeAttribute(fstack.getEscapeStrategy(), value));
    }

    private static void textRaw(Writer out, String str) throws IOException {
        XmlOutputProcessorImpl.write(out, str);
    }

    private static void textRaw(Writer out, char ch) throws IOException {
        XmlOutputProcessorImpl.write(out, ch);
    }

    private static void textEntityRef(Writer out, String name) throws IOException {
        XmlOutputProcessorImpl.textRaw(out, '&');
        XmlOutputProcessorImpl.textRaw(out, name);
        XmlOutputProcessorImpl.textRaw(out, ';');
    }

    private static void textCDATA(Writer out, String text) throws IOException {
        XmlOutputProcessorImpl.textRaw(out, CDATAPRE);
        XmlOutputProcessorImpl.textRaw(out, text);
        XmlOutputProcessorImpl.textRaw(out, CDATAPOST);
    }

    private void printDocument(Writer out, FormatStack fstack, NamespaceStack nstack, Document doc) throws IOException {
        ArrayList<Content> list;
        ArrayList<Content> arrayList = list = doc.hasRootElement() ? doc.getContent() : new ArrayList<Content>(doc.getContentSize());
        if (list.isEmpty()) {
            int sz = doc.getContentSize();
            for (int i = 0; i < sz; ++i) {
                list.add(doc.getContent(i));
            }
        }
        XmlOutputProcessorImpl.printDeclaration(out, fstack);
        Walker walker = this.buildWalker(fstack, list, true);
        if (walker.hasNext()) {
            while (walker.hasNext()) {
                String padding;
                Content c = walker.next();
                if (c == null) {
                    padding = walker.text();
                    if (padding == null || !Verifier.isAllXMLWhitespace((String)padding) || walker.isCDATA()) continue;
                    XmlOutputProcessorImpl.write(out, padding);
                    continue;
                }
                switch (1.$SwitchMap$org$jdom$Content$CType[c.getCType().ordinal()]) {
                    case 1: {
                        XmlOutputProcessorImpl.printDocType(out, fstack, (DocType)c);
                        break;
                    }
                    case 2: {
                        this.printElement(out, fstack, nstack, (Element)c);
                        break;
                    }
                    case 3: {
                        padding = ((Text)c).getText();
                        if (padding == null || !Verifier.isAllXMLWhitespace((String)padding)) break;
                        XmlOutputProcessorImpl.write(out, padding);
                    }
                }
            }
            if (fstack.getLineSeparator() != null) {
                XmlOutputProcessorImpl.write(out, fstack.getLineSeparator());
            }
        }
    }

    private static void printDeclaration(Writer out, FormatStack fstack) throws IOException {
        if (fstack.isOmitDeclaration()) {
            return;
        }
        if (fstack.isOmitEncoding()) {
            XmlOutputProcessorImpl.write(out, "<?xml version=\"1.0\"?>");
        } else {
            XmlOutputProcessorImpl.write(out, "<?xml version=\"1.0\"");
            XmlOutputProcessorImpl.write(out, " encoding=\"");
            XmlOutputProcessorImpl.write(out, fstack.getEncoding());
            XmlOutputProcessorImpl.write(out, "\"?>");
        }
        XmlOutputProcessorImpl.write(out, fstack.getLineSeparator());
    }

    private static void printDocType(Writer out, FormatStack fstack, DocType docType) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        XmlOutputProcessorImpl.write(out, "<!DOCTYPE ");
        XmlOutputProcessorImpl.write(out, docType.getElementName());
        if (publicID != null) {
            XmlOutputProcessorImpl.write(out, " PUBLIC \"");
            XmlOutputProcessorImpl.write(out, publicID);
            XmlOutputProcessorImpl.write(out, "\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                XmlOutputProcessorImpl.write(out, " SYSTEM");
            }
            XmlOutputProcessorImpl.write(out, " \"");
            XmlOutputProcessorImpl.write(out, systemID);
            XmlOutputProcessorImpl.write(out, "\"");
        }
        if (internalSubset != null && !internalSubset.isEmpty()) {
            XmlOutputProcessorImpl.write(out, " [");
            XmlOutputProcessorImpl.write(out, fstack.getLineSeparator());
            XmlOutputProcessorImpl.write(out, docType.getInternalSubset());
            XmlOutputProcessorImpl.write(out, "]");
        }
        XmlOutputProcessorImpl.write(out, ">");
    }

    private static void printComment(Writer out, Comment comment) throws IOException {
        XmlOutputProcessorImpl.write(out, "<!--");
        XmlOutputProcessorImpl.write(out, comment.getText());
        XmlOutputProcessorImpl.write(out, "-->");
    }

    private static void printEntityRef(Writer out, EntityRef entity) throws IOException {
        XmlOutputProcessorImpl.textEntityRef(out, entity.getName());
    }

    private static void printCDATA(Writer out, CDATA cdata) throws IOException {
        XmlOutputProcessorImpl.textCDATA(out, cdata.getText());
    }

    private static void printText(Writer out, FormatStack fstack, Text text) throws IOException {
        if (fstack.getEscapeOutput()) {
            XmlOutputProcessorImpl.textRaw(out, Format.escapeText(fstack.getEscapeStrategy(), fstack.getLineSeparator(), text.getText()));
            return;
        }
        XmlOutputProcessorImpl.textRaw(out, text.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, Element element) throws IOException {
        nstack.push(element);
        try {
            List<Content> content = element.getContent();
            XmlOutputProcessorImpl.write(out, "<");
            XmlOutputProcessorImpl.write(out, element.getQualifiedName());
            for (Namespace ns : nstack.addedForward()) {
                XmlOutputProcessorImpl.printNamespace(out, fstack, ns);
            }
            if (element.hasAttributes()) {
                for (Attribute attribute : element.getAttributes()) {
                    XmlOutputProcessorImpl.printAttribute(out, fstack, attribute);
                }
            }
            if (content.isEmpty()) {
                if (fstack.isExpandEmptyElements()) {
                    XmlOutputProcessorImpl.write(out, "></");
                    XmlOutputProcessorImpl.write(out, element.getQualifiedName());
                    XmlOutputProcessorImpl.write(out, ">");
                } else {
                    XmlOutputProcessorImpl.write(out, " />");
                }
                return;
            }
            fstack.push();
            try {
                String space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
                if ("default".equals(space)) {
                    fstack.setTextMode(fstack.getDefaultMode());
                } else if ("preserve".equals(space)) {
                    fstack.setTextMode(Format.TextMode.PRESERVE);
                }
                Walker walker = this.buildWalker(fstack, content, true);
                if (!walker.hasNext()) {
                    if (fstack.isExpandEmptyElements()) {
                        XmlOutputProcessorImpl.write(out, "></");
                        XmlOutputProcessorImpl.write(out, element.getQualifiedName());
                        XmlOutputProcessorImpl.write(out, ">");
                    } else {
                        XmlOutputProcessorImpl.write(out, " />");
                    }
                    return;
                }
                XmlOutputProcessorImpl.write(out, ">");
                if (!walker.isAllText()) {
                    XmlOutputProcessorImpl.textRaw(out, fstack.getPadBetween());
                }
                this.printContent(out, fstack, nstack, walker);
                if (!walker.isAllText()) {
                    XmlOutputProcessorImpl.textRaw(out, fstack.getPadLast());
                }
                XmlOutputProcessorImpl.write(out, "</");
                XmlOutputProcessorImpl.write(out, element.getQualifiedName());
                XmlOutputProcessorImpl.write(out, ">");
            }
            finally {
                fstack.pop();
            }
        }
        finally {
            nstack.pop();
        }
    }

    private void printContent(Writer out, FormatStack fstack, NamespaceStack nstack, Walker walker) throws IOException {
        while (walker.hasNext()) {
            Content c = walker.next();
            if (c == null) {
                String t = walker.text();
                if (walker.isCDATA()) {
                    XmlOutputProcessorImpl.textCDATA(out, t);
                    continue;
                }
                XmlOutputProcessorImpl.textRaw(out, t);
                continue;
            }
            switch (1.$SwitchMap$org$jdom$Content$CType[c.getCType().ordinal()]) {
                case 4: {
                    XmlOutputProcessorImpl.printCDATA(out, (CDATA)c);
                    break;
                }
                case 5: {
                    XmlOutputProcessorImpl.printComment(out, (Comment)c);
                    break;
                }
                case 1: {
                    XmlOutputProcessorImpl.printDocType(out, fstack, (DocType)c);
                    break;
                }
                case 2: {
                    this.printElement(out, fstack, nstack, (Element)c);
                    break;
                }
                case 6: {
                    XmlOutputProcessorImpl.printEntityRef(out, (EntityRef)c);
                    break;
                }
                case 3: {
                    XmlOutputProcessorImpl.printText(out, fstack, (Text)c);
                }
            }
        }
    }

    private static void printNamespace(Writer out, FormatStack fstack, Namespace ns) throws IOException {
        String prefix = ns.getPrefix();
        String uri = ns.getURI();
        XmlOutputProcessorImpl.write(out, " xmlns");
        if (!prefix.isEmpty()) {
            XmlOutputProcessorImpl.write(out, ":");
            XmlOutputProcessorImpl.write(out, prefix);
        }
        XmlOutputProcessorImpl.write(out, "=\"");
        XmlOutputProcessorImpl.attributeEscapedEntitiesFilter(out, fstack, uri);
        XmlOutputProcessorImpl.write(out, "\"");
    }

    private static void printAttribute(Writer out, FormatStack fstack, Attribute attribute) throws IOException {
        XmlOutputProcessorImpl.write(out, " ");
        XmlOutputProcessorImpl.write(out, attribute.getQualifiedName());
        XmlOutputProcessorImpl.write(out, "=");
        XmlOutputProcessorImpl.write(out, "\"");
        XmlOutputProcessorImpl.attributeEscapedEntitiesFilter(out, fstack, attribute.getValue());
        XmlOutputProcessorImpl.write(out, "\"");
    }
}

