/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;

public class IterativeTransformation
extends AbstractCoordinateOperation
implements CoordinateOperation {
    CoordinateOperation op;
    int[] realValueIndex;
    int[] calculatedValueIndex;
    double[] tolerance;

    public IterativeTransformation(CoordinateOperation op, int[] realValueIndex, int[] calculatedValueIndex, double[] tol) throws Exception {
        super(new Identifier(IterativeTransformation.class));
        this.op = op;
        if (calculatedValueIndex.length != realValueIndex.length) {
            throw new Exception("The two arrays in argument must have the same length.");
        }
        this.calculatedValueIndex = calculatedValueIndex;
        this.realValueIndex = realValueIndex;
        this.tolerance = tol;
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        int i;
        boolean iter = false;
        for (i = 0; i < this.realValueIndex.length; ++i) {
            iter = iter || Math.abs(coord[this.realValueIndex[i]] - coord[this.calculatedValueIndex[i]]) > this.tolerance[i];
        }
        while (iter) {
            coord = this.op.transform(coord);
            iter = false;
            for (i = 0; i < this.realValueIndex.length; ++i) {
                iter = iter || Math.abs(coord[this.realValueIndex[i]] - coord[this.calculatedValueIndex[i]]) > this.tolerance[i];
            }
        }
        return coord;
    }
}

