/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeHeaderProvider
implements RuntimeDelegate.HeaderDelegate<MediaType> {
    public MediaType fromString(String mType) {
        if (mType == null) {
            throw new IllegalArgumentException("Media type value can not be null");
        }
        if (mType.equals("*") || mType.startsWith("*;")) {
            return new MediaType("*", "*");
        }
        int i = mType.indexOf(47);
        if (i == -1) {
            throw new IllegalArgumentException("Media type separator is missing");
        }
        int paramsStart = mType.indexOf(59, i + 1);
        int end = paramsStart == -1 ? mType.length() : paramsStart;
        String type = mType.substring(0, i);
        String subtype = mType.substring(i + 1, end);
        Map<String, String> parameters = Collections.emptyMap();
        if (paramsStart != -1) {
            parameters = new LinkedHashMap();
            StringTokenizer st = new StringTokenizer(mType.substring(paramsStart + 1), ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int equalSign = token.indexOf(61);
                if (equalSign == -1) {
                    throw new IllegalArgumentException("Wrong media type  parameter, seperator is missing");
                }
                parameters.put(token.substring(0, equalSign).trim().toLowerCase(), token.substring(equalSign + 1).trim());
            }
        }
        return new MediaType(type.trim().toLowerCase(), subtype.trim().toLowerCase(), parameters);
    }

    public String toString(MediaType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getType()).append('/').append(type.getSubtype());
        Map params = type.getParameters();
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                sb.append(';').append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
        }
        return sb.toString();
    }
}

