/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefn;
import org.apache.cxf.tools.corba.common.idltypes.IdlPrimitive;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlString;
import org.apache.cxf.tools.corba.common.idltypes.IdlWString;

public final class IdlRoot
extends IdlScopeBase {
    private Map<Object, Object> primitiveTypes = new HashMap<Object, Object>();
    private List<Object> includeList = new ArrayList<Object>();

    private IdlRoot() {
        super(null, "");
        for (short i = 1; i <= 15; i = (short)(i + 1)) {
            IdlPrimitive prim = IdlPrimitive.create(this, i);
            this.primitiveTypes.put(prim.wsdlName(), prim);
        }
        this.primitiveTypes.put("string", IdlString.create());
        this.primitiveTypes.put("wstring", IdlWString.create());
    }

    public static IdlRoot create() {
        return new IdlRoot();
    }

    public IdlDefn lookup(String nm) {
        return this.lookup(nm, false);
    }

    public IdlDefn lookup(String nm, boolean undefined) {
        IdlDefn result = null;
        result = !undefined && this.primitiveTypes.containsKey(nm) ? (IdlDefn)this.primitiveTypes.get(nm) : super.lookup(nm, undefined);
        return result;
    }

    public void addInclude(String includefile) {
        if (!this.includeList.contains(includefile)) {
            this.includeList.add(includefile);
        }
    }

    public void write(PrintWriter pw) {
        for (String string : this.includeList) {
            pw.println("#include " + string);
        }
        if (this.includeList.size() > 0) {
            pw.println();
        }
        super.writeFwd(pw);
        super.write(pw);
    }
}

