/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BufferedTokenStream;

public class RemoveDuplicatesTokenFilter
extends BufferedTokenStream {
    public RemoveDuplicatesTokenFilter(TokenStream input) {
        super(input);
    }

    protected Token process(Token t) throws IOException {
        Token tok = this.read();
        while (tok != null && tok.getPositionIncrement() == 0) {
            if (null != t) {
                this.write(t);
                t = null;
            }
            boolean dup = false;
            for (Token outTok : this.output()) {
                if (!outTok.termText().equals(tok.termText())) continue;
                dup = true;
                break;
            }
            if (!dup) {
                this.write(tok);
            }
            tok = this.read();
        }
        if (tok != null) {
            this.pushBack(tok);
        }
        return t;
    }
}

