/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Token;

public class SynonymMap {
    Map submap;
    Token[] synonyms;
    int flags;
    static final int INCLUDE_ORIG = 1;

    public boolean includeOrig() {
        return (this.flags & 1) != 0;
    }

    public void add(List singleMatch, List replacement, boolean includeOrig, boolean mergeExisting) {
        SynonymMap currMap = this;
        for (String str : singleMatch) {
            SynonymMap map;
            if (currMap.submap == null) {
                currMap.submap = new HashMap(1);
            }
            if ((map = (SynonymMap)currMap.submap.get(str)) == null) {
                map = new SynonymMap();
                currMap.submap.put(str, map);
            }
            currMap = map;
        }
        if (currMap.synonyms != null && !mergeExisting) {
            throw new RuntimeException("SynonymFilter: there is already a mapping for " + singleMatch);
        }
        List superset = currMap.synonyms == null ? replacement : SynonymMap.mergeTokens(Arrays.asList(currMap.synonyms), replacement);
        currMap.synonyms = superset.toArray(new Token[superset.size()]);
        if (includeOrig) {
            currMap.flags |= 1;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<");
        if (this.synonyms != null) {
            sb.append("[");
            for (int i = 0; i < this.synonyms.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append((Object)this.synonyms[i]);
            }
            if ((this.flags & 1) != 0) {
                sb.append(",ORIG");
            }
            sb.append("],");
        }
        sb.append(this.submap);
        sb.append(">");
        return sb.toString();
    }

    public static List makeTokens(List strings) {
        ArrayList<Token> ret = new ArrayList<Token>(strings.size());
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            Token newTok = new Token((String)iter.next(), 0, 0, "SYNONYM");
            ret.add(newTok);
        }
        return ret;
    }

    public static List mergeTokens(List lst1, List lst2) {
        int pos2;
        ArrayList<Token> result = new ArrayList<Token>();
        if (lst1 == null || lst2 == null) {
            if (lst2 != null) {
                result.addAll(lst2);
            }
            if (lst1 != null) {
                result.addAll(lst1);
            }
            return result;
        }
        int pos = 0;
        Iterator iter1 = lst1.iterator();
        Iterator iter2 = lst2.iterator();
        Token tok1 = iter1.hasNext() ? (Token)iter1.next() : null;
        Token tok2 = iter2.hasNext() ? (Token)iter2.next() : null;
        int pos1 = tok1 != null ? tok1.getPositionIncrement() : 0;
        int n = pos2 = tok2 != null ? tok2.getPositionIncrement() : 0;
        while (tok1 != null || tok2 != null) {
            Token tok;
            while (tok1 != null && (pos1 <= pos2 || tok2 == null)) {
                tok = new Token(tok1.termText(), tok1.startOffset(), tok1.endOffset(), tok1.type());
                tok.setPositionIncrement(pos1 - pos);
                result.add(tok);
                pos = pos1;
                tok1 = iter1.hasNext() ? (Token)iter1.next() : null;
                pos1 += tok1 != null ? tok1.getPositionIncrement() : 0;
            }
            while (tok2 != null && (pos2 <= pos1 || tok1 == null)) {
                tok = new Token(tok2.termText(), tok2.startOffset(), tok2.endOffset(), tok2.type());
                tok.setPositionIncrement(pos2 - pos);
                result.add(tok);
                pos = pos2;
                tok2 = iter2.hasNext() ? (Token)iter2.next() : null;
                pos2 += tok2 != null ? tok2.getPositionIncrement() : 0;
            }
        }
        return result;
    }
}

