/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.solr.core.Config;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrException;
import org.apache.solr.core.SolrInfoRegistry;
import org.apache.solr.request.JSONResponseWriter;
import org.apache.solr.request.PythonResponseWriter;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.RubyResponseWriter;
import org.apache.solr.request.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.XMLResponseWriter;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.DirectUpdateHandler;
import org.apache.solr.update.SolrIndexConfig;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.NamedList;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.SimpleOrderedMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SolrCore {
    public static final String version = "1.0";
    public static Logger log = Logger.getLogger(SolrCore.class.getName());
    private final IndexSchema schema;
    private final String dataDir;
    private final String index_path;
    private final UpdateHandler updateHandler;
    private static final long startTime = System.currentTimeMillis();
    private final RequestHandlers reqHandlers = new RequestHandlers();
    public static SolrIndexConfig mainIndexConfig = new SolrIndexConfig("mainIndex");
    List<SolrEventListener> firstSearcherListeners;
    List<SolrEventListener> newSearcherListeners;
    private static SolrCore core;
    private RefCounted<SolrIndexSearcher> _searcher;
    final ExecutorService searcherExecutor = Executors.newSingleThreadExecutor();
    private int onDeckSearchers;
    private Object searcherLock = new Object();
    private final int maxWarmingSearchers;
    private QueryResponseWriter defaultResponseWriter;
    private final Map<String, QueryResponseWriter> responseWriters = new HashMap<String, QueryResponseWriter>();

    public long getStartTime() {
        return startTime;
    }

    public static List<SolrEventListener> parseListener(String path) {
        ArrayList<SolrEventListener> lst = new ArrayList<SolrEventListener>();
        log.info("Searching for listeners: " + path);
        NodeList nodes = (NodeList)SolrConfig.config.evaluate(path, XPathConstants.NODESET);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String className = DOMUtil.getAttr(node, "class");
                SolrEventListener listener = (SolrEventListener)Config.newInstance(className, new String[0]);
                listener.init(DOMUtil.childNodesToNamedList(node));
                lst.add(listener);
                log.info("added SolrEventListener: " + listener);
            }
        }
        return lst;
    }

    private void parseListeners() {
        this.firstSearcherListeners = SolrCore.parseListener("//listener[@event=\"firstSearcher\"]");
        this.newSearcherListeners = SolrCore.parseListener("//listener[@event=\"newSearcher\"]");
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getIndexDir() {
        return this.index_path;
    }

    public SolrIndexSearcher newSearcher(String name) throws IOException {
        return new SolrIndexSearcher(this.schema, name, this.getIndexDir(), false);
    }

    void initIndex() {
        try {
            FSDirectory dir;
            File dirFile = new File(this.getIndexDir());
            boolean indexExists = dirFile.canRead();
            boolean removeLocks = SolrConfig.config.getBool("mainIndex/unlockOnStartup", false);
            if (removeLocks && IndexReader.isLocked((Directory)(dir = FSDirectory.getDirectory((File)dirFile, (!indexExists ? 1 : 0) != 0)))) {
                log.warning("WARNING: Solr index directory '" + this.getIndexDir() + "' is locked.  Unlocking...");
                IndexReader.unlock((Directory)dir);
            }
            if (!indexExists) {
                log.warning("Solr index directory '" + dirFile + "' doesn't exist." + " Creating new index...");
                SolrIndexWriter writer = new SolrIndexWriter("SolrCore.initIndex", this.getIndexDir(), true, this.schema, mainIndexConfig);
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private UpdateHandler createUpdateHandler(String className) {
        try {
            Class handlerClass = Config.findClass(className, new String[0]);
            Constructor cons = handlerClass.getConstructor(SolrCore.class);
            return (UpdateHandler)cons.newInstance(this);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating Update Handler " + className, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrCore getSolrCore() {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            if (core == null) {
                core = new SolrCore(null, null);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return core;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore(String dataDir, IndexSchema schema) {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            core = this;
            if (dataDir == null) {
                dataDir = SolrConfig.config.get("dataDir", Config.getInstanceDir() + "data");
            }
            log.info("Opening new SolrCore at " + Config.getInstanceDir() + ", dataDir=" + dataDir);
            if (schema == null) {
                schema = new IndexSchema("schema.xml");
            }
            this.schema = schema;
            this.dataDir = dataDir;
            this.index_path = dataDir + "/" + "index";
            this.maxWarmingSearchers = SolrConfig.config.getInt("query/maxWarmingSearchers", Integer.MAX_VALUE);
            this.parseListeners();
            this.initIndex();
            this.initWriters();
            this.reqHandlers.initHandlersFromConfig(SolrConfig.config);
            try {
                this.getSearcher(false, false, null);
                this.updateHandler = this.createUpdateHandler(SolrConfig.config.get("updateHandler/@class", DirectUpdateHandler.class.getName()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    public void close() {
        log.info("CLOSING SolrCore!");
        try {
            this.closeSearcher();
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
        try {
            this.searcherExecutor.shutdown();
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
        try {
            this.updateHandler.close();
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
    }

    protected void finalize() {
        this.close();
    }

    public SolrRequestHandler getRequestHandler(String handlerName) {
        return this.reqHandlers.get(handlerName);
    }

    public Map<String, SolrRequestHandler> getRequestHandlers() {
        return this.reqHandlers.getRequestHandlers();
    }

    public SolrRequestHandler registerRequestHandler(String handlerName, SolrRequestHandler handler) {
        return this.reqHandlers.register(handlerName, handler);
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public RefCounted<SolrIndexSearcher> getSearcher() {
        try {
            return this.getSearcher(false, true, null);
        }
        catch (IOException e) {
            SolrException.log(log, null, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher) throws IOException {
        SolrIndexSearcher tmp;
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            if (this.onDeckSearchers > 0 && !forceNew && this._searcher == null) {
                try {
                    this.searcherLock.wait();
                }
                catch (InterruptedException e) {
                    log.info(SolrException.toStr(e));
                }
            }
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            ++this.onDeckSearchers;
            if (this.onDeckSearchers < 1) {
                log.severe("ERROR!!! onDeckSearchers is " + this.onDeckSearchers);
                this.onDeckSearchers = 1;
            } else {
                if (this.onDeckSearchers > this.maxWarmingSearchers) {
                    --this.onDeckSearchers;
                    String msg = "Error opening new searcher. exceeded limit of maxWarmingSearchers=" + this.maxWarmingSearchers + ", try again later.";
                    log.warning(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, msg, true);
                }
                if (this.onDeckSearchers > 1) {
                    log.info("PERFORMANCE WARNING: Overlapping onDeckSearchers=" + this.onDeckSearchers);
                }
            }
        }
        try {
            tmp = new SolrIndexSearcher(this.schema, "main", this.index_path, true);
        }
        catch (Throwable th) {
            Object object2 = this.searcherLock;
            synchronized (object2) {
                --this.onDeckSearchers;
                this.searcherLock.notify();
            }
            throw new RuntimeException(th);
        }
        final SolrIndexSearcher newSearcher = tmp;
        RefCounted<SolrIndexSearcher> currSearcherHolder = null;
        final RefCounted<SolrIndexSearcher> newSearchHolder = this.newHolder(newSearcher);
        if (returnSearcher) {
            newSearchHolder.incref();
        }
        final boolean[] decrementOnDeckCount = new boolean[]{true};
        try {
            boolean alreadyRegistered = false;
            Object object3 = this.searcherLock;
            synchronized (object3) {
                if (this._searcher == null) {
                    if (SolrConfig.config.getBool("query/useColdSearcher", false)) {
                        this.registerSearcher(newSearchHolder);
                        decrementOnDeckCount[0] = false;
                        alreadyRegistered = true;
                    }
                } else {
                    currSearcherHolder = this._searcher;
                    currSearcherHolder.incref();
                }
            }
            final SolrIndexSearcher currSearcher = currSearcherHolder == null ? null : currSearcherHolder.get();
            Future future = null;
            if (currSearcher != null) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            newSearcher.warm(currSearcher);
                        }
                        catch (Throwable e) {
                            SolrException.logOnce(log, null, e);
                        }
                        return null;
                    }
                });
            }
            if (currSearcher == null && this.firstSearcherListeners.size() > 0) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            for (SolrEventListener listener : SolrCore.this.firstSearcherListeners) {
                                listener.newSearcher(newSearcher, null);
                            }
                        }
                        catch (Throwable e) {
                            SolrException.logOnce(log, null, e);
                        }
                        return null;
                    }
                });
            }
            if (currSearcher != null && this.newSearcherListeners.size() > 0) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            for (SolrEventListener listener : SolrCore.this.newSearcherListeners) {
                                listener.newSearcher(newSearcher, null);
                            }
                        }
                        catch (Throwable e) {
                            SolrException.logOnce(log, null, e);
                        }
                        return null;
                    }
                });
            }
            final RefCounted<SolrIndexSearcher> currSearcherHolderF = currSearcherHolder;
            if (!alreadyRegistered) {
                future = this.searcherExecutor.submit(new Callable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() throws Exception {
                        try {
                            decrementOnDeckCount[0] = false;
                            SolrCore.this.registerSearcher(newSearchHolder);
                        }
                        catch (Throwable e) {
                            SolrException.logOnce(log, null, e);
                        }
                        finally {
                            if (currSearcherHolderF != null) {
                                currSearcherHolderF.decref();
                            }
                        }
                        return null;
                    }
                });
            }
            if (waitSearcher != null) {
                waitSearcher[0] = future;
            }
            return returnSearcher ? newSearchHolder : null;
        }
        catch (Exception e) {
            SolrException.logOnce(log, null, e);
            if (currSearcherHolder != null) {
                currSearcherHolder.decref();
            }
            Object object4 = this.searcherLock;
            synchronized (object4) {
                if (decrementOnDeckCount[0]) {
                    --this.onDeckSearchers;
                }
                if (this.onDeckSearchers < 0) {
                    log.severe("ERROR!!! onDeckSearchers after decrement=" + this.onDeckSearchers);
                    this.onDeckSearchers = 0;
                }
                this.searcherLock.notify();
            }
            return returnSearcher ? newSearchHolder : null;
        }
    }

    private RefCounted<SolrIndexSearcher> newHolder(SolrIndexSearcher newSearcher) {
        RefCounted<SolrIndexSearcher> holder = new RefCounted<SolrIndexSearcher>(newSearcher){

            @Override
            public void close() {
                try {
                    ((SolrIndexSearcher)this.resource).close();
                }
                catch (IOException e) {
                    log.severe("Error closing searcher:" + SolrException.toStr(e));
                }
            }
        };
        holder.incref();
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSearcher(RefCounted<SolrIndexSearcher> newSearcherHolder) throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            try {
                if (this._searcher != null) {
                    this._searcher.decref();
                    this._searcher = null;
                }
                this._searcher = newSearcherHolder;
                SolrIndexSearcher newSearcher = newSearcherHolder.get();
                newSearcher.register();
                log.info("Registered new searcher " + newSearcher);
            }
            catch (Throwable e) {
                SolrCore.log(e);
            }
            finally {
                --this.onDeckSearchers;
                this.searcherLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSearcher() {
        log.info("Closing main searcher on request.");
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null) {
                this._searcher.decref();
                this._searcher = null;
                SolrInfoRegistry.getRegistry().remove("currentSearcher");
            }
        }
    }

    public void execute(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        SimpleOrderedMap<Object> responseHeader = new SimpleOrderedMap<Object>();
        rsp.add("responseHeader", responseHeader);
        handler.handleRequest(req, rsp);
        this.setResponseHeaderValues(handler, responseHeader, req, rsp);
        log.info(req.getContext().get("path") + " " + req.getParamString() + " 0 " + (int)(rsp.getEndTime() - req.getStartTime()));
    }

    @Deprecated
    public void execute(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrRequestHandler handler = this.getRequestHandler(req.getQueryType());
        if (handler == null) {
            log.warning("Unknown Request Handler '" + req.getQueryType() + "' :" + req);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Request Handler '" + req.getQueryType() + "'", true);
        }
        this.execute(handler, req, rsp);
    }

    protected void setResponseHeaderValues(SolrRequestHandler handler, NamedList<Object> responseHeader, SolrQueryRequest req, SolrQueryResponse rsp) {
        String ep;
        int qtime = (int)(rsp.getEndTime() - req.getStartTime());
        responseHeader.add("status", rsp.getException() == null ? 0 : 500);
        responseHeader.add("QTime", qtime);
        SolrParams params = req.getParams();
        if (params.getBool("echoHandler", false)) {
            responseHeader.add("handler", handler.getName());
        }
        if ((ep = params.get("echoParams", null)) != null) {
            SolrParams.EchoParamStyle echoParams = SolrParams.EchoParamStyle.get((String)ep);
            if (echoParams == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value '" + ep + "' for " + "echoParams" + " parameter, use '" + SolrParams.EchoParamStyle.EXPLICIT + "' or '" + SolrParams.EchoParamStyle.ALL + "'");
            }
            if (echoParams == SolrParams.EchoParamStyle.EXPLICIT) {
                responseHeader.add("params", req.getOriginalParams().toNamedList());
            } else if (echoParams == SolrParams.EchoParamStyle.ALL) {
                responseHeader.add("params", req.getParams().toNamedList());
            }
        }
    }

    public static final void log(Throwable e) {
        SolrException.logOnce(log, null, e);
    }

    private void initWriters() {
        String xpath = "queryResponseWriter";
        NodeList nodes = (NodeList)SolrConfig.config.evaluate(xpath, XPathConstants.NODESET);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Element elm = (Element)nodes.item(i);
            try {
                String name = DOMUtil.getAttr(elm, "name", xpath + " config");
                String className = DOMUtil.getAttr(elm, "class", xpath + " config");
                log.info("adding queryResponseWriter " + name + "=" + className);
                QueryResponseWriter writer = (QueryResponseWriter)Config.newInstance(className, new String[0]);
                writer.init(DOMUtil.childNodesToNamedList(elm));
                this.responseWriters.put(name, writer);
                continue;
            }
            catch (Exception ex) {
                SolrConfig.severeErrors.add(ex);
                SolrException.logOnce(log, null, ex);
            }
        }
        if (this.responseWriters.containsKey("standard")) {
            this.defaultResponseWriter = this.responseWriters.get("standard");
        }
        if (this.defaultResponseWriter == null) {
            this.defaultResponseWriter = new XMLResponseWriter();
        }
        if (this.responseWriters.get("json") == null) {
            this.responseWriters.put("json", (QueryResponseWriter)new JSONResponseWriter());
        }
        if (this.responseWriters.get("python") == null) {
            this.responseWriters.put("python", (QueryResponseWriter)new PythonResponseWriter());
        }
        if (this.responseWriters.get("ruby") == null) {
            this.responseWriters.put("ruby", (QueryResponseWriter)new RubyResponseWriter());
        }
    }

    public final QueryResponseWriter getQueryResponseWriter(String writerName) {
        QueryResponseWriter writer;
        if (writerName != null && (writer = this.responseWriters.get(writerName)) != null) {
            return writer;
        }
        return this.defaultResponseWriter;
    }

    public final QueryResponseWriter getQueryResponseWriter(SolrQueryRequest request) {
        return this.getQueryResponseWriter(request.getParam("wt"));
    }

    static {
        BooleanQuery.setMaxClauseCount(SolrConfig.config.getInt("query/maxBooleanClauses", BooleanQuery.getMaxClauseCount()));
        if (SolrCore.mainIndexConfig.writeLockTimeout != -1) {
            IndexWriter.setDefaultWriteLockTimeout(SolrCore.mainIndexConfig.writeLockTimeout);
        }
    }
}

