/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import org.hibernate.ejb.packaging.AbstractJarVisitor;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.JarVisitorFactory;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.util.osgi.BCMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleVisitor
extends AbstractJarVisitor {
    private final Logger log = LoggerFactory.getLogger(BundleVisitor.class);
    private String entry;

    public BundleVisitor(URL url, Filter[] filters, String entry) {
        super(url, filters);
        this.entry = entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessElements() throws IOException {
        BCMapper mapper = BCMapper.getInstance();
        BundleContext bc = (BundleContext)mapper.get(this.jarUrl);
        Enumeration entries = bc.getBundle().findEntries("", "*", true);
        while (entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
            InputStream is = null;
            try {
                is = urlConnection.getInputStream();
                byte[] entryBytes = JarVisitorFactory.getBytesFromInputStream(is);
                String subname = url.getPath();
                if (subname.startsWith("/")) {
                    subname = subname.substring(1);
                }
                this.addElement(subname, new ByteArrayInputStream(entryBytes), new ByteArrayInputStream(entryBytes));
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }
}

