/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.AbstractTableSpecification;
import org.hibernate.metamodel.relational.CheckConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.ObjectName;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.metamodel.relational.UniqueKey;

public class Table
extends AbstractTableSpecification
implements Exportable {
    private final Schema database;
    private final Identifier tableName;
    private final ObjectName objectName;
    private final String qualifiedName;
    private final LinkedHashMap<String, Index> indexes = new LinkedHashMap();
    private final LinkedHashMap<String, UniqueKey> uniqueKeys = new LinkedHashMap();
    private final List<CheckConstraint> checkConstraints = new ArrayList<CheckConstraint>();
    private final List<String> comments = new ArrayList<String>();

    public Table(Schema database, String tableName) {
        this(database, Identifier.toIdentifier(tableName));
    }

    public Table(Schema database, Identifier tableName) {
        this.database = database;
        this.tableName = tableName;
        this.objectName = new ObjectName(database.getName().getSchema(), database.getName().getCatalog(), tableName);
        this.qualifiedName = this.objectName.toText();
    }

    @Override
    public Schema getSchema() {
        return this.database;
    }

    public Identifier getTableName() {
        return this.tableName;
    }

    @Override
    public String getLoggableValueQualifier() {
        return this.qualifiedName;
    }

    @Override
    public String getExportIdentifier() {
        return this.qualifiedName;
    }

    @Override
    public String toLoggableString() {
        return this.qualifiedName;
    }

    @Override
    public Iterable<Index> getIndexes() {
        return this.indexes.values();
    }

    @Override
    public Index getOrCreateIndex(String name) {
        if (this.indexes.containsKey(name)) {
            return this.indexes.get(name);
        }
        Index index = new Index(this, name);
        this.indexes.put(name, index);
        return index;
    }

    @Override
    public Iterable<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys.values();
    }

    @Override
    public UniqueKey getOrCreateUniqueKey(String name) {
        if (this.uniqueKeys.containsKey(name)) {
            return this.uniqueKeys.get(name);
        }
        UniqueKey uniqueKey = new UniqueKey(this, name);
        this.uniqueKeys.put(name, uniqueKey);
        return uniqueKey;
    }

    @Override
    public Iterable<CheckConstraint> getCheckConstraints() {
        return this.checkConstraints;
    }

    @Override
    public void addCheckConstraint(String checkCondition) {
        this.checkConstraints.add(new CheckConstraint(this, "", checkCondition));
    }

    @Override
    public Iterable<String> getComments() {
        return this.comments;
    }

    @Override
    public void addComment(String comment) {
        this.comments.add(comment);
    }

    @Override
    public String getQualifiedName(Dialect dialect) {
        return this.objectName.toText(dialect);
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) {
        boolean hasPrimaryKey = this.getPrimaryKey().getColumns().iterator().hasNext();
        StringBuilder buf = new StringBuilder(hasPrimaryKey ? dialect.getCreateTableString() : dialect.getCreateMultisetTableString()).append(' ').append(this.objectName.toText(dialect)).append(" (");
        boolean isPrimaryKeyIdentity = false;
        String pkColName = null;
        if (hasPrimaryKey && isPrimaryKeyIdentity) {
            Column pkColumn = this.getPrimaryKey().getColumns().iterator().next();
            pkColName = pkColumn.getColumnName().encloseInQuotesIfQuoted(dialect);
        }
        boolean isFirst = true;
        for (SimpleValue simpleValue : this.values()) {
            String columnComment;
            boolean useUniqueConstraint;
            if (!Column.class.isInstance(simpleValue)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            Column col = (Column)simpleValue;
            String colName = col.getColumnName().encloseInQuotesIfQuoted(dialect);
            buf.append(colName).append(' ');
            if (isPrimaryKeyIdentity && colName.equals(pkColName)) {
                if (dialect.hasDataTypeInIdentityColumn()) {
                    buf.append(Table.getTypeString(col, dialect));
                }
                buf.append(' ').append(dialect.getIdentityColumnString(col.getDatatype().getTypeCode()));
            } else {
                buf.append(Table.getTypeString(col, dialect));
                String defaultValue = col.getDefaultValue();
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (col.isNullable()) {
                    buf.append(dialect.getNullColumnString());
                } else {
                    buf.append(" not null");
                }
            }
            boolean bl = useUniqueConstraint = col.isUnique() && (col.isNullable() || dialect.supportsNotNullUnique());
            if (useUniqueConstraint) {
                if (dialect.supportsUnique()) {
                    buf.append(" unique");
                } else {
                    UniqueKey uk = this.getOrCreateUniqueKey(col.getColumnName().encloseInQuotesIfQuoted(dialect) + '_');
                    uk.addColumn(col);
                }
            }
            if (col.getCheckCondition() != null && dialect.supportsColumnCheck()) {
                buf.append(" check (").append(col.getCheckCondition()).append(")");
            }
            if ((columnComment = col.getComment()) == null) continue;
            buf.append(dialect.getColumnComment(columnComment));
        }
        if (hasPrimaryKey) {
            buf.append(", ").append(this.getPrimaryKey().sqlConstraintStringInCreateTable(dialect));
        }
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            for (UniqueKey uk : this.uniqueKeys.values()) {
                String constraint = uk.sqlConstraintStringInCreateTable(dialect);
                if (constraint == null) continue;
                buf.append(", ").append(constraint);
            }
        }
        if (dialect.supportsTableCheck()) {
            for (CheckConstraint checkConstraint : this.checkConstraints) {
                buf.append(", check (").append(checkConstraint).append(')');
            }
        }
        buf.append(')');
        buf.append(dialect.getTableTypeString());
        String[] sqlStrings = new String[this.comments.size() + 1];
        sqlStrings[0] = buf.toString();
        for (int i = 0; i < this.comments.size(); ++i) {
            sqlStrings[i + 1] = dialect.getTableComment(this.comments.get(i));
        }
        return sqlStrings;
    }

    private static String getTypeString(Column col, Dialect dialect) {
        String typeString = null;
        if (col.getSqlType() != null) {
            typeString = col.getSqlType();
        } else {
            Size size = col.getSize() == null ? new Size() : col.getSize();
            typeString = dialect.getTypeName(col.getDatatype().getTypeCode(), size.getLength(), size.getPrecision(), size.getScale());
        }
        return typeString;
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) {
        return new String[]{dialect.getDropTableString(this.getQualifiedName(dialect))};
    }

    public String toString() {
        return "Table{name=" + this.qualifiedName + '}';
    }
}

