/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.StreamingOperationSelectionDelegate;
import org.hibernate.search.backend.impl.WorkVisitor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;

public class StreamingSelectionVisitor
implements WorkVisitor<StreamingOperationSelectionDelegate> {
    private final AddSelectionDelegate addDelegate = new AddSelectionDelegate();
    private final DeleteSelectionDelegate deleteDelegate = new DeleteSelectionDelegate();
    private final OptimizeSelectionDelegate optimizeDelegate = new OptimizeSelectionDelegate();
    private final PurgeAllSelectionDelegate purgeDelegate = new PurgeAllSelectionDelegate();
    public static final StreamingSelectionVisitor INSTANCE = new StreamingSelectionVisitor();

    private StreamingSelectionVisitor() {
    }

    @Override
    public StreamingOperationSelectionDelegate getDelegate(AddLuceneWork addLuceneWork) {
        return this.addDelegate;
    }

    @Override
    public StreamingOperationSelectionDelegate getDelegate(UpdateLuceneWork addLuceneWork) {
        return this.addDelegate;
    }

    @Override
    public StreamingOperationSelectionDelegate getDelegate(DeleteLuceneWork deleteLuceneWork) {
        return this.deleteDelegate;
    }

    @Override
    public StreamingOperationSelectionDelegate getDelegate(OptimizeLuceneWork optimizeLuceneWork) {
        return this.optimizeDelegate;
    }

    @Override
    public StreamingOperationSelectionDelegate getDelegate(PurgeAllLuceneWork purgeAllLuceneWork) {
        return this.purgeDelegate;
    }

    private static class PurgeAllSelectionDelegate
    implements StreamingOperationSelectionDelegate {
        private PurgeAllSelectionDelegate() {
        }

        @Override
        public final void performStreamOperation(LuceneWork work, IndexShardingStrategy shardingStrategy, IndexingMonitor monitor, boolean forceAsync) {
            IndexManager[] indexManagers;
            for (IndexManager indexManager : indexManagers = shardingStrategy.getIndexManagersForDeletion(work.getEntityClass(), work.getId(), work.getIdInString())) {
                indexManager.performStreamOperation(work, monitor, forceAsync);
            }
        }
    }

    private static class OptimizeSelectionDelegate
    implements StreamingOperationSelectionDelegate {
        private OptimizeSelectionDelegate() {
        }

        @Override
        public final void performStreamOperation(LuceneWork work, IndexShardingStrategy shardingStrategy, IndexingMonitor monitor, boolean forceAsync) {
            IndexManager[] indexManagers;
            for (IndexManager indexManager : indexManagers = shardingStrategy.getIndexManagersForAllShards()) {
                indexManager.performStreamOperation(work, monitor, forceAsync);
            }
        }
    }

    private static class DeleteSelectionDelegate
    implements StreamingOperationSelectionDelegate {
        private DeleteSelectionDelegate() {
        }

        @Override
        public final void performStreamOperation(LuceneWork work, IndexShardingStrategy shardingStrategy, IndexingMonitor monitor, boolean forceAsync) {
            IndexManager[] indexManagers;
            for (IndexManager indexManager : indexManagers = shardingStrategy.getIndexManagersForDeletion(work.getEntityClass(), work.getId(), work.getIdInString())) {
                indexManager.performStreamOperation(work, monitor, forceAsync);
            }
        }
    }

    private static class AddSelectionDelegate
    implements StreamingOperationSelectionDelegate {
        private AddSelectionDelegate() {
        }

        @Override
        public final void performStreamOperation(LuceneWork work, IndexShardingStrategy shardingStrategy, IndexingMonitor monitor, boolean forceAsync) {
            IndexManager indexManager = shardingStrategy.getIndexManagerForAddition(work.getEntityClass(), work.getId(), work.getIdInString(), work.getDocument());
            indexManager.performStreamOperation(work, monitor, forceAsync);
        }
    }
}

