/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.overrides;

import java.io.IOException;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.util.ThreadInterruptedException;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConcurrentMergeScheduler
extends org.apache.lucene.index.ConcurrentMergeScheduler {
    private static final Log log = LoggerFactory.make();
    private final ErrorHandler errorHandler;
    private final String indexName;

    public ConcurrentMergeScheduler(ErrorHandler errorHandler, String indexName) {
        this.errorHandler = errorHandler;
        this.indexName = indexName;
    }

    @Override
    protected void handleMergeException(Throwable t) {
        try {
            super.handleMergeException(t);
        }
        catch (ThreadInterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            this.errorHandler.handleException(log.exceptionDuringIndexMergeOperation(), ex);
        }
    }

    @Override
    protected synchronized ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
        ConcurrentMergeScheduler.MergeThread thread = new ConcurrentMergeScheduler.MergeThread(writer, merge);
        thread.setThreadPriority(this.getMergeThreadPriority());
        thread.setDaemon(true);
        thread.setName("Lucene Merge Thread #" + this.mergeThreadCount++ + " for index " + this.indexName);
        return thread;
    }
}

