/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.io.Serializable;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.Helper;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.batchindexing.impl.SessionAwareRunnable;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IdentifierConsumerEntityProducer
implements SessionAwareRunnable {
    private static final Log log = LoggerFactory.make();
    private final ProducerConsumerQueue<List<Serializable>> source;
    private final ProducerConsumerQueue<List<?>> destination;
    private final SessionFactory sessionFactory;
    private final CacheMode cacheMode;
    private final Class<?> type;
    private final MassIndexerProgressMonitor monitor;
    private final String idName;
    private final ErrorHandler errorHandler;

    public IdentifierConsumerEntityProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, ProducerConsumerQueue<List<?>> fromEntityToAddWork, MassIndexerProgressMonitor monitor, SessionFactory sessionFactory, CacheMode cacheMode, Class<?> type, String idName, ErrorHandler errorHandler) {
        this.source = fromIdentifierListToEntities;
        this.destination = fromEntityToAddWork;
        this.monitor = monitor;
        this.sessionFactory = sessionFactory;
        this.cacheMode = cacheMode;
        this.type = type;
        this.idName = idName;
        this.errorHandler = errorHandler;
        log.trace("created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session upperSession) {
        log.trace("started");
        Session session = upperSession;
        if (upperSession == null) {
            session = this.sessionFactory.openSession();
        }
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        try {
            Transaction transaction = Helper.getTransactionAndMarkForJoin(session);
            transaction.begin();
            this.loadAllFromQueue(session);
            transaction.commit();
        }
        catch (Throwable e) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
        }
        finally {
            if (upperSession == null) {
                session.close();
            }
        }
        log.trace("finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllFromQueue(Session session) {
        try {
            List<Serializable> take;
            do {
                if ((take = this.source.take()) == null) continue;
                List<Serializable> listIds = take;
                log.tracef("received list of ids %s", (Object)listIds);
                this.loadList(listIds, session);
            } while (take != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.destination.producerStopping();
        }
    }

    private void loadList(List<Serializable> listIds, Session session) throws InterruptedException {
        Criteria criteria = session.createCriteria(this.type).setCacheMode(this.cacheMode).setLockMode(LockMode.NONE).setCacheable(false).setFlushMode(FlushMode.MANUAL).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).add(Restrictions.in(this.idName, listIds));
        List list = criteria.list();
        this.monitor.entitiesLoaded(list.size());
        session.clear();
        this.destination.put(list);
    }
}

