/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;

public class NullEncodingTwoWayFieldBridge
implements TwoWayFieldBridge {
    private final TwoWayFieldBridge fieldBridge;
    private final String nullMarker;

    public NullEncodingTwoWayFieldBridge(TwoWayFieldBridge fieldBridge, String nullMarker) {
        this.fieldBridge = fieldBridge;
        this.nullMarker = nullMarker;
    }

    @Override
    public Object get(String name, Document document) {
        Field field = document.getField(name);
        String stringValue = field.stringValue();
        if (this.nullMarker.equals(stringValue)) {
            return null;
        }
        return this.fieldBridge.get(name, document);
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return this.nullMarker;
        }
        return this.fieldBridge.objectToString(object);
    }

    public TwoWayFieldBridge unwrap() {
        return this.fieldBridge;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        this.fieldBridge.set(name, value, document, luceneOptions);
    }
}

