/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import javax.transaction.Synchronization;
import org.hibernate.Session;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.impl.SearchConfigurationFromHibernateCore;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.jmx.IndexControl;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.impl.WeakIdentityHashMap;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener {
    private static final Log log = LoggerFactory.make();
    private final Installation installation;
    protected boolean used;
    protected boolean skipDirtyChecks = true;
    protected SearchFactoryImplementor searchFactoryImplementor;
    private final transient Map<Session, Synchronization> flushSynch = new WeakIdentityHashMap<Session, Synchronization>(0);

    public FullTextIndexEventListener(Installation installation) {
        this.installation = installation;
    }

    public void initialize(Configuration cfg) {
        String indexingStrategy;
        String enableJMX;
        if (this.installation != Installation.SINGLE_INSTANCE) {
            throw new SearchException("Only Installation.SINGLE_INSTANCE is supported");
        }
        if (this.searchFactoryImplementor == null) {
            this.searchFactoryImplementor = new SearchFactoryBuilder().configuration(new SearchConfigurationFromHibernateCore(cfg)).buildSearchFactory();
        }
        if ("true".equalsIgnoreCase(enableJMX = cfg.getProperty("hibernate.search.jmx_enabled"))) {
            this.enableIndexControlBean(cfg);
        }
        if ("event".equals(indexingStrategy = this.searchFactoryImplementor.getIndexingStrategy())) {
            this.used = this.searchFactoryImplementor.getIndexBindingForEntity().size() != 0;
        } else if ("manual".equals(indexingStrategy)) {
            this.used = false;
        }
        log.debug("Hibernate Search event listeners " + (this.used ? "activated" : "deactivated"));
        this.skipDirtyChecks = !this.searchFactoryImplementor.isDirtyChecksEnabled();
        log.debug("Hibernate Search dirty checks " + (this.skipDirtyChecks ? "disabled" : "enabled"));
    }

    private void enableIndexControlBean(Configuration cfg) {
        if (StringHelper.isEmpty(cfg.getProperty("hibernate.session_factory_name"))) {
            log.debug("In order to bind the IndexControlMBean the Hibernate SessionFactory has to be available via JNDI");
            return;
        }
        if (JMXRegistrar.isNameRegistered("org.hibernate.search.jmx:type=IndexControlMBean")) {
            JMXRegistrar.unRegisterMBean("org.hibernate.search.jmx:type=IndexControlMBean");
        }
        IndexControl indexCtrlBean = new IndexControl(cfg.getProperties());
        JMXRegistrar.registerMBean(indexCtrlBean, "org.hibernate.search.jmx:type=IndexControlMBean");
    }

    public SearchFactoryImplementor getSearchFactoryImplementor() {
        return this.searchFactoryImplementor;
    }

    @Override
    public void onPostDelete(PostDeleteEvent event) {
        Object entity;
        if (this.used && this.getDocumentBuilder(entity = event.getEntity()) != null) {
            boolean identifierRollbackEnabled = event.getSession().getFactory().getSettings().isIdentifierRollbackEnabled();
            this.processWork(entity, event.getId(), WorkType.DELETE, event, identifierRollbackEnabled);
        }
    }

    @Override
    public void onPostInsert(PostInsertEvent event) {
        Object entity;
        if (this.used && this.getDocumentBuilder(entity = event.getEntity()) != null) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.ADD, event, false);
        }
    }

    @Override
    public void onPostUpdate(PostUpdateEvent event) {
        Object entity;
        AbstractDocumentBuilder docBuilder;
        if (this.used && (docBuilder = this.getDocumentBuilder(entity = event.getEntity())) != null && (this.skipDirtyChecks || docBuilder.isDirty(this.getDirtyPropertyNames(event)))) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.UPDATE, event, false);
        }
    }

    public String[] getDirtyPropertyNames(PostUpdateEvent event) {
        EntityPersister persister = event.getPersister();
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length > 0) {
            String[] propertyNames = persister.getPropertyNames();
            int length = dirtyProperties.length;
            String[] dirtyPropertyNames = new String[length];
            for (int i = 0; i < length; ++i) {
                dirtyPropertyNames[i] = propertyNames[dirtyProperties[i]];
            }
            return dirtyPropertyNames;
        }
        return null;
    }

    protected <T> void processWork(T entity, Serializable id, WorkType workType, AbstractEvent event, boolean identifierRollbackEnabled) {
        Work<T> work = new Work<T>(entity, id, workType, identifierRollbackEnabled);
        EventSourceTransactionContext transactionContext = new EventSourceTransactionContext(event.getSession());
        this.searchFactoryImplementor.getWorker().performWork(work, transactionContext);
    }

    public void cleanup() {
        this.searchFactoryImplementor.close();
    }

    @Override
    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent(event);
    }

    @Override
    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent(event);
    }

    @Override
    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent(event);
    }

    protected void processCollectionEvent(AbstractCollectionEvent event) {
        if (this.used) {
            String collectionRole;
            Object entity = event.getAffectedOwnerOrNull();
            if (entity == null) {
                return;
            }
            PersistentCollection persistentCollection = event.getCollection();
            if (persistentCollection != null) {
                if (!persistentCollection.wasInitialized()) {
                    return;
                }
                collectionRole = persistentCollection.getRole();
            } else {
                collectionRole = null;
            }
            AbstractDocumentBuilder documentBuilder = this.getDocumentBuilder(entity);
            if (documentBuilder != null && !documentBuilder.isCollectionRoleExcluded(collectionRole)) {
                Serializable id = this.getId(entity, event);
                if (id == null) {
                    log.idCannotBeExtracted(event.getAffectedOwnerEntityName());
                    return;
                }
                this.processWork(entity, id, WorkType.COLLECTION, event, false);
            }
        }
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }

    @Override
    public void onFlush(FlushEvent event) {
        EventSource session;
        Synchronization synchronization;
        if (this.used && (synchronization = this.flushSynch.get(session = event.getSession())) != null) {
            this.flushSynch.remove(session);
            log.debug("flush event causing index update out of transaction");
            synchronization.beforeCompletion();
            synchronization.afterCompletion(3);
        }
    }

    public void addSynchronization(EventSource eventSource, Synchronization synchronization) {
        this.flushSynch.put(eventSource, synchronization);
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        is.defaultReadObject();
        Class<FullTextIndexEventListener> cl = FullTextIndexEventListener.class;
        Field f = cl.getDeclaredField("flushSynch");
        ReflectionHelper.setAccessible(f);
        WeakIdentityHashMap flushSynch = new WeakIdentityHashMap(0);
        f.set(this, flushSynch);
    }

    private AbstractDocumentBuilder getDocumentBuilder(Object entity) {
        Class<?> clazz = entity.getClass();
        EntityIndexBinder entityIndexBinding = this.searchFactoryImplementor.getIndexBindingForEntity(clazz);
        if (entityIndexBinding != null) {
            return entityIndexBinding.getDocumentBuilder();
        }
        return this.searchFactoryImplementor.getDocumentBuilderContainedEntity(clazz);
    }

    static {
        Version.touch();
    }

    public static enum Installation {
        SINGLE_INSTANCE;

    }
}

