/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.MustJunction;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

class BooleanQueryBuilder
implements MustJunction {
    private final List<BooleanClause> clauses = new ArrayList<BooleanClause>(5);
    private final QueryCustomizer queryCustomizer = new QueryCustomizer();

    BooleanQueryBuilder() {
    }

    @Override
    public BooleanJunction not() {
        int lastIndex = this.clauses.size() - 1;
        BooleanClause last = this.clauses.get(lastIndex);
        if (!last.getOccur().equals((Object)BooleanClause.Occur.MUST)) {
            throw new AssertionFailure("Cannot negate class: " + (Object)((Object)last.getOccur()));
        }
        this.clauses.set(lastIndex, new BooleanClause(last.getQuery(), BooleanClause.Occur.MUST_NOT));
        return this;
    }

    @Override
    public BooleanJunction should(Query query) {
        this.clauses.add(new BooleanClause(query, BooleanClause.Occur.SHOULD));
        return this;
    }

    @Override
    public MustJunction must(Query query) {
        this.clauses.add(new BooleanClause(query, BooleanClause.Occur.MUST));
        return this;
    }

    @Override
    public MustJunction boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public MustJunction withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public MustJunction filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }

    @Override
    public Query createQuery() {
        int nbrOfClauses = this.clauses.size();
        if (nbrOfClauses == 0) {
            throw new AssertionFailure("Cannot create an empty boolean query");
        }
        if (nbrOfClauses == 1) {
            BooleanClause uniqueClause = this.clauses.get(0);
            if (uniqueClause.getOccur().equals((Object)BooleanClause.Occur.MUST_NOT)) {
                this.should(new MatchAllDocsQuery());
            } else {
                return this.queryCustomizer.setWrappedQuery(uniqueClause.getQuery()).createQuery();
            }
        }
        BooleanQuery query = new BooleanQuery();
        for (BooleanClause clause : this.clauses) {
            query.add(clause);
        }
        return this.queryCustomizer.setWrappedQuery(query).createQuery();
    }
}

