/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.FieldCacheType;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.filter.impl.CachingWrapperFilter;
import org.hibernate.search.filter.impl.ChainedFilter;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.collector.impl.FieldCacheCollectorFactory;
import org.hibernate.search.query.engine.impl.DocumentExtractorImpl;
import org.hibernate.search.query.engine.impl.FacetManagerImpl;
import org.hibernate.search.query.engine.impl.IndexSearcherWithPayload;
import org.hibernate.search.query.engine.impl.QueryHits;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.FilterCacheModeTypeHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class HSQueryImpl
implements HSQuery,
Serializable {
    private static final Log log = LoggerFactory.make();
    private static final FullTextFilterImplementor[] EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR = new FullTextFilterImplementor[0];
    private transient SearchFactoryImplementor searchFactoryImplementor;
    private Query luceneQuery;
    private List<Class<?>> targetedEntities;
    private transient TimeoutManagerImpl timeoutManager;
    private Set<Class<?>> indexedTargetedEntities;
    private boolean allowFieldSelectionInProjection = true;
    private final Map<String, FullTextFilterImpl> filterDefinitions = CollectionHelper.newHashMap();
    private Filter filter;
    private Filter userFilter;
    private Sort sort;
    private String[] projectedFields;
    private int firstResult;
    private Integer maxResults;
    private transient Set<Class<?>> classesAndSubclasses;
    private boolean needClassFilterClause;
    private Set<String> idFieldNames;
    private boolean useFieldCacheOnClassTypes = false;
    private transient FacetManagerImpl facetManager;
    private transient TimeoutExceptionFactory timeoutExceptionFactory;
    private Integer resultSize;

    public HSQueryImpl(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.timeoutExceptionFactory = searchFactoryImplementor.getDefaultTimeoutExceptionFactory();
    }

    @Override
    public void afterDeserialise(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    @Override
    public HSQuery luceneQuery(Query query) {
        this.clearCachedResults();
        this.luceneQuery = query;
        return this;
    }

    @Override
    public HSQuery targetedEntities(List<Class<?>> classes) {
        this.clearCachedResults();
        this.targetedEntities = classes == null ? new ArrayList(0) : new ArrayList(classes);
        Class[] classesAsArray = this.targetedEntities.toArray(new Class[this.targetedEntities.size()]);
        this.indexedTargetedEntities = this.searchFactoryImplementor.getIndexedTypesPolymorphic(classesAsArray);
        if (this.targetedEntities != null && this.targetedEntities.size() > 0 && this.indexedTargetedEntities.size() == 0) {
            String msg = "None of the specified entity types or any of their subclasses are indexed.";
            throw new IllegalArgumentException(msg);
        }
        return this;
    }

    @Override
    public HSQuery sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public HSQuery filter(Filter filter) {
        this.clearCachedResults();
        this.userFilter = filter;
        return this;
    }

    @Override
    public HSQuery timeoutExceptionFactory(TimeoutExceptionFactory exceptionFactory) {
        this.timeoutExceptionFactory = exceptionFactory;
        return this;
    }

    @Override
    public HSQuery projection(String ... fields) {
        this.projectedFields = fields == null || fields.length == 0 ? null : fields;
        return this;
    }

    @Override
    public HSQuery firstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public HSQuery maxResults(Integer maxResults) {
        if (maxResults != null && maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public List<Class<?>> getTargetedEntities() {
        return this.targetedEntities;
    }

    @Override
    public Set<Class<?>> getIndexedTargetedEntities() {
        return this.indexedTargetedEntities;
    }

    @Override
    public String[] getProjectedFields() {
        return this.projectedFields;
    }

    private TimeoutManagerImpl getTimeoutManagerImpl() {
        if (this.timeoutManager == null) {
            if (this.luceneQuery == null) {
                throw new AssertionFailure("Requesting TimeoutManager before setting luceneQuery()");
            }
            this.timeoutManager = new TimeoutManagerImpl(this.luceneQuery, this.timeoutExceptionFactory);
        }
        return this.timeoutManager;
    }

    @Override
    public TimeoutManager getTimeoutManager() {
        return this.getTimeoutManagerImpl();
    }

    @Override
    public FacetManagerImpl getFacetManager() {
        if (this.facetManager == null) {
            this.facetManager = new FacetManagerImpl(this);
        }
        return this.facetManager;
    }

    @Override
    public Query getLuceneQuery() {
        return this.luceneQuery;
    }

    @Override
    public List<EntityInfo> queryEntityInfos() {
        IndexSearcherWithPayload searcher = this.buildSearcher();
        if (searcher == null) {
            return Collections.emptyList();
        }
        try {
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.getFirstResultIndex();
            int max = this.max(first, queryHits.getTotalHits());
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            ArrayList<EntityInfo> infos = new ArrayList<EntityInfo>(size);
            DocumentExtractor extractor = this.buildDocumentExtractor(searcher, queryHits, first, max);
            for (int index = first; index <= max; ++index) {
                infos.add(extractor.extract(index));
                if (index % 10 != 0) continue;
                this.getTimeoutManager().isTimedOut();
            }
            ArrayList<EntityInfo> arrayList = infos;
            return arrayList;
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index", e);
        }
        finally {
            this.closeSearcher(searcher);
        }
    }

    private DocumentExtractor buildDocumentExtractor(IndexSearcherWithPayload searcher, QueryHits queryHits, int first, int max) {
        return new DocumentExtractorImpl(queryHits, this.searchFactoryImplementor, this.projectedFields, this.idFieldNames, this.allowFieldSelectionInProjection, searcher, this.luceneQuery, first, max, this.classesAndSubclasses);
    }

    @Override
    public DocumentExtractor queryDocumentExtractor() {
        IndexSearcherWithPayload openSearcher = this.buildSearcher();
        try {
            QueryHits queryHits = this.getQueryHits(openSearcher, this.calculateTopDocsRetrievalSize());
            int first = this.getFirstResultIndex();
            int max = this.max(first, queryHits.getTotalHits());
            return this.buildDocumentExtractor(openSearcher, queryHits, first, max);
        }
        catch (IOException e) {
            this.closeSearcher(openSearcher);
            throw new SearchException("Unable to query Lucene index", e);
        }
    }

    @Override
    public int queryResultSize() {
        if (this.resultSize == null) {
            this.getTimeoutManager().start();
            IndexSearcherWithPayload searcher = this.buildSearcher(this.searchFactoryImplementor, false);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    QueryHits queryHits = this.getQueryHits(searcher, 0);
                    this.resultSize = queryHits.getTotalHits();
                }
                catch (IOException e) {
                    throw new SearchException("Unable to query Lucene index", e);
                }
                finally {
                    this.closeSearcher(searcher);
                }
            }
        }
        return this.resultSize;
    }

    @Override
    public Explanation explain(int documentId) {
        Explanation explanation = null;
        IndexSearcherWithPayload searcher = this.buildSearcher(this.searchFactoryImplementor, true);
        if (searcher == null) {
            throw new SearchException("Unable to build explanation for document id:" + documentId + ". no index found");
        }
        try {
            Query filteredQuery = this.filterQueryByClasses(this.luceneQuery);
            this.buildFilters();
            explanation = searcher.getSearcher().explain(filteredQuery, documentId);
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index and build explanation", e);
        }
        finally {
            this.closeSearcher(searcher);
        }
        return explanation;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        this.clearCachedResults();
        FullTextFilterImpl filterDefinition = this.filterDefinitions.get(name);
        if (filterDefinition != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.searchFactoryImplementor.getFilterDefinition(name);
        if (filterDef == null) {
            throw log.unknownFullTextFilter(name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.clearCachedResults();
        this.filterDefinitions.remove(name);
    }

    private void closeSearcher(IndexSearcherWithPayload searcherWithPayload) {
        if (searcherWithPayload == null) {
            return;
        }
        searcherWithPayload.closeSearcher(this.luceneQuery, this.searchFactoryImplementor);
    }

    void clearCachedResults() {
        this.resultSize = null;
    }

    private QueryHits getQueryHits(IndexSearcherWithPayload searcher, Integer n) throws IOException {
        Query filteredQuery = this.filterQueryByClasses(this.luceneQuery);
        this.buildFilters();
        boolean stats = this.searchFactoryImplementor.getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.nanoTime();
        }
        QueryHits queryHits = n == null ? new QueryHits(searcher, filteredQuery, this.filter, this.sort, this.getTimeoutManagerImpl(), this.facetManager.getFacetRequests(), this.useFieldCacheOnTypes(), this.getAppropriateIdFieldCollectorFactory(), this.timeoutExceptionFactory) : (0 == n ? new QueryHits(searcher, filteredQuery, this.filter, null, 0, this.getTimeoutManagerImpl(), null, false, null, this.timeoutExceptionFactory) : new QueryHits(searcher, filteredQuery, this.filter, this.sort, n, this.getTimeoutManagerImpl(), this.facetManager.getFacetRequests(), this.useFieldCacheOnTypes(), this.getAppropriateIdFieldCollectorFactory(), this.timeoutExceptionFactory));
        this.resultSize = queryHits.getTotalHits();
        if (stats) {
            this.searchFactoryImplementor.getStatisticsImplementor().searchExecuted(filteredQuery.toString(), System.nanoTime() - startTime);
        }
        this.facetManager.setFacetResults(queryHits.getFacets());
        return queryHits;
    }

    private Integer calculateTopDocsRetrievalSize() {
        if (this.maxResults == null) {
            return null;
        }
        long tmpMaxResult = (long)this.getFirstResultIndex() + (long)this.maxResults.intValue();
        if (tmpMaxResult >= Integer.MAX_VALUE) {
            return 0x7FFFFFFE;
        }
        if (tmpMaxResult == 0L) {
            return 1;
        }
        return (int)tmpMaxResult;
    }

    private int getFirstResultIndex() {
        return this.firstResult;
    }

    private IndexSearcherWithPayload buildSearcher() {
        return this.buildSearcher(this.searchFactoryImplementor, null);
    }

    private IndexSearcherWithPayload buildSearcher(SearchFactoryImplementor searchFactoryImplementor, Boolean forceScoring) {
        Map<Class<?>, EntityIndexBinder> builders = searchFactoryImplementor.getIndexBindingForEntity();
        ArrayList<IndexManager> targetedIndexes = new ArrayList<IndexManager>();
        HashSet<String> idFieldNames = new HashSet<String>();
        Similarity searcherSimilarity = null;
        if (this.indexedTargetedEntities.size() == 0) {
            if (builders.isEmpty()) {
                throw new SearchException("There are no mapped entities. Don't forget to add @Indexed to at least one class.");
            }
            for (EntityIndexBinder indexBinder : builders.values()) {
                DocumentBuilderIndexedEntity<?> builder = indexBinder.getDocumentBuilder();
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                this.useFieldCacheOnClassTypes = this.useFieldCacheOnClassTypes || builder.getFieldCacheOption().contains((Object)FieldCacheType.CLASS);
                this.populateIndexManagers(targetedIndexes, indexBinder.getSelectionStrategy());
            }
            this.classesAndSubclasses = null;
        } else {
            DocumentBuilderIndexedEntity<?> builder;
            EntityIndexBinder indexBinder;
            HashSet involvedClasses = new HashSet(this.indexedTargetedEntities.size());
            involvedClasses.addAll(this.indexedTargetedEntities);
            for (Class<Object> clazz : this.indexedTargetedEntities) {
                indexBinder = builders.get(clazz);
                if (indexBinder == null) continue;
                builder = indexBinder.getDocumentBuilder();
                involvedClasses.addAll(builder.getMappedSubclasses());
            }
            for (Class<Object> clazz : involvedClasses) {
                indexBinder = builders.get(clazz);
                if (indexBinder == null) {
                    throw new SearchException("Not a mapped entity (don't forget to add @Indexed): " + clazz);
                }
                builder = indexBinder.getDocumentBuilder();
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                this.useFieldCacheOnClassTypes = this.useFieldCacheOnClassTypes || builder.getFieldCacheOption().contains((Object)FieldCacheType.CLASS);
                this.populateIndexManagers(targetedIndexes, indexBinder.getSelectionStrategy());
            }
            this.classesAndSubclasses = involvedClasses;
        }
        this.idFieldNames = idFieldNames;
        if (this.classesAndSubclasses != null) {
            for (IndexManager indexManager : targetedIndexes) {
                Set<Class<?>> classesInIndexManager = indexManager.getContainedTypes();
                if (classesInIndexManager.size() > 1) {
                    for (Class<?> clazz : classesInIndexManager) {
                        if (this.classesAndSubclasses.contains(clazz)) continue;
                        this.needClassFilterClause = true;
                        break;
                    }
                }
                if (!this.needClassFilterClause) continue;
                break;
            }
        } else {
            Map<Class<?>, EntityIndexBinder> documentBuildersIndexedEntities = searchFactoryImplementor.getIndexBindingForEntity();
            this.classesAndSubclasses = documentBuildersIndexedEntities.keySet();
        }
        IndexManager[] indexManagers = targetedIndexes.toArray(new IndexManager[targetedIndexes.size()]);
        IndexSearcher is = new IndexSearcher(MultiReaderFactory.openReader(indexManagers));
        is.setSimilarity(searcherSimilarity);
        String[] projection = this.projectedFields;
        if (Boolean.TRUE.equals(forceScoring)) {
            return new IndexSearcherWithPayload(is, true, true);
        }
        if (Boolean.FALSE.equals(forceScoring)) {
            return new IndexSearcherWithPayload(is, false, false);
        }
        if (this.sort != null && projection != null) {
            boolean activate = false;
            for (String field : projection) {
                if (!"__HSearch_Score".equals(field)) continue;
                activate = true;
                break;
            }
            if (activate) {
                return new IndexSearcherWithPayload(is, true, false);
            }
        }
        return new IndexSearcherWithPayload(is, false, false);
    }

    private Similarity checkSimilarity(Similarity similarity, DocumentBuilderIndexedEntity builder) {
        if (similarity == null) {
            similarity = builder.getSimilarity();
        } else if (!similarity.getClass().equals(builder.getSimilarity().getClass())) {
            throw new SearchException("Cannot perform search on two entities with differing Similarity implementations (" + similarity.getClass().getName() + " & " + builder.getSimilarity().getClass().getName() + ")");
        }
        return similarity;
    }

    private void populateIndexManagers(List<IndexManager> indexManagersTarget, IndexShardingStrategy indexShardingStrategy) {
        IndexManager[] indexManagersForQuery = this.filterDefinitions != null && !this.filterDefinitions.isEmpty() ? indexShardingStrategy.getIndexManagersForQuery(this.filterDefinitions.values().toArray(new FullTextFilterImplementor[this.filterDefinitions.size()])) : indexShardingStrategy.getIndexManagersForQuery(EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR);
        for (IndexManager indexManager : indexManagersForQuery) {
            if (indexManagersTarget.contains(indexManager)) continue;
            indexManagersTarget.add(indexManager);
        }
    }

    private void buildFilters() {
        ChainedFilter chainedFilter = new ChainedFilter();
        if (!this.filterDefinitions.isEmpty()) {
            for (FullTextFilterImpl fullTextFilter : this.filterDefinitions.values()) {
                Filter filter = this.buildLuceneFilter(fullTextFilter);
                if (filter == null) continue;
                chainedFilter.addFilter(filter);
            }
        }
        if (this.userFilter != null) {
            chainedFilter.addFilter(this.userFilter);
        }
        if (this.getFacetManager().getFacetFilter() != null) {
            chainedFilter.addFilter(this.facetManager.getFacetFilter());
        }
        this.filter = chainedFilter.isEmpty() ? null : chainedFilter;
    }

    private Filter buildLuceneFilter(FullTextFilterImpl fullTextFilter) {
        Filter filter;
        FilterDef def = this.searchFactoryImplementor.getFilterDefinition(fullTextFilter.getName());
        if (this.isPreQueryFilterOnly(def)) {
            return null;
        }
        Object instance = this.createFilterInstance(fullTextFilter, def);
        FilterKey key = this.createFilterKey(def, instance);
        Filter filter2 = filter = FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode()) ? this.searchFactoryImplementor.getFilterCachingStrategy().getCachedFilter(key) : null;
        if (filter == null) {
            filter = this.createFilter(def, instance);
            if (FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode())) {
                this.searchFactoryImplementor.getFilterCachingStrategy().addCachedFilter(key, filter);
            }
        }
        return filter;
    }

    private boolean isPreQueryFilterOnly(FilterDef def) {
        return def.getImpl().equals(ShardSensitiveOnlyFilter.class);
    }

    private Filter createFilter(FilterDef def, Object instance) {
        Filter filter;
        if (def.getFactoryMethod() != null) {
            try {
                filter = (Filter)def.getFactoryMethod().invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
        }
        try {
            filter = (Filter)instance;
        }
        catch (ClassCastException e) {
            throw new SearchException("Filter implementation does not implement the Filter interface: " + def.getImpl().getName() + ". " + (def.getFactoryMethod() != null ? def.getFactoryMethod().getName() : ""), e);
        }
        filter = this.addCachingWrapperFilter(filter, def);
        return filter;
    }

    private Filter addCachingWrapperFilter(Filter filter, FilterDef def) {
        if (FilterCacheModeTypeHelper.cacheResults(def.getCacheMode())) {
            int cachingWrapperFilterSize = this.searchFactoryImplementor.getFilterCacheBitResultsSize();
            filter = new CachingWrapperFilter(filter, cachingWrapperFilterSize);
        }
        return filter;
    }

    private FilterKey createFilterKey(FilterDef def, Object instance) {
        FilterKey key = null;
        if (!FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode())) {
            return key;
        }
        if (def.getKeyMethod() == null) {
            key = new FilterKey(){

                @Override
                public int hashCode() {
                    return this.getImpl().hashCode();
                }

                @Override
                public boolean equals(Object obj) {
                    if (!(obj instanceof FilterKey)) {
                        return false;
                    }
                    FilterKey that = (FilterKey)obj;
                    return this.getImpl().equals(that.getImpl());
                }
            };
        } else {
            try {
                key = (FilterKey)def.getKeyMethod().invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (InvocationTargetException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
        }
        key.setImpl(def.getImpl());
        StandardFilterKey wrapperKey = new StandardFilterKey();
        wrapperKey.addParameter(def.getName());
        wrapperKey.addParameter(key);
        return wrapperKey;
    }

    private Object createFilterInstance(FullTextFilterImpl fullTextFilter, FilterDef def) {
        Object instance;
        try {
            instance = def.getImpl().newInstance();
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), e);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), e);
        }
        for (Map.Entry<String, Object> entry : fullTextFilter.getParameters().entrySet()) {
            def.invoke(entry.getKey(), instance, entry.getValue());
        }
        if (FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode()) && def.getKeyMethod() == null && fullTextFilter.getParameters().size() > 0) {
            throw new SearchException("Filter with parameters and no @Key method: " + fullTextFilter.getName());
        }
        return instance;
    }

    private Query filterQueryByClasses(Query luceneQuery) {
        if (!this.needClassFilterClause) {
            return luceneQuery;
        }
        BooleanQuery classFilter = new BooleanQuery();
        classFilter.setBoost(0.0f);
        for (Class<?> clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilter.add(termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add(classFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private int max(int first, int totalHits) {
        if (this.maxResults == null) {
            return totalHits - 1;
        }
        return this.maxResults + first < totalHits ? first + this.maxResults - 1 : totalHits - 1;
    }

    @Override
    public SearchFactoryImplementor getSearchFactoryImplementor() {
        return this.searchFactoryImplementor;
    }

    private boolean useFieldCacheOnTypes() {
        if (this.classesAndSubclasses.size() <= 1) {
            return false;
        }
        return this.useFieldCacheOnClassTypes;
    }

    private FieldCacheCollectorFactory getAppropriateIdFieldCollectorFactory() {
        Map<Class<?>, EntityIndexBinder> builders = this.searchFactoryImplementor.getIndexBindingForEntity();
        HashSet<FieldCacheCollectorFactory> allCollectors = new HashSet<FieldCacheCollectorFactory>();
        FieldCacheCollectorFactory anyImplementation = null;
        for (Class<?> clazz : this.classesAndSubclasses) {
            EntityIndexBinder docBuilder = builders.get(clazz);
            FieldCacheCollectorFactory fieldCacheCollectionFactory = docBuilder.getIdFieldCacheCollectionFactory();
            if (fieldCacheCollectionFactory == null) {
                return null;
            }
            anyImplementation = fieldCacheCollectionFactory;
            allCollectors.add(fieldCacheCollectionFactory);
        }
        if (allCollectors.size() != 1) {
            return null;
        }
        return anyImplementation;
    }
}

