/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;

public final class LongFieldLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private long[] currentCache;

    public LongFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(IndexReader reader) throws IOException {
        this.currentCache = FieldCache.DEFAULT.getLongs(reader, this.fieldName);
    }

    @Override
    public Long collect(int relativeDocId) {
        return this.currentCache[relativeDocId];
    }
}

