/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader.impl;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.spi.ReaderProvider;

public class CacheableMultiReader
extends MultiReader {
    final IndexReader[] subReaders;
    final ReaderProvider[] managers;

    public CacheableMultiReader(IndexReader[] subReaders, ReaderProvider[] managers) {
        super(subReaders, false);
        this.subReaders = subReaders;
        this.managers = managers;
    }

    @Override
    public final void decRef() {
        this.avoidUsingThis();
    }

    @Override
    public final synchronized IndexReader reopen() {
        this.avoidUsingThis();
        return null;
    }

    @Override
    public final void incRef() {
        this.avoidUsingThis();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheableMultiReader)) {
            return false;
        }
        CacheableMultiReader that = (CacheableMultiReader)obj;
        int length = this.subReaders.length;
        if (length != that.subReaders.length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (this.subReaders[index].equals(that.subReaders[index])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (IndexReader reader : this.subReaders) {
            result = 31 * result + reader.hashCode();
        }
        return result;
    }

    private void avoidUsingThis() {
        throw new SearchException("IndexReader lifecycle should not be managed, please use org.hibernate.search.SearchFactory.closeIndexReader(IndexReader) to close IndexReader instances or pool them.");
    }
}

