/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.List;
import java.util.stream.Collectors;
import org.pitest.classpath.CodeSource;
import org.pitest.mutationtest.verify.BuildVerifier;
import org.pitest.mutationtest.verify.BuildVerifierFactory;

public class CompoundBuildVerifierFactory
implements BuildVerifierFactory {
    List<BuildVerifierFactory> verifiers;

    public CompoundBuildVerifierFactory(List<BuildVerifierFactory> verifiers) {
        this.verifiers = verifiers;
    }

    @Override
    public BuildVerifier create(CodeSource code) {
        return () -> this.verifiers.stream().map(f -> f.create(code)).flatMap(v -> v.verify().stream()).collect(Collectors.toList());
    }

    public String description() {
        return "Build Verifier";
    }
}

