/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.cast;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v111.cast.model.Sink;

@Beta
public class Cast {
    public static Command<Void> enable(Optional<String> presentationUrl) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        presentationUrl.ifPresent(p -> params.put((Object)"presentationUrl", p));
        return new Command("Cast.enable", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Cast.disable", (Map)params.build());
    }

    public static Command<Void> setSinkToUse(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"sinkName", (Object)sinkName);
        return new Command("Cast.setSinkToUse", (Map)params.build());
    }

    public static Command<Void> startDesktopMirroring(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"sinkName", (Object)sinkName);
        return new Command("Cast.startDesktopMirroring", (Map)params.build());
    }

    public static Command<Void> startTabMirroring(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"sinkName", (Object)sinkName);
        return new Command("Cast.startTabMirroring", (Map)params.build());
    }

    public static Command<Void> stopCasting(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"sinkName", (Object)sinkName);
        return new Command("Cast.stopCasting", (Map)params.build());
    }

    public static Event<List<Sink>> sinksUpdated() {
        return new Event("Cast.sinksUpdated", ConverterFunctions.map((String)"sinks", (Type)new TypeToken<List<Sink>>(){}.getType()));
    }

    public static Event<String> issueUpdated() {
        return new Event("Cast.issueUpdated", ConverterFunctions.map((String)"issueMessage", String.class));
    }
}

