/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.Version;
import tachyon.client.InStream;
import tachyon.client.OutStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.UserConf;
import tachyon.util.CommonUtils;

public class Performance {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static final int RESULT_ARRAY_SIZE = 64;
    private static final String FOLDER = "/mnt/ramdisk/";
    private static TachyonFS sMtc = null;
    private static TachyonURI sMasterAddress = null;
    private static String sFileName = null;
    private static int sBlockSizeBytes = -1;
    private static long sBlocksPerFile = -1L;
    private static int sThreads = -1;
    private static int sFiles = -1;
    private static boolean sDebugMode = false;
    private static long sFileBytes = -1L;
    private static long sFilesBytes = -1L;
    private static String sResultPrefix = null;
    private static long[] sResults = new long[64];
    private static int sBaseFileNumber = 0;
    private static boolean sTachyonStreamingRead = false;

    public static void createFiles() throws IOException {
        long startTimeMs = CommonUtils.getCurrentMs();
        for (int k = 0; k < sFiles; ++k) {
            int fileId = sMtc.createFile(new TachyonURI(sFileName + (k + sBaseFileNumber)));
            CommonUtils.printTimeTakenMs(startTimeMs, LOG, "user_createFiles with fileId " + fileId);
        }
    }

    public static void logPerIteration(long startTimeMs, int times, String msg, int workerId) {
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = 1000.0 * (double)sFileBytes / (double)takenTimeMs / 1024.0 / 1024.0;
        LOG.info(times + msg + workerId + " : " + result + " Mb/sec. Took " + takenTimeMs + " ms. ");
    }

    private static void memoryCopyTest(boolean write, boolean memoryOnly) {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[sThreads];
        for (int thread2 = 0; thread2 < sThreads; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(sBlockSizeBytes);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < sBlockSizeBytes / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        String msg = (write ? "Write" : "Read") + (memoryOnly ? "_Memory " : "_RamFile ");
        GeneralWorker[] workerThreads = new GeneralWorker[sThreads];
        int t = sFiles / sThreads;
        for (int thread3 = 0; thread3 < sThreads; ++thread3) {
            workerThreads[thread3] = new GeneralWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3], write, memoryOnly, msg);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < sThreads; ++thread) {
            workerThreads[thread].start();
        }
        for (thread = 0; thread < sThreads; ++thread) {
            try {
                workerThreads[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = 1000.0 * (double)sFilesBytes / (double)takenTimeMs / 1024.0 / 1024.0;
        LOG.info(result + " Mb/sec. " + sResultPrefix + "Entire " + msg + " Test : " + " Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis());
    }

    private static void TachyonTest(boolean write) throws IOException {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[sThreads];
        for (int thread2 = 0; thread2 < sThreads; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(sBlockSizeBytes);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < sBlockSizeBytes / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        Worker[] workerThreads = new Worker[sThreads];
        int t = sFiles / sThreads;
        for (int thread3 = 0; thread3 < sThreads; ++thread3) {
            workerThreads[thread3] = write ? new TachyonWriterWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3]) : new TachyonReadWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3]);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < sThreads; ++thread) {
            workerThreads[thread].start();
        }
        for (thread = 0; thread < sThreads; ++thread) {
            try {
                workerThreads[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = (double)sFilesBytes * 1000.0 / (double)takenTimeMs / 1024.0 / 1024.0;
        LOG.info(result + " Mb/sec. " + sResultPrefix + "Entire " + (write ? "Write " : "Read ") + " Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis());
    }

    private static void HdfsTest(boolean write) throws IOException {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[sThreads];
        for (int thread2 = 0; thread2 < sThreads; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(sBlockSizeBytes);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < sBlockSizeBytes / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        Worker[] workerThreads = new Worker[sThreads];
        int t = sFiles / sThreads;
        String msg = write ? "Write " : "Read ";
        for (int thread3 = 0; thread3 < sThreads; ++thread3) {
            workerThreads[thread3] = new HdfsWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3], write, msg);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < sThreads; ++thread) {
            workerThreads[thread].start();
        }
        for (thread = 0; thread < sThreads; ++thread) {
            try {
                workerThreads[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = (double)sFilesBytes * 1000.0 / (double)takenTimeMs / 1024.0 / 1024.0;
        LOG.info(result + " Mb/sec. " + sResultPrefix + "Entire " + (write ? "Write " : "Read ") + " Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis());
    }

    public static void main(String[] args) throws IOException {
        int k;
        if (args.length != 9) {
            System.out.println("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar tachyon.examples.Performance " + "<MasterIp> <FileNamePrefix> <WriteBlockSizeInBytes> <BlocksPerFile> " + "<DebugMode:true/false> <Threads> <FilesPerThread> <TestCaseNumber> " + "<BaseFileNumber>\n" + "1: Files Write Test\n" + "2: Files Read Test\n" + "3: RamFile Write Test \n" + "4: RamFile Read Test \n" + "5: ByteBuffer Write Test \n" + "6: ByteBuffer Read Test \n");
            System.exit(-1);
        }
        sMasterAddress = new TachyonURI(args[0]);
        sFileName = args[1];
        sBlockSizeBytes = Integer.parseInt(args[2]);
        sBlocksPerFile = Long.parseLong(args[3]);
        sDebugMode = "true".equals(args[4]);
        sThreads = Integer.parseInt(args[5]);
        sFiles = Integer.parseInt(args[6]) * sThreads;
        int testCase = Integer.parseInt(args[7]);
        sBaseFileNumber = Integer.parseInt(args[8]);
        sFileBytes = sBlocksPerFile * (long)sBlockSizeBytes;
        sFilesBytes = 1L * sFileBytes * (long)sFiles;
        sResultPrefix = String.format("Threads %d FilesPerThread %d TotalFiles %d BLOCK_SIZE_KB %d BLOCKS_PER_FILE %d FILE_SIZE_MB %d Tachyon_WRITE_BUFFER_SIZE_KB %d BaseFileNumber %d : ", sThreads, sFiles / sThreads, sFiles, sBlockSizeBytes / 1024, sBlocksPerFile, CommonUtils.getMB(sFileBytes), UserConf.get().FILE_BUFFER_BYTES / 1024, sBaseFileNumber);
        for (k = 0; k < 10000000; ++k) {
        }
        if (testCase == 1) {
            sResultPrefix = "TachyonFilesWriteTest " + sResultPrefix;
            LOG.info(sResultPrefix);
            sMtc = TachyonFS.get(sMasterAddress);
            Performance.createFiles();
            Performance.TachyonTest(true);
        } else if (testCase == 2 || testCase == 9) {
            sResultPrefix = "TachyonFilesReadTest " + sResultPrefix;
            LOG.info(sResultPrefix);
            sMtc = TachyonFS.get(sMasterAddress);
            sTachyonStreamingRead = 9 == testCase;
            Performance.TachyonTest(false);
        } else if (testCase == 3) {
            sResultPrefix = "RamFile Write " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.memoryCopyTest(true, false);
        } else if (testCase == 4) {
            sResultPrefix = "RamFile Read " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.memoryCopyTest(false, false);
        } else if (testCase == 5) {
            sResultPrefix = "ByteBuffer Write Test " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.memoryCopyTest(true, true);
        } else if (testCase == 6) {
            sResultPrefix = "ByteBuffer Read Test " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.memoryCopyTest(false, true);
        } else if (testCase == 7) {
            sResultPrefix = "HdfsFilesWriteTest " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.HdfsTest(true);
        } else if (testCase == 8) {
            sResultPrefix = "HdfsFilesReadTest " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.HdfsTest(false);
        } else {
            throw new RuntimeException("No Test Case " + testCase);
        }
        for (k = 0; k < 64; ++k) {
            System.out.print(sResults[k] + " ");
        }
        System.out.println();
        System.exit(0);
    }

    static /* synthetic */ TachyonURI access$600() {
        return sMasterAddress;
    }

    public static class HdfsWorker
    extends Worker {
        private boolean mWrite;
        private String mMsg;
        private FileSystem mHdfsFs;

        public HdfsWorker(int id, int left, int right, ByteBuffer buf, boolean write, String msg) throws IOException {
            super(id, left, right, buf);
            this.mWrite = write;
            this.mMsg = msg;
            Configuration tConf = new Configuration();
            tConf.set("fs.default.name", sFileName);
            tConf.set("fs.defaultFS", sFileName);
            tConf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
            tConf.set("dfs.client.read.shortcircuit", "true");
            tConf.set("dfs.domain.socket.path", "/var/lib/hadoop-hdfs/dn_socket");
            tConf.set("dfs.client.read.shortcircuit.skip.checksum", "true");
            this.mHdfsFs = FileSystem.get((Configuration)tConf);
        }

        public void io() throws IOException {
            if (sDebugMode) {
                this.mBuf.flip();
                CommonUtils.printByteBuffer(LOG, this.mBuf);
            }
            this.mBuf.flip();
            long sum = 0L;
            String str = "th " + this.mMsg + " @ Worker ";
            if (this.mWrite) {
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    String filePath = sFileName + (times + sBaseFileNumber);
                    FSDataOutputStream os = this.mHdfsFs.create(new Path(filePath));
                    int k = 0;
                    while ((long)k < sBlocksPerFile) {
                        this.mBuf.putInt(0, k + this.mWorkerId);
                        os.write(this.mBuf.array());
                        ++k;
                    }
                    os.close();
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            } else {
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    int r;
                    long startTimeMs = System.currentTimeMillis();
                    String filePath = sFileName + (times + sBaseFileNumber);
                    FSDataInputStream is = this.mHdfsFs.open(new Path(filePath));
                    for (long len = sBlocksPerFile * (long)sBlockSizeBytes; len > 0L; len -= (long)r) {
                        r = is.read(this.mBuf.array());
                        Preconditions.checkState((r != -1 ? 1 : 0) != 0, (Object)"R == -1");
                    }
                    is.close();
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            }
            sResults[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.io();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            LOG.info(this.mMsg + this.mWorkerId + " just finished.");
        }
    }

    public static class TachyonReadWorker
    extends Worker {
        private TachyonFS mTC = TachyonFS.get(Performance.access$600());

        public TachyonReadWorker(int id, int left, int right, ByteBuffer buf) throws IOException {
            super(id, left, right, buf);
        }

        public void readPartition() throws IOException {
            TachyonByteBuffer buf;
            if (sDebugMode) {
                LOG.info("Verifying the reading data...");
                for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                    TachyonFile file = this.mTC.getFile(new TachyonURI(sFileName + (pId + sBaseFileNumber)));
                    buf = file.readByteBuffer(0);
                    IntBuffer intBuf = buf.mData.order(ByteOrder.nativeOrder()).asIntBuffer();
                    int i = 0;
                    while ((long)i < sBlocksPerFile) {
                        for (int k = 0; k < sBlockSizeBytes / 4; ++k) {
                            int tmp = intBuf.get();
                            if (!(k == 0 && tmp == i + this.mWorkerId || k != 0 && tmp == k)) {
                                throw new IllegalStateException("WHAT? " + tmp + " " + k);
                            }
                            LOG.debug("Partition at {} is {}", (Object)k, (Object)tmp);
                        }
                        ++i;
                    }
                    buf.close();
                }
            }
            long sum = 0L;
            if (sTachyonStreamingRead) {
                for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                    int r;
                    long startTimeMs = System.currentTimeMillis();
                    TachyonFile file = this.mTC.getFile(new TachyonURI(sFileName + (pId + sBaseFileNumber)));
                    InStream is = file.getInStream(ReadType.CACHE);
                    for (long len = sBlocksPerFile * (long)sBlockSizeBytes; len > 0L; len -= (long)r) {
                        r = ((InputStream)is).read(this.mBuf.array());
                        Preconditions.checkState((r != -1 ? 1 : 0) != 0, (Object)"R == -1");
                    }
                    ((InputStream)is).close();
                    Performance.logPerIteration(startTimeMs, pId, "th ReadTachyonFile @ Worker ", pId);
                }
            } else {
                for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                    long startTimeMs = System.currentTimeMillis();
                    TachyonFile file = this.mTC.getFile(new TachyonURI(sFileName + (pId + sBaseFileNumber)));
                    buf = file.readByteBuffer(0);
                    int i = 0;
                    while ((long)i < sBlocksPerFile) {
                        buf.mData.get(this.mBuf.array());
                        ++i;
                    }
                    sum += (long)this.mBuf.get(pId % 16);
                    if (sDebugMode) {
                        buf.mData.order(ByteOrder.nativeOrder()).flip();
                        CommonUtils.printByteBuffer(LOG, buf.mData);
                    }
                    buf.mData.clear();
                    Performance.logPerIteration(startTimeMs, pId, "th ReadTachyonFile @ Worker ", pId);
                    buf.close();
                }
            }
            sResults[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.readPartition();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            LOG.info("ReadWorker " + this.mWorkerId + " just finished.");
        }
    }

    public static class TachyonWriterWorker
    extends Worker {
        private TachyonFS mTC = TachyonFS.get(Performance.access$600());

        public TachyonWriterWorker(int id, int left, int right, ByteBuffer buf) throws IOException {
            super(id, left, right, buf);
        }

        public void writeParition() throws IOException {
            if (sDebugMode) {
                this.mBuf.flip();
                CommonUtils.printByteBuffer(LOG, this.mBuf);
            }
            this.mBuf.flip();
            for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                long startTimeMs = System.currentTimeMillis();
                TachyonFile file = this.mTC.getFile(new TachyonURI(sFileName + (pId + sBaseFileNumber)));
                OutStream os = file.getOutStream(WriteType.MUST_CACHE);
                int k = 0;
                while ((long)k < sBlocksPerFile) {
                    this.mBuf.putInt(0, k + this.mWorkerId);
                    os.write(this.mBuf.array());
                    ++k;
                }
                os.close();
                Performance.logPerIteration(startTimeMs, pId, "th WriteTachyonFile @ Worker ", pId);
            }
        }

        @Override
        public void run() {
            try {
                this.writeParition();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            LOG.info("WriteWorker " + this.mWorkerId + " just finished.");
        }
    }

    public static class GeneralWorker
    extends Worker {
        private boolean mOneToMany;
        private boolean mMemoryOnly;
        private String mMsg;

        public GeneralWorker(int id, int left, int right, ByteBuffer buf, boolean oneToMany, boolean memoryOnly, String msg) {
            super(id, left, right, buf);
            this.mOneToMany = oneToMany;
            this.mMemoryOnly = memoryOnly;
            this.mMsg = msg;
        }

        public void memoryCopyParition() throws IOException {
            if (sDebugMode) {
                this.mBuf.flip();
                CommonUtils.printByteBuffer(LOG, this.mBuf);
            }
            this.mBuf.flip();
            long sum = 0L;
            String str = "th " + this.mMsg + " @ Worker ";
            if (this.mOneToMany) {
                ByteBuffer dst = null;
                RandomAccessFile file = null;
                if (this.mMemoryOnly) {
                    dst = ByteBuffer.allocateDirect((int)sFileBytes);
                }
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    if (!this.mMemoryOnly) {
                        file = new RandomAccessFile(Performance.FOLDER + (times + sBaseFileNumber), "rw");
                        dst = file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, sFileBytes);
                    }
                    dst.order(ByteOrder.nativeOrder());
                    int k = 0;
                    while ((long)k < sBlocksPerFile) {
                        this.mBuf.putInt(0, k + this.mWorkerId);
                        dst.put(this.mBuf.array());
                        ++k;
                    }
                    dst.clear();
                    sum += (long)dst.get(times);
                    dst.clear();
                    if (!this.mMemoryOnly) {
                        file.close();
                    }
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            } else {
                ByteBuffer dst = null;
                RandomAccessFile file = null;
                if (this.mMemoryOnly) {
                    dst = ByteBuffer.allocateDirect((int)sFileBytes);
                }
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    if (!this.mMemoryOnly) {
                        file = new RandomAccessFile(Performance.FOLDER + (times + sBaseFileNumber), "rw");
                        dst = file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, sFileBytes);
                    }
                    dst.order(ByteOrder.nativeOrder());
                    int k = 0;
                    while ((long)k < sBlocksPerFile) {
                        dst.get(this.mBuf.array());
                        ++k;
                    }
                    sum += (long)this.mBuf.get(times % 16);
                    dst.clear();
                    if (!this.mMemoryOnly) {
                        file.close();
                    }
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            }
            sResults[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.memoryCopyParition();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            LOG.info(this.mMsg + this.mWorkerId + " just finished.");
        }
    }

    public static abstract class Worker
    extends Thread {
        protected int mWorkerId;
        protected int mLeft;
        protected int mRight;
        protected ByteBuffer mBuf;

        public Worker(int id, int left, int right, ByteBuffer buf) {
            this.mWorkerId = id;
            this.mLeft = left;
            this.mRight = right;
            this.mBuf = buf;
        }
    }
}

