/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;

public class MasterWorkerInfo {
    public final NetAddress mWorkerAddress;
    private final long mCapacityBytes;
    private final long mStartTimeMs;
    private long mId;
    private long mUsedBytes;
    private long mLastUpdatedTimeMs;
    private Set<Long> mBlocks;
    private Set<Long> mToRemoveBlocks;

    public MasterWorkerInfo(long id, NetAddress address, long capacityBytes) {
        this.mId = id;
        this.mWorkerAddress = address;
        this.mCapacityBytes = capacityBytes;
        this.mStartTimeMs = System.currentTimeMillis();
        this.mUsedBytes = 0L;
        this.mBlocks = new HashSet<Long>();
        this.mToRemoveBlocks = new HashSet<Long>();
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public synchronized ClientWorkerInfo generateClientWorkerInfo() {
        ClientWorkerInfo ret = new ClientWorkerInfo();
        ret.id = this.mId;
        ret.address = this.mWorkerAddress;
        ret.lastContactSec = (int)((CommonUtils.getCurrentMs() - this.mLastUpdatedTimeMs) / 1000L);
        ret.state = "In Service";
        ret.capacityBytes = this.mCapacityBytes;
        ret.usedBytes = this.mUsedBytes;
        ret.starttimeMs = this.mStartTimeMs;
        return ret;
    }

    public NetAddress getAddress() {
        return this.mWorkerAddress;
    }

    public synchronized long getAvailableBytes() {
        return this.mCapacityBytes - this.mUsedBytes;
    }

    public synchronized Set<Long> getBlocks() {
        return new HashSet<Long>(this.mBlocks);
    }

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public synchronized long getId() {
        return this.mId;
    }

    public synchronized long getLastUpdatedTimeMs() {
        return this.mLastUpdatedTimeMs;
    }

    public synchronized List<Long> getToRemovedBlocks() {
        return new ArrayList<Long>(this.mToRemoveBlocks);
    }

    public synchronized long getUsedBytes() {
        return this.mUsedBytes;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("MasterWorkerInfo(");
        sb.append(" ID: ").append(this.mId);
        sb.append(", mWorkerAddress: ").append(this.mWorkerAddress);
        sb.append(", TOTAL_BYTES: ").append(this.mCapacityBytes);
        sb.append(", mUsedBytes: ").append(this.mUsedBytes);
        sb.append(", mAvailableBytes: ").append(this.mCapacityBytes - this.mUsedBytes);
        sb.append(", mLastUpdatedTimeMs: ").append(this.mLastUpdatedTimeMs);
        sb.append(", mBlocks: [ ");
        for (long blockId : this.mBlocks) {
            sb.append(blockId).append(", ");
        }
        sb.append("] )");
        return sb.toString();
    }

    public synchronized void updateBlock(boolean add, long blockId) {
        if (add) {
            this.mBlocks.add(blockId);
        } else {
            this.mBlocks.remove(blockId);
        }
    }

    public synchronized void updateBlocks(boolean add, Collection<Long> blockIds) {
        if (add) {
            this.mBlocks.addAll(blockIds);
        } else {
            this.mBlocks.removeAll(blockIds);
        }
    }

    public synchronized void updateLastUpdatedTimeMs() {
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public synchronized void updateToRemovedBlock(boolean add, long blockId) {
        if (add) {
            if (this.mBlocks.contains(blockId)) {
                this.mToRemoveBlocks.add(blockId);
            }
        } else {
            this.mToRemoveBlocks.remove(blockId);
        }
    }

    public synchronized void updateToRemovedBlocks(boolean add, Collection<Long> blockIds) {
        for (long blockId : blockIds) {
            this.updateToRemovedBlock(add, blockId);
        }
    }

    public synchronized void updateUsedBytes(long usedBytes) {
        this.mUsedBytes = usedBytes;
    }
}

