/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.saml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.trust.STSClient;
import org.talend.esb.security.saml.ClaimsBuilder;
import org.talend.esb.security.saml.STSClientCreator;

public class STSClientUtils
implements STSClientCreator {
    private static final String STS_WSDL_LOCATION = "sts.wsdl.location";
    private static final String STS_X509_WSDL_LOCATION = "sts.x509.wsdl.location";
    private static final String STS_NAMESPACE = "sts.namespace";
    private static final String STS_SERVICE_NAME = "sts.service.name";
    private static final String STS_ENDPOINT_NAME = "sts.endpoint.name";
    private static final String STS_X509_ENDPOINT_NAME = "sts.x509.endpoint.name";
    private static final String STS_TOKEN_TYPE = "sts.tokentype";
    private static final String STS_KEY_TYPE = "sts.keytype";
    private static final String STS_ALLOW_RENEWING = "sts.allow.renewing";
    private static STSClientUtils instance;
    private Map<String, Object> stsProperties;
    private Map<String, Object> stsPropertiesOverride;

    public STSClientUtils(Map<String, Object> stsProperties) {
        this(stsProperties, null);
    }

    public STSClientUtils(Map<String, Object> stsProperties, Map<String, Object> stsPropertiesOverride) {
        this.stsProperties = stsProperties;
        this.stsPropertiesOverride = stsPropertiesOverride;
        instance = this;
    }

    public static STSClient createSTSClient(Bus bus, Map<String, Object> stsProps) {
        STSClient stsClient = STSClientUtils.createClient(bus, stsProps);
        stsClient.setWsdlLocation((String)stsProps.get(STS_WSDL_LOCATION));
        stsClient.setEndpointQName(new QName((String)stsProps.get(STS_NAMESPACE), (String)stsProps.get(STS_ENDPOINT_NAME)));
        return stsClient;
    }

    @Override
    public STSClient newSTSClient(Bus bus, String username, String password) {
        Map<String, Object> stsProps = this.getMergedStsProperties();
        stsProps.put("security.username", username);
        stsProps.put("security.password", password);
        return STSClientUtils.createSTSClient(bus, stsProps);
    }

    public static STSClient createSTSClient(Bus bus, String username, String password) {
        STSClientUtils creator = instance;
        if (creator == null) {
            throw new IllegalStateException("STSClientUtils is not initialized. ");
        }
        return creator.newSTSClient(bus, username, password);
    }

    public static STSClient createSTSX509Client(Bus bus, Map<String, Object> stsProps) {
        STSClient stsClient = STSClientUtils.createClient(bus, stsProps);
        stsClient.setWsdlLocation((String)stsProps.get(STS_X509_WSDL_LOCATION));
        stsClient.setEndpointQName(new QName((String)stsProps.get(STS_NAMESPACE), (String)stsProps.get(STS_X509_ENDPOINT_NAME)));
        return stsClient;
    }

    @Override
    public STSClient newSTSX509Client(Bus bus, String alias) {
        Map<String, Object> stsProps = this.getMergedStsProperties();
        stsProps.put("security.sts.token.username", alias);
        return STSClientUtils.createSTSX509Client(bus, stsProps);
    }

    public static STSClient createSTSX509Client(Bus bus, String alias) {
        STSClientUtils creator = instance;
        if (creator == null) {
            throw new IllegalStateException("STSClientUtils is not initialized. ");
        }
        return creator.newSTSX509Client(bus, alias);
    }

    public static void applyAuthorization(STSClient stsClient, String role) {
        if (null != role && role.length() > 0) {
            stsClient.setClaims((Object)ClaimsBuilder.createClaimValue(role));
        } else {
            stsClient.setClaims((Object)ClaimsBuilder.createClaimType());
        }
    }

    private static STSClient createClient(Bus bus, Map<String, Object> stsProps) {
        STSClient stsClient = new STSClient(bus);
        stsClient.setServiceQName(new QName((String)stsProps.get(STS_NAMESPACE), (String)stsProps.get(STS_SERVICE_NAME)));
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : stsProps.entrySet()) {
            if (!SecurityConstants.ALL_PROPERTIES.contains(entry.getKey())) continue;
            props.put(entry.getKey(), STSClientUtils.processFileURI(entry.getValue()));
        }
        stsClient.setProperties(props);
        stsClient.setEnableLifetime(true);
        if (stsProps.get(STS_TOKEN_TYPE) != null) {
            stsClient.setTokenType((String)stsProps.get(STS_TOKEN_TYPE));
        }
        if (stsProps.get(STS_KEY_TYPE) != null) {
            stsClient.setKeyType((String)stsProps.get(STS_KEY_TYPE));
        }
        stsClient.setAllowRenewingAfterExpiry(true);
        if (stsProps.get(STS_ALLOW_RENEWING) != null) {
            stsClient.setAllowRenewing(Boolean.valueOf((String)stsProps.get(STS_ALLOW_RENEWING)).booleanValue());
        }
        return stsClient;
    }

    private static Object processFileURI(Object fileURI) {
        String fileURIName;
        if (fileURI instanceof String && (fileURIName = (String)fileURI).startsWith("file:")) {
            try {
                return new URL(fileURIName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return fileURI;
    }

    private Map<String, Object> getMergedStsProperties() {
        if (this.stsPropertiesOverride == null) {
            if (this.stsProperties == null) {
                return new HashMap<String, Object>();
            }
            return new HashMap<String, Object>(this.stsProperties);
        }
        if (this.stsProperties == null) {
            return new HashMap<String, Object>(this.stsPropertiesOverride);
        }
        HashMap<String, Object> props = new HashMap<String, Object>(this.stsProperties);
        props.putAll(this.stsPropertiesOverride);
        return props;
    }
}

