/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.reflect;

public class JavaVersion {
    public static String getMajor(String version) {
        String[] versionElements = version.split("\\.");
        try {
            String unsureVersion = JavaVersion.strip(versionElements[0]);
            return JavaVersion.isOldNotation(JavaVersion.strip(unsureVersion)) ? JavaVersion.strip(versionElements[1]) : unsureVersion;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "-1";
        }
    }

    public static int getMajorNumber(String version) {
        try {
            return Integer.parseInt(JavaVersion.getMajor(version));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int major() {
        return JavaVersion.getMajorNumber(System.getProperty("java.version"));
    }

    public static String getMinor(String version) {
        String[] versionElements = version.split("\\.");
        try {
            if (versionElements.length == 1) {
                return versionElements[0].indexOf(45) > 0 ? versionElements[0].substring(versionElements[0].indexOf(45) + 1) : "-1";
            }
            String unsureVersion = JavaVersion.strip(versionElements[0]);
            return JavaVersion.isOldNotation(unsureVersion) ? JavaVersion.extractFromOldNotation(versionElements[2], true) : versionElements[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "-1";
        }
    }

    public static int getMinorNumber(String version) {
        try {
            return Integer.parseInt(JavaVersion.strip(JavaVersion.getMinor(version)));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int minor() {
        return JavaVersion.getMinorNumber(System.getProperty("java.version"));
    }

    public static String getRevision(String version) {
        String[] versionElements = version.split("\\.");
        try {
            String unsureVersion = JavaVersion.strip(versionElements[0]);
            return JavaVersion.isOldNotation(unsureVersion) ? JavaVersion.extractFromOldNotation(versionElements[2], false) : versionElements[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "-1";
        }
    }

    public static int getRevisionNumber(String version) {
        try {
            return Integer.parseInt(JavaVersion.strip(JavaVersion.getRevision(version)));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int revision() {
        return JavaVersion.getRevisionNumber(System.getProperty("java.version"));
    }

    private static String strip(String segment) {
        return segment.replaceAll("[-+_].*", "");
    }

    private static boolean isOldNotation(String segment) {
        return "1".equals(segment);
    }

    private static String extractFromOldNotation(String segment, boolean isMinor) {
        return isMinor ? segment.substring(0, segment.indexOf(95)) : segment.substring(segment.indexOf(95) + 1);
    }
}

