/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.internationalization;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.talend.sdk.component.api.internationalization.Language;
import org.talend.sdk.component.runtime.impl.Mode;
import org.talend.sdk.component.runtime.reflect.Defaults;

public class InternationalizationServiceFactory {
    private final Supplier<Locale> localeSupplier;

    public <T> T create(Class<T> api, ClassLoader loader) {
        if (Mode.mode != Mode.UNSAFE) {
            if (!api.isInterface()) {
                throw new IllegalArgumentException(api + " is not an interface");
            }
            if (Stream.of(api.getMethods()).filter(m -> m.getDeclaringClass() != Object.class).anyMatch(m -> m.getReturnType() != String.class)) {
                throw new IllegalArgumentException(api + " methods must return a String");
            }
            if (Stream.of(api.getMethods()).flatMap(m -> Stream.of(m.getParameters())).anyMatch(p -> p.isAnnotationPresent(Language.class) && p.getType() != Locale.class && p.getType() != String.class)) {
                throw new IllegalArgumentException("@Language can only be used with Locale or String.");
            }
        }
        String pck = api.getPackage().getName();
        return api.cast(Proxy.newProxyInstance(loader, new Class[]{api}, (InvocationHandler)new InternationalizedHandler(api.getName() + ".", api.getSimpleName() + ".", (String)(pck == null || pck.isEmpty() ? "" : pck + ".") + "Messages", this.localeSupplier)));
    }

    @Generated
    public InternationalizationServiceFactory(Supplier<Locale> localeSupplier) {
        this.localeSupplier = localeSupplier;
    }

    private static class InternationalizedHandler
    implements InvocationHandler {
        private static final Object[] NO_ARG = new Object[0];
        private final String prefix;
        private final String shortPrefix;
        private final String messages;
        private final Supplier<Locale> localeSupplier;
        private final ConcurrentMap<Locale, ResourceBundle> bundles = new ConcurrentHashMap<Locale, ResourceBundle>();
        private final transient ConcurrentMap<Method, MethodMeta> methods = new ConcurrentHashMap<Method, MethodMeta>();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Defaults.isDefaultAndShouldHandle(method)) {
                return Defaults.handleDefault(method.getDeclaringClass(), method, proxy, args);
            }
            if (Object.class == method.getDeclaringClass()) {
                switch (method.getName()) {
                    case "equals": {
                        return args != null && args.length == 1 && args[0] != null && Proxy.isProxyClass(args[0].getClass()) && this == Proxy.getInvocationHandler(args[0]);
                    }
                    case "hashCode": {
                        return this.hashCode();
                    }
                }
                try {
                    return method.invoke((Object)this, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            MethodMeta methodMeta = this.methods.computeIfAbsent(method, m -> new MethodMeta(this.createLocaleExtractor((Method)m), this.createParameterFactory((Method)m), this.prefix + m.getName(), this.shortPrefix + m.getName(), m.getName()));
            Locale locale = methodMeta.localeExtractor.apply(args);
            String template = this.getTemplate(locale, methodMeta, method.getDeclaringClass().getClassLoader());
            return new MessageFormat(template, locale).format(methodMeta.parameterFactory.apply(args));
        }

        private Function<Object[], Object[]> createParameterFactory(Method method) {
            ArrayList<Integer> included = new ArrayList<Integer>();
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isAnnotationPresent(Language.class)) continue;
                included.add(i);
            }
            if (included.size() == method.getParameterCount()) {
                return Function.identity();
            }
            if (included.size() == 0) {
                return a -> NO_ARG;
            }
            return args -> {
                Object[] modified = new Object[included.size()];
                int current = 0;
                Iterator iterator = included.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    modified[current++] = args[i];
                }
                return modified;
            };
        }

        private Function<Object[], Locale> createLocaleExtractor(Method method) {
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Parameter p2 = parameters[i];
                if (!p2.isAnnotationPresent(Language.class)) continue;
                int idx = i;
                if (String.class == p2.getType()) {
                    return params -> new Locale(Optional.ofNullable(params[idx]).map(String::valueOf).orElse("en"));
                }
                return params -> (Locale)Locale.class.cast(params[idx]);
            }
            return p -> this.localeSupplier.get();
        }

        private String getTemplate(Locale locale, MethodMeta methodMeta, ClassLoader declaringLoader) {
            ResourceBundle bundle;
            try {
                bundle = this.bundles.computeIfAbsent(locale, l -> ResourceBundle.getBundle(this.messages, l, Thread.currentThread().getContextClassLoader()));
            }
            catch (MissingResourceException e) {
                bundle = this.bundles.computeIfAbsent(locale, l -> ResourceBundle.getBundle(this.messages, l, declaringLoader));
            }
            return bundle.containsKey(methodMeta.longName) ? bundle.getString(methodMeta.longName) : (bundle.containsKey(methodMeta.shortName) ? bundle.getString(methodMeta.shortName) : methodMeta.name);
        }

        @Generated
        public InternationalizedHandler(String prefix, String shortPrefix, String messages, Supplier<Locale> localeSupplier) {
            this.prefix = prefix;
            this.shortPrefix = shortPrefix;
            this.messages = messages;
            this.localeSupplier = localeSupplier;
        }
    }

    private static class MethodMeta {
        private final Function<Object[], Locale> localeExtractor;
        private final Function<Object[], Object[]> parameterFactory;
        private final String longName;
        private final String shortName;
        private final String name;

        @Generated
        public MethodMeta(Function<Object[], Locale> localeExtractor, Function<Object[], Object[]> parameterFactory, String longName, String shortName, String name) {
            this.localeExtractor = localeExtractor;
            this.parameterFactory = parameterFactory;
            this.longName = longName;
            this.shortName = shortName;
            this.name = name;
        }
    }
}

