/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.environment;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.junit.environment.EnvironmentConfigurations;
import org.talend.sdk.component.junit.environment.EnvironmentProvider;

public abstract class BaseEnvironmentProvider
implements EnvironmentProvider {
    @Override
    public final AutoCloseable start(Class<?> clazz, Annotation[] annotations) {
        AutoCloseable autoCloseable = Stream.of(annotations).filter(a -> a.annotationType() == EnvironmentConfigurations.class).findFirst().map(config -> {
            EnvironmentConfigurations configurations = (EnvironmentConfigurations)EnvironmentConfigurations.class.cast(config);
            return Stream.of(configurations.value()).filter(c -> c.environment().equals(this.getName()) || c.environment().equals(this.getName().replace("Environment", ""))).findFirst().map(conf -> {
                Collection releases = Stream.of(conf.systemProperties()).map(p -> {
                    String old = System.getProperty(p.key());
                    System.setProperty(p.key(), p.value());
                    return () -> {
                        if (old == null) {
                            System.clearProperty(p.key());
                        } else {
                            System.clearProperty(p.value());
                        }
                    };
                }).collect(Collectors.toList());
                return () -> releases.forEach(Runnable::run);
            }).orElseGet(() -> () -> {});
        }).orElse(() -> {});
        AutoCloseable closeable = this.doStart(clazz, annotations);
        return () -> {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            finally {
                autoCloseable.close();
            }
        };
    }

    public String getName() {
        return this.getClass().getSimpleName().replace("Environment", "");
    }

    protected abstract AutoCloseable doStart(Class<?> var1, Annotation[] var2);
}

