/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.xbean;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.xbean.finder.archive.Archive;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.runtime.manager.xbean.KeepingOpenInputStream;

public class NestedJarArchive
implements Archive,
AutoCloseable {
    private final URL rootMarker;
    private final JarInputStream jarStream;
    private final ConfigurableClassLoader loader;

    public InputStream getBytecode(String className) {
        return this.loader.getResourceAsStream(className);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }

    public Iterator<Archive.Entry> iterator() {
        return new Iterator<Archive.Entry>(){
            private ZipEntry entry;

            @Override
            public boolean hasNext() {
                if (this.entry == null) {
                    try {
                        while ((this.entry = NestedJarArchive.this.jarStream.getNextEntry()) != null && !this.entry.getName().endsWith(".class")) {
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Invalid nested jar", e);
                    }
                }
                return this.entry != null;
            }

            @Override
            public Archive.Entry next() {
                ZipEntry returned = this.entry;
                this.entry = null;
                final String name = returned.getName().replace('.', '/').substring(0, returned.getName().length() - (returned.getName().endsWith(".class") ? ".class".length() : 0));
                return new Archive.Entry(){

                    public String getName() {
                        return name;
                    }

                    public InputStream getBytecode() {
                        return new KeepingOpenInputStream(NestedJarArchive.this.jarStream);
                    }
                };
            }
        };
    }

    @Override
    public void close() throws Exception {
        this.jarStream.close();
    }

    public NestedJarArchive(URL rootMarker, JarInputStream jarStream, ConfigurableClassLoader loader) {
        this.rootMarker = rootMarker;
        this.jarStream = jarStream;
        this.loader = loader;
    }

    public URL getRootMarker() {
        return this.rootMarker;
    }
}

