/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class LazyMap<A, B>
extends ConcurrentHashMap<A, B> {
    private final Function<A, B> lazyFactory;

    public LazyMap(int capacity, Function<A, B> lazyFactory) {
        super(capacity);
        this.lazyFactory = lazyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public B get(Object key) {
        Object value = super.get(key);
        if (value == null) {
            Object castedKey = key;
            LazyMap lazyMap = this;
            synchronized (lazyMap) {
                B created;
                value = super.get(key);
                if (value == null && (created = this.lazyFactory.apply(castedKey)) != null) {
                    this.put(castedKey, created);
                    return created;
                }
            }
        }
        return (B)value;
    }
}

