/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.talend.sdk.component.runtime.manager.ParameterMeta;

public class DefaultValueInspector {
    public Instance createDemoInstance(Object rootInstance, ParameterMeta param) {
        ParameterizedType pt;
        Type rawType;
        Object field;
        if (rootInstance != null && (field = this.findField(rootInstance, param)) != null) {
            return new Instance(field, false);
        }
        Type javaType = param.getJavaType();
        if (Class.class.isInstance(javaType)) {
            return new Instance(this.tryCreatingObjectInstance(javaType), true);
        }
        if (ParameterizedType.class.isInstance(javaType) && Class.class.isInstance(rawType = (pt = (ParameterizedType)ParameterizedType.class.cast(javaType)).getRawType()) && Collection.class.isAssignableFrom((Class)Class.class.cast(rawType)) && pt.getActualTypeArguments().length == 1 && Class.class.isInstance(pt.getActualTypeArguments()[0])) {
            Object instance = this.tryCreatingObjectInstance(pt.getActualTypeArguments()[0]);
            Class collectionType = (Class)Class.class.cast(rawType);
            if (Set.class == collectionType) {
                return new Instance(Collections.singleton(instance), true);
            }
            if (SortedSet.class == collectionType) {
                return new Instance(new TreeSet<Object>(Collections.singletonList(instance)), true);
            }
            if (List.class == collectionType || Collection.class == collectionType) {
                return new Instance(Collections.singletonList(instance), true);
            }
            return null;
        }
        return null;
    }

    public String findDefault(Object instance, ParameterMeta param) {
        if (instance == null) {
            return null;
        }
        ParameterMeta.Type type = param.getType();
        switch (type) {
            case OBJECT: {
                return null;
            }
            case ENUM: {
                return ((Enum)Enum.class.cast(instance)).name();
            }
            case STRING: 
            case NUMBER: 
            case BOOLEAN: {
                return String.valueOf(instance);
            }
            case ARRAY: {
                if (!param.getNestedParameters().isEmpty()) {
                    return null;
                }
                if (Collection.class.isInstance(instance)) {
                    return ((Collection)instance).stream().map(String::valueOf).collect(Collectors.joining(","));
                }
                return String.valueOf(instance);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)param.getType()));
    }

    private Object findField(Object rootInstance, ParameterMeta param) {
        if (param.getPath().startsWith("$") || param.getName().startsWith("$")) {
            return null;
        }
        if (Collection.class.isInstance(rootInstance)) {
            return this.findCollectionField(rootInstance, param);
        }
        for (Class<?> current = rootInstance.getClass(); current != null; current = current.getSuperclass()) {
            try {
                Field declaredField = current.getDeclaredField(this.findName(param));
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                return declaredField.get(rootInstance);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Didn't find field '" + param.getName() + "' in " + rootInstance);
    }

    private Object findCollectionField(Object rootInstance, ParameterMeta param) {
        Collection collection = (Collection)Collection.class.cast(rootInstance);
        if (!collection.isEmpty()) {
            Object next = collection.iterator().next();
            if (param.getPath().endsWith("[${index}]")) {
                return next;
            }
            return this.findField(next, param);
        }
        return null;
    }

    private String findName(ParameterMeta meta) {
        return Optional.ofNullable(meta.getSource()).map(ParameterMeta.Source::name).orElse(meta.getName());
    }

    private Object tryCreatingObjectInstance(Type javaType) {
        Class type = (Class)Class.class.cast(javaType);
        if (type.isPrimitive()) {
            if (Integer.TYPE == type) {
                return 0;
            }
            if (Long.TYPE == type) {
                return 0L;
            }
            if (Double.TYPE == type) {
                return 0.0;
            }
            if (Float.TYPE == type) {
                return Float.valueOf(0.0f);
            }
            if (Short.TYPE == type) {
                return (short)0;
            }
            if (Byte.TYPE == type) {
                return (byte)0;
            }
            if (Boolean.TYPE == type) {
                return false;
            }
            throw new IllegalArgumentException("Not a primitive: " + type);
        }
        if (type.getName().startsWith("java.") || type.getName().startsWith("javax.")) {
            return null;
        }
        try {
            return type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static class Instance {
        private final Object value;
        private final boolean created;

        public Object getValue() {
            return this.value;
        }

        public boolean isCreated() {
            return this.created;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Instance)) {
                return false;
            }
            Instance other = (Instance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCreated() != other.isCreated()) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Instance;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCreated() ? 79 : 97);
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultValueInspector.Instance(value=" + this.getValue() + ", created=" + this.isCreated() + ")";
        }

        private Instance(Object value, boolean created) {
            this.value = value;
            this.created = created;
        }
    }
}

