/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.chain;

import java.util.Optional;
import java.util.function.Consumer;
import org.talend.sdk.component.runtime.input.CheckpointState;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.manager.chain.ChainedMapper;

public final class ChainedInput
implements Input {
    private final ChainedMapper parent;
    private Input delegate = null;
    private Optional<Consumer<CheckpointState>> checkpointStateConsumer = Optional.empty();

    public Object next() {
        while (true) {
            Object next;
            if (this.delegate == null) {
                this.delegate = this.nextDelegate();
                if (this.delegate == null) {
                    return null;
                }
            }
            if ((next = this.delegate.next()) != null) {
                return next;
            }
            this.delegate.stop();
            this.delegate = null;
        }
    }

    public String plugin() {
        return this.parent.plugin();
    }

    public String rootName() {
        return this.parent.rootName();
    }

    public String name() {
        return this.parent.name();
    }

    public void start() {
    }

    public void start(Consumer<CheckpointState> checkpoint) {
        this.checkpointStateConsumer = Optional.of(checkpoint);
    }

    public CheckpointState getCheckpoint() {
        return this.delegate.getCheckpoint();
    }

    public boolean isCheckpointReady() {
        return this.delegate.isCheckpointReady();
    }

    public void stop() {
        if (this.delegate != null) {
            this.delegate.stop();
        }
    }

    private Input nextDelegate() {
        Input localDelegate;
        Input input = localDelegate = this.parent.getIterator().hasNext() ? this.parent.getIterator().next().create() : null;
        if (localDelegate != null) {
            if (this.checkpointStateConsumer.isPresent()) {
                localDelegate.start(this.checkpointStateConsumer.get());
            } else {
                localDelegate.start();
            }
        }
        return localDelegate;
    }

    public ChainedInput(ChainedMapper parent) {
        this.parent = parent;
    }
}

