/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;

@ApplicationScoped
public class IconResolver {
    private static final Logger log = LoggerFactory.getLogger(IconResolver.class);
    @Inject
    private ComponentServerConfiguration componentServerConfiguration;
    private boolean supportsSvg;
    private String defaultTheme;
    private Boolean isThemeSupported;
    private Boolean isLegacyIconsSupported;
    private List<String> patterns;

    @PostConstruct
    protected void init() {
        this.supportsSvg = this.studioSupportsSvgOrTrue() != false && this.componentServerConfiguration.getIconExtensions().stream().anyMatch(it -> it.endsWith(".svg"));
        this.isThemeSupported = this.componentServerConfiguration.getSupportIconTheme();
        this.isLegacyIconsSupported = this.componentServerConfiguration.getSupportLegacyIcons();
        this.defaultTheme = this.componentServerConfiguration.getIconDefaultTheme();
        this.patterns = this.isSupportsSvg() ? this.componentServerConfiguration.getIconExtensions() : this.componentServerConfiguration.getIconExtensions().stream().filter(it -> !it.endsWith(".svg")).collect(Collectors.toList());
        log.info("[IconResolver] SVG supported: {}, patterns: {}.", (Object)this.isSupportsSvg(), this.patterns);
    }

    private Boolean studioSupportsSvgOrTrue() {
        if (System.getProperty("talend.studio.version") != null) {
            return Boolean.getBoolean("talend.component.server.icon.svg.support");
        }
        return true;
    }

    protected boolean isSupportsSvg() {
        return this.supportsSvg;
    }

    protected Collection<String> getExtensionPreferences() {
        return this.patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon resolve(Container container, String icon, String theme) {
        if (icon == null) {
            return null;
        }
        Cache cache = (Cache)container.get(Cache.class);
        if (cache == null) {
            Container container2 = container;
            synchronized (container2) {
                cache = (Cache)container.get(Cache.class);
                if (cache == null) {
                    cache = new Cache();
                    container.set(Cache.class, (Object)cache);
                }
            }
        }
        ClassLoader appLoader = Thread.currentThread().getContextClassLoader();
        if (this.isThemeSupported.booleanValue()) {
            String appliedTheme = theme != null ? theme : this.defaultTheme;
            String themedIcon = appliedTheme + "/" + icon;
            Icon themed = cache.icons.computeIfAbsent(themedIcon, k -> Optional.ofNullable(this.getOverridenIcon(icon, appLoader).orElseGet(() -> this.doLoad((ClassLoader)container.getLoader(), themedIcon, appliedTheme).orElseGet(() -> this.doLoad(appLoader, themedIcon, appliedTheme).orElse(null))))).orElse(null);
            if (themed == null && this.isLegacyIconsSupported.booleanValue()) {
                themed = cache.icons.computeIfAbsent(icon, k -> Optional.ofNullable(this.doLoad((ClassLoader)container.getLoader(), icon, "").orElseGet(() -> this.doLoad(appLoader, icon, "").orElse(null)))).orElse(null);
            }
            return themed;
        }
        return cache.icons.computeIfAbsent(icon, k -> Optional.ofNullable(this.getOverridenIcon(icon, appLoader).orElseGet(() -> this.doLoad((ClassLoader)container.getLoader(), icon, "").orElseGet(() -> this.doLoad(appLoader, icon, "").orElse(null))))).orElse(null);
    }

    private Optional<Icon> getOverridenIcon(String icon, ClassLoader appLoader) {
        Icon result = null;
        if (this.isSupportsSvg()) {
            result = this.loadIcon(appLoader, "icons/override/" + icon + ".svg", "").orElse(null);
        }
        if (result == null) {
            return this.loadIcon(appLoader, "icons/override/" + icon + "_icon32.png", "");
        }
        return Optional.of(result);
    }

    public Optional<Icon> doLoad(ClassLoader loader, String icon, String theme) {
        return this.getExtensionPreferences().stream().map(ext -> String.format(ext, icon)).map(path -> this.loadIcon(loader, (String)path, theme)).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
    }

    private Optional<Icon> loadIcon(ClassLoader loader, String path, String theme) {
        return Optional.ofNullable(loader.getResourceAsStream(path)).map(resource -> new Icon(this.getType(path.toLowerCase(Locale.ROOT)), this.toBytes((InputStream)resource), theme));
    }

    private String getType(String path) {
        if (path.endsWith(".png")) {
            return "image/png";
        }
        if (path.endsWith(".svg")) {
            return "image/svg+xml";
        }
        throw new IllegalArgumentException("Unsupported icon type: " + path);
    }

    private byte[] toBytes(InputStream resource) {
        byte[] byArray;
        BufferedInputStream stream = new BufferedInputStream(resource);
        try {
            int read;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(stream.available());
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer, 0, buffer.length)) >= 0) {
                if (read <= 0) continue;
                byteArrayOutputStream.write(buffer, 0, read);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        stream.close();
        return byArray;
    }

    public static class Cache {
        private final ConcurrentMap<String, Optional<Icon>> icons = new ConcurrentHashMap<String, Optional<Icon>>();
    }

    public static class Icon {
        private final String type;
        private final byte[] bytes;
        private final String theme;

        public Icon(String type, byte[] bytes, String theme) {
            this.type = type;
            this.bytes = bytes;
            this.theme = theme;
        }

        public String getType() {
            return this.type;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String getTheme() {
            return this.theme;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Icon)) {
                return false;
            }
            Icon other = (Icon)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            if (!Arrays.equals(this.getBytes(), other.getBytes())) {
                return false;
            }
            String this$theme = this.getTheme();
            String other$theme = other.getTheme();
            return !(this$theme == null ? other$theme != null : !this$theme.equals(other$theme));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Icon;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + Arrays.hashCode(this.getBytes());
            String $theme = this.getTheme();
            result = result * 59 + ($theme == null ? 43 : $theme.hashCode());
            return result;
        }

        public String toString() {
            return "IconResolver.Icon(type=" + this.getType() + ", bytes=" + Arrays.toString(this.getBytes()) + ", theme=" + this.getTheme() + ")";
        }
    }
}

