/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.enterprise.event.NotificationOptions;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.extension.api.ExtensionRegistrar;
import org.talend.sdk.component.server.extension.api.action.Action;
import org.talend.sdk.component.server.front.model.ComponentDetail;
import org.talend.sdk.component.server.front.model.ComponentId;
import org.talend.sdk.component.server.front.model.ConfigTypeNode;
import org.talend.sdk.component.server.front.model.DependencyDefinition;
import org.talend.sdk.component.server.front.model.Link;

@ApplicationScoped
public class ExtensionComponentMetadataManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionComponentMetadataManager.class);
    private static final String EXTENSION_MARKER = "extension::";
    @Inject
    private Event<ExtensionRegistrar> extensionsEvent;
    private final Collection<Runnable> waiters = new ArrayList<Runnable>();
    private final Map<String, ComponentDetail> details = new LinkedHashMap<String, ComponentDetail>();
    private final Map<String, ConfigTypeNode> configurations = new LinkedHashMap<String, ConfigTypeNode>();
    private final Map<String, DependencyDefinition> dependencies = new LinkedHashMap<String, DependencyDefinition>();
    private final Map<ActionKey, Action> actions = new LinkedHashMap<ActionKey, Action>();

    public void startupLoad(@Observes @Initialized(value=ApplicationScoped.class) Object start, final ComponentServerConfiguration configuration) {
        try {
            this.extensionsEvent.fireAsync((Object)new ExtensionRegistrar(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void registerAwait(Runnable waiter) {
                    Collection<Runnable> collection = ExtensionComponentMetadataManager.this.waiters;
                    synchronized (collection) {
                        ExtensionComponentMetadataManager.this.waiters.add(waiter);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void registerActions(Collection<Action> userActions) {
                    Map actionMap = userActions.stream().collect(Collectors.toMap(it -> new ActionKey(it.getReference().getFamily(), it.getReference().getType(), it.getReference().getName()), Function.identity()));
                    Map<ActionKey, Action> map = ExtensionComponentMetadataManager.this.actions;
                    synchronized (map) {
                        ExtensionComponentMetadataManager.this.actions.putAll(actionMap);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void registerComponents(Collection<ComponentDetail> components) {
                    Map mapped = components.stream().map(it -> new ComponentDetail(new ComponentId(it.getId().getId(), ExtensionComponentMetadataManager.EXTENSION_MARKER + it.getId().getFamilyId(), ExtensionComponentMetadataManager.EXTENSION_MARKER + it.getId().getPlugin(), ExtensionComponentMetadataManager.EXTENSION_MARKER + it.getId().getPluginLocation(), it.getId().getFamily(), it.getId().getName()), it.getDisplayName(), it.getIcon(), it.getType(), it.getVersion(), it.getProperties(), it.getActions(), it.getInputFlows(), it.getOutputFlows(), (Collection)Stream.concat(ExtensionComponentMetadataManager.this.createBuiltInLinks((ComponentDetail)it), it.getLinks() == null ? Stream.empty() : it.getLinks().stream()).distinct().collect(Collectors.toList()), Collections.singletonMap("mapper::infinite", "false"))).collect(Collectors.toMap(it -> it.getId().getId(), Function.identity(), (a, b) -> {
                        throw new IllegalArgumentException(a + " and " + b + " are conflicting");
                    }, LinkedHashMap::new));
                    Map<String, ComponentDetail> map = ExtensionComponentMetadataManager.this.details;
                    synchronized (map) {
                        ExtensionComponentMetadataManager.this.details.putAll(mapped);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void registerConfigurations(Collection<ConfigTypeNode> configs) {
                    Map mapped = configs.stream().collect(Collectors.toMap(ConfigTypeNode::getId, Function.identity(), (a, b) -> {
                        throw new IllegalArgumentException(a + " and " + b + " are conflicting");
                    }, LinkedHashMap::new));
                    Map<String, ConfigTypeNode> map = ExtensionComponentMetadataManager.this.configurations;
                    synchronized (map) {
                        ExtensionComponentMetadataManager.this.configurations.putAll(mapped);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void registerDependencies(Map<String, DependencyDefinition> deps) {
                    Map<String, DependencyDefinition> map = ExtensionComponentMetadataManager.this.dependencies;
                    synchronized (map) {
                        ExtensionComponentMetadataManager.this.dependencies.putAll(deps);
                    }
                }

                public void createExtensionJarIfNotExist(String groupId, String artifactId, String version, Consumer<JarOutputStream> creator) {
                    String m2 = configuration.getExtensionMavenRepository().orElseThrow(() -> new IllegalArgumentException("No extension maven repository configured"));
                    Path path = PathFactory.get((String)m2);
                    Path jar = path.resolve(groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".jar");
                    if (Files.exists(jar, new LinkOption[0])) {
                        return;
                    }
                    try {
                        if (!Files.isDirectory(jar.getParent(), new LinkOption[0])) {
                            Files.createDirectories(jar.getParent(), new FileAttribute[0]);
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Can't create extension artifact " + groupId + ":" + artifactId + ":" + version, e);
                    }
                    try (JarOutputStream stream = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(jar, StandardOpenOption.CREATE, StandardOpenOption.WRITE)));){
                        creator.accept(stream);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }, NotificationOptions.ofExecutor(r -> {
                Thread thread = new Thread(r, this.getClass().getName() + "-extension-registrar");
                thread.start();
            })).toCompletableFuture().get(configuration.getExtensionsStartupTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Can't initialize extensions withing " + TimeUnit.MILLISECONDS.toSeconds(configuration.getExtensionsStartupTimeout()) + "s");
        }
    }

    private Stream<Link> createBuiltInLinks(ComponentDetail componentDetail) {
        return Stream.of(new Link("Detail", "/component/details?identifiers=" + componentDetail.getId().getId(), "application/json"));
    }

    public String getFamilyIconFor(String familyId) {
        if (!this.isExtensionEntity(familyId)) {
            throw new IllegalArgumentException(familyId + " is not a virtual family");
        }
        return familyId.replace("::", "_");
    }

    public boolean isExtensionEntity(String id) {
        return this.details.containsKey(id) || id.startsWith(EXTENSION_MARKER);
    }

    public Optional<Action> getAction(String family, String type, String name) {
        this.waitAndClearWaiters();
        return Optional.ofNullable(this.actions.get(new ActionKey(family, type, name)));
    }

    public Collection<Action> getActions() {
        this.waitAndClearWaiters();
        return this.actions.values();
    }

    public Collection<ConfigTypeNode> getConfigurations() {
        this.waitAndClearWaiters();
        return this.configurations.values();
    }

    public Collection<ComponentDetail> getDetails() {
        this.waitAndClearWaiters();
        return this.details.values();
    }

    public Optional<ComponentDetail> findComponentById(String id) {
        this.waitAndClearWaiters();
        return Optional.ofNullable(this.details.get(id));
    }

    public DependencyDefinition getDependenciesFor(String id) {
        this.waitAndClearWaiters();
        return this.dependencies.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAndClearWaiters() {
        if (this.waiters.isEmpty()) {
            return;
        }
        Collection<Runnable> collection = this.waiters;
        synchronized (collection) {
            if (this.waiters.isEmpty()) {
                return;
            }
            this.waiters.forEach(Runnable::run);
            this.waiters.clear();
        }
    }

    private static class ActionKey {
        private final String family;
        private final String type;
        private final String name;
        private final int hash;

        private ActionKey(String family, String type, String name) {
            this.family = family;
            this.type = type;
            this.name = name;
            this.hash = Objects.hash(family, type, name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionKey actionKey = (ActionKey)ActionKey.class.cast(o);
            return this.hash == actionKey.hash && this.family.equals(actionKey.family) && this.type.equals(actionKey.type) && this.name.equals(actionKey.name);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

