/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.processors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CmdGroup;
import org.tomitribe.crest.cmds.CmdMethod;
import org.tomitribe.crest.cmds.OverloadedCmdMethod;
import org.tomitribe.crest.cmds.targets.SimpleBean;
import org.tomitribe.crest.cmds.targets.Target;
import org.tomitribe.crest.contexts.DefaultsContext;
import org.tomitribe.crest.contexts.SystemPropertiesDefaultsContext;
import org.tomitribe.util.Strings;
import org.tomitribe.util.collect.FilteredIterable;
import org.tomitribe.util.collect.FilteredIterator;
import org.tomitribe.util.reflect.Reflection;

public class Commands {
    private Commands() {
    }

    public static Iterable<Method> commands(Class<?> clazz) {
        return new FilteredIterable(Reflection.methods(clazz), (FilteredIterator.Filter)new FilteredIterator.Filter<Method>(){

            public boolean accept(Method method) {
                return method.isAnnotationPresent(Command.class);
            }
        });
    }

    public static Map<String, Cmd> get(Object bean) {
        return Commands.get(bean.getClass(), new SimpleBean(bean), new SystemPropertiesDefaultsContext());
    }

    public static Map<String, Cmd> get(Object bean, DefaultsContext dc) {
        return Commands.get(bean.getClass(), new SimpleBean(bean), dc);
    }

    public static Map<String, Cmd> get(Class<?> clazz) {
        return Commands.get(clazz, new SimpleBean(null), new SystemPropertiesDefaultsContext());
    }

    public static Map<String, Cmd> get(Class<?> clazz, DefaultsContext dc) {
        return Commands.get(clazz, new SimpleBean(null), dc);
    }

    public static Map<String, Cmd> get(Class<?> clazz, Target target, DefaultsContext dc) {
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null");
        }
        HashMap<String, Cmd> map = new HashMap<String, Cmd>();
        for (Method method : Commands.commands(clazz)) {
            OverloadedCmdMethod overloaded;
            CmdMethod cmd = new CmdMethod(method, target, dc);
            Cmd existing = (Cmd)map.get(cmd.getName());
            if (existing == null) {
                map.put(cmd.getName(), cmd);
                continue;
            }
            if (existing instanceof OverloadedCmdMethod) {
                overloaded = (OverloadedCmdMethod)existing;
                overloaded.add(cmd);
                continue;
            }
            overloaded = new OverloadedCmdMethod(cmd.getName());
            overloaded.add((CmdMethod)existing);
            overloaded.add(cmd);
            map.put(overloaded.getName(), overloaded);
        }
        if (clazz.isAnnotationPresent(Command.class)) {
            CmdGroup cmdGroup = new CmdGroup(clazz, map);
            HashMap<String, Cmd> group = new HashMap<String, Cmd>();
            group.put(cmdGroup.getName(), cmdGroup);
            return group;
        }
        return map;
    }

    public static String name(Method method) {
        Command command = method.getAnnotation(Command.class);
        if (command == null) {
            return method.getName();
        }
        return Commands.value(command.value(), method.getName());
    }

    public static String name(Class<?> clazz) {
        Command command = clazz.getAnnotation(Command.class);
        String defaultName = Strings.lcfirst((String)clazz.getSimpleName());
        if (command == null) {
            return defaultName;
        }
        return Commands.value(command.value(), defaultName);
    }

    public static String value(String value, String defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : value;
    }

    public static Iterable<Class<?>> load() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        LinkedHashSet classes = new LinkedHashSet();
        Commands.addAll(classes, ServiceLoader.load(Loader.class, loader).iterator());
        Commands.addAll(classes, ServiceLoader.load(org.tomitribe.crest.api.Loader.class, loader).iterator());
        for (String prefix : Arrays.asList("", "/")) {
            try {
                Enumeration<URL> urls = loader.getResources(prefix + "crest-commands.txt");
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try {
                        InputStream stream = url.openStream();
                        Throwable throwable = null;
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                            Throwable throwable2 = null;
                            try {
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    line = Commands.normalize(line);
                                    try {
                                        classes.add(loader.loadClass(line));
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {}
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException iOException) {
            }
        }
        return classes;
    }

    private static String normalize(String line) {
        if ((line = line.trim()).startsWith("class ")) {
            line = line.substring(5).trim();
        }
        return line;
    }

    private static void addAll(LinkedHashSet<Class<?>> classes, Iterator<? extends Iterable<Class<?>>> all) {
        while (all.hasNext()) {
            Iterable<Class<?>> c = all.next();
            for (Class<?> clazz : c) {
                classes.add(clazz);
            }
        }
    }

    @Deprecated
    public static interface Loader
    extends Iterable<Class<?>> {
    }
}

